/***
 * OW2 FraSCAti Servlet CXF
 * Copyright (C) 2009-2010 INRIA, University of Lille 1
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: frascati@ow2.org
 *
 * Author: Philippe Merle
 *
 * Contributor(s):
 */

package org.ow2.frascati.servlet;

import java.util.logging.Logger;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;

import org.apache.cxf.transport.servlet.CXFServlet;

import org.ow2.frascati.FraSCAti;
import org.ow2.frascati.assembly.factory.Launcher;
import org.ow2.frascati.assembly.factory.processor.AbstractBindingProcessor;
import org.ow2.frascati.util.FrascatiException;

/**
 * OW2 FraSCAti Servlet extending the Apache CXF Servlet ({@link CXFServlet}).
 *
 * @author Philippe Merle
 *
 */
public class FraSCAtiServlet extends CXFServlet {

  /**
   * Logger.
   */
  private Logger log = Logger.getLogger(this.getClass().getCanonicalName());

  /**
   * Initialization of the servlet and launches SCA composites if any.
   */
  @Override
  public final void init(ServletConfig servletConfig) throws ServletException {
    log.fine("OW2 FraSCAti Servlet - Initialization...");
    // Init the CXF servlet.
    super.init(servletConfig);

    // Set that no prefix is added to <sca:binding uri>.
	AbstractBindingProcessor.setEmptyBindingURIBase();

    // Get the list of composites to launch.
    String composite = servletConfig.getInitParameter("composite");
    if(composite == null) {
      log.warning("OW2 FraSCAti Servlet - No SCA composites to launch.");
    } else {
      // SCA composites are separated by spaces.
      String[] composites = composite.split(" ");
      // Launch SCA composites.
      launch(composites);
    }
  }

  /**
   * Launch SCA composites.
   *
   * @param composites The SCA composites to launch.
   */
  protected void launch(String[] composites) {
    try {
      FraSCAti frascati = FraSCAti.newFraSCAti();
      for(String composite : composites) {
        log.fine("OW2 FraSCAti Servlet - Launching SCA composite '" + composite + "'...");
        // Use the Launcher for launching composites.
    	Launcher launcher = new Launcher(composite, frascati);
        launcher.launch();
        log.fine("OW2 FraSCAti Servlet - '" + composite + "' launched.");
      }
    } catch (FrascatiException e) {
      log.severe("Cannot instanciate FraSCAti!");
    }
  }
}
