/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.servlet;

import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.cxf.transport.servlet.CXFServlet;
import org.ow2.frascati.FraSCAti;
import org.ow2.frascati.assembly.factory.Launcher;
import org.ow2.frascati.assembly.factory.processor.AbstractBindingProcessor;
import org.ow2.frascati.util.FrascatiException;

public class FraSCAtiServlet
extends CXFServlet {
    private Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getCanonicalName());

    public final void init(ServletConfig servletConfig) throws ServletException {
        this.log.fine("OW2 FraSCAti Servlet - Initialization...");
        super.init(servletConfig);
        AbstractBindingProcessor.setEmptyBindingURIBase();
        String composite = servletConfig.getInitParameter("composite");
        if (composite == null) {
            this.log.warning("OW2 FraSCAti Servlet - No SCA composites to launch.");
        } else {
            String[] composites = composite.split(" ");
            this.launch(composites);
        }
    }

    protected void launch(String[] composites) {
        try {
            FraSCAti frascati = FraSCAti.newFraSCAti();
            for (String composite : composites) {
                this.log.fine("OW2 FraSCAti Servlet - Launching SCA composite '" + composite + "'...");
                Launcher launcher = new Launcher(composite, frascati);
                launcher.launch();
                this.log.fine("OW2 FraSCAti Servlet - '" + composite + "' launched.");
            }
        }
        catch (FrascatiException e) {
            this.log.severe("Cannot instanciate FraSCAti!");
        }
    }
}

