/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.jdom;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.ow2.frascati.jaxb.JAXB;

public abstract class JDOM {
    public static final Namespace XSD_NS = Namespace.getNamespace((String)"xsd", (String)"http://www.w3.org/2001/XMLSchema");
    public static final Namespace XSI_NS = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");

    private JDOM() {
    }

    public static Element toElement(String xmlMessage) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(xmlMessage.getBytes());
            SAXBuilder saxBuilder = new SAXBuilder();
            Document jdomDocument = saxBuilder.build((InputStream)bais);
            return jdomDocument.getRootElement();
        }
        catch (JDOMException je) {
            throw new Error("Should not happen", je);
        }
        catch (IOException ioe) {
            throw new Error("Should not happen", ioe);
        }
    }

    public static String toString(Element element) {
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        return outputter.outputString(element);
    }

    public static Object unmarshall(Element element) throws Exception {
        Element content0 = (Element)element.getContent().get(0);
        Object result = JDOM.unmarshallContent0(content0);
        if (result == null) {
            QName qname = new QName(content0.getNamespace().getURI(), content0.getName());
            result = JAXB.unmarshall(qname, JDOM.toString(content0), null);
        }
        return result;
    }

    public static Object unmarshallContent0(Element element) {
        Content content0 = (Content)element.getContent().get(0);
        if (content0 instanceof Text) {
            String value = ((Text)content0).getText();
            String type = element.getAttribute("type", XSI_NS).getValue();
            if (type.endsWith("string")) {
                return value;
            }
            if (type.endsWith("int")) {
                return Integer.valueOf(value);
            }
        }
        return null;
    }
}

