/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.wsdl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import javax.jws.WebResult;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import org.jdom.Element;
import org.ow2.frascati.jaxb.JAXB;
import org.ow2.frascati.jdom.JDOM;
import org.ow2.frascati.wsdl.AbstractWsdl;

public abstract class AbstractWsdlInvocationHandler
extends AbstractWsdl
implements InvocationHandler {
    protected final String marshallInvocation(Method method, Object[] args) throws Exception {
        if (args.length != 1) {
            throw new IllegalArgumentException("Only methods with one argument are supported, given method is " + method + " and argument length is " + args.length);
        }
        QName qname = AbstractWsdlInvocationHandler.getQNameOfFirstArgument(method);
        return JAXB.marshall(qname, args[0]);
    }

    protected final Object unmarshallResult(Method method, Object[] args, Element element) throws Exception {
        SOAPBinding soapBinding = method.getDeclaringClass().getAnnotation(SOAPBinding.class);
        if (soapBinding != null) {
            this.log.fine("@SOAPBinding for " + method);
            if (soapBinding.style() == SOAPBinding.Style.DOCUMENT) {
                this.log.fine("@SOAPBinding(style=SOAPBinding.Style.DOCUMENT) for " + method);
                if (soapBinding.parameterStyle() == SOAPBinding.ParameterStyle.BARE) {
                    this.log.fine("@SOAPBinding(parameterStyle=SOAPBinding.ParameterStyle.BARE) for " + method);
                    Object result = JDOM.unmarshallContent0(element);
                    WebResult wr = method.getAnnotation(WebResult.class);
                    if (wr != null) {
                        return result;
                    }
                    if (args[0].getClass() == Holder.class) {
                        ((Holder)args[0]).value = result;
                        return null;
                    }
                }
                this.log.fine("@SOAPBinding(parameterStyle=SOAPBinding.ParameterStyle.WRAPPED) for " + method);
                String targetNamespace = null;
                String name = "";
                WebResult wr = method.getAnnotation(WebResult.class);
                if (wr != null) {
                    this.log.fine("@WebResult for " + method);
                    targetNamespace = wr.targetNamespace();
                    name = wr.name();
                }
                if (targetNamespace == null || targetNamespace.equals("")) {
                    targetNamespace = AbstractWsdlInvocationHandler.getTargetNamespace(method);
                }
                String xmlMessage = JDOM.toString(element);
                this.log.fine("xmlMessage = " + xmlMessage);
                return JAXB.unmarshall(new QName(targetNamespace, name), xmlMessage, args[0]);
            }
            if (soapBinding.style() == SOAPBinding.Style.RPC) {
                this.log.fine("@SOAPBinding(style=SOAPBinding.Style.RPC) for " + method);
                return JDOM.unmarshall(element);
            }
        }
        return null;
    }
}

