/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.jdom;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.ow2.frascati.jaxb.JAXB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JDOM {
    private JDOM() {
    }

    public static Element toElement(String xmlMessage) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(xmlMessage.getBytes());
            SAXBuilder saxBuilder = new SAXBuilder();
            Document jdomDocument = saxBuilder.build((InputStream)bais);
            return jdomDocument.getRootElement();
        }
        catch (JDOMException je) {
            throw new Error("Should not happen on the XML message " + xmlMessage, je);
        }
        catch (IOException ioe) {
            throw new Error("Should not happen on the XML message " + xmlMessage, ioe);
        }
    }

    public static String toString(Element element) {
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        return outputter.outputString(element);
    }

    public static Object unmarshallElement0(Element element, Class<?> type) throws Exception {
        Element element0 = (Element)element.getContent().get(0);
        return JDOM.unmarshallContent0(element0, type);
    }

    public static Object unmarshallContent0(Element element, Class<?> type) throws Exception {
        Content content0 = (Content)element.getContent().get(0);
        if (content0 instanceof Element) {
            QName qname = new QName(element.getNamespace().getURI(), element.getName());
            return JAXB.unmarshall(qname, JDOM.toString(element), null);
        }
        if (content0 instanceof Text) {
            String value = ((Text)content0).getText();
            if (type.equals(String.class)) {
                return value;
            }
            if (type.equals(Integer.TYPE)) {
                return Integer.valueOf(value);
            }
            if (type.equals(Boolean.TYPE)) {
                return Boolean.valueOf(value);
            }
        }
        return null;
    }
}

