/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.wsdl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.jws.Oneway;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;
import org.jdom.Element;
import org.ow2.frascati.jaxb.JAXB;
import org.ow2.frascati.jdom.JDOM;
import org.ow2.frascati.wsdl.AbstractWsdlDelegate;

class DocumentWsdlDelegate
extends AbstractWsdlDelegate {
    DocumentWsdlDelegate() {
    }

    protected static String firstCharacterUpperCase(String value) {
        return Character.toUpperCase(value.charAt(0)) + value.substring(1);
    }

    protected static Object invokeGetter(Object object, String getterName) throws Exception {
        Method getter = object.getClass().getMethod("get" + DocumentWsdlDelegate.firstCharacterUpperCase(getterName), null);
        return getter.invoke(object, new Object[0]);
    }

    protected static void invokeSetter(Object object, String setterName, Object value) throws Exception {
        Method setter = DocumentWsdlDelegate.getMethod(object.getClass(), "set" + DocumentWsdlDelegate.firstCharacterUpperCase(setterName));
        setter.invoke(object, value);
    }

    public String invoke(Method method, String xmlMessage) throws Exception {
        QName qname;
        this.log.fine("xmlMessage = " + xmlMessage);
        Class<?>[] methodParameterTypes = method.getParameterTypes();
        Annotation[][] pa = method.getParameterAnnotations();
        Object[] parameters = new Object[methodParameterTypes.length];
        RequestWrapper rw = method.getAnnotation(RequestWrapper.class);
        if (rw != null) {
            this.log.fine("@RequestWrapper for " + method);
            qname = new QName(rw.targetNamespace(), rw.localName());
            Object request = JAXB.unmarshall(qname, xmlMessage, null);
            this.log.fine("request = " + request);
            for (int i = 0; i < methodParameterTypes.length; ++i) {
                WebParam wp = (WebParam)pa[i][0];
                WebParam.Mode wpMode = wp.mode();
                if (wpMode == WebParam.Mode.IN) {
                    parameters[i] = DocumentWsdlDelegate.invokeGetter(request, wp.name());
                    continue;
                }
                if (wpMode == WebParam.Mode.OUT) {
                    parameters[i] = new Holder();
                    continue;
                }
                if (wpMode != WebParam.Mode.INOUT) continue;
                Holder holder = new Holder();
                holder.value = DocumentWsdlDelegate.invokeGetter(request, wp.name());
                parameters[i] = holder;
            }
        } else {
            this.log.fine("no @RequestWrapper for " + method);
            qname = DocumentWsdlDelegate.getQNameOfFirstArgument(method);
            if (methodParameterTypes[0] == Holder.class) {
                parameters[0] = new Holder();
            }
            parameters[0] = JAXB.unmarshall(qname, xmlMessage, parameters[0]);
        }
        Object result = method.invoke(this.delegate, parameters);
        this.log.fine("result = " + result);
        if (method.getAnnotation(Oneway.class) != null) {
            this.log.fine("@Oneway for " + method);
            return null;
        }
        ResponseWrapper rrw = method.getAnnotation(ResponseWrapper.class);
        if (rrw != null) {
            this.log.fine("@ResponseWrapper for " + method);
            Class<?> responseClass = Thread.currentThread().getContextClassLoader().loadClass(rrw.className());
            Object response = responseClass.newInstance();
            WebResult wr = method.getAnnotation(WebResult.class);
            if (wr != null) {
                this.log.fine("@WebResult(name=" + wr.name() + ") for " + method);
                DocumentWsdlDelegate.invokeSetter(response, wr.name(), result);
            }
            for (int i = 0; i < methodParameterTypes.length; ++i) {
                WebParam wp = (WebParam)pa[i][0];
                if (wp.mode() == WebParam.Mode.IN) continue;
                this.log.fine("@WebParam(mode=" + wp.mode() + ") for " + method);
                Object value = ((Holder)parameters[i]).value;
                DocumentWsdlDelegate.invokeSetter(response, wp.name(), value);
            }
            this.log.fine("response = " + response);
            String reply = JAXB.marshall(new QName(rrw.targetNamespace(), rrw.localName()), response);
            this.log.fine("reply = " + reply);
            return reply;
        }
        this.log.fine("No @ResponseWrapper for " + method);
        QName qname2 = null;
        WebResult wr = method.getAnnotation(WebResult.class);
        if (wr != null) {
            qname2 = new QName(wr.targetNamespace(), wr.name());
        } else if (methodParameterTypes[0] == Holder.class) {
            qname2 = DocumentWsdlDelegate.getQNameOfFirstArgument(method);
            result = ((Holder)parameters[0]).value;
        }
        if (qname2 != null) {
            String reply = JAXB.marshall(qname2, result);
            this.log.fine("reply = " + reply);
            return reply;
        }
        return null;
    }

    public Element invoke(Method method, Element element) throws Exception {
        String request = JDOM.toString(element);
        String response = this.invoke(method, request);
        return response != null ? JDOM.toElement(response) : null;
    }
}

