/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.util;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalContentException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.api.control.NameController;
import org.objectweb.fractal.util.Fractal;
import org.ow2.frascati.util.AbstractLoggeable;
import org.ow2.frascati.util.FrascatiException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFractalLoggeable<ExceptionType extends FrascatiException>
extends AbstractLoggeable {
    protected abstract ExceptionType newException(String var1);

    protected final BindingController getFractalBindingController(Component component) throws ExceptionType {
        try {
            return Fractal.getBindingController((Component)component);
        }
        catch (NoSuchInterfaceException nsie) {
            ExceptionType exc = this.newException("Can not get the Fractal binding controller");
            ((Throwable)exc).initCause(nsie);
            this.severe(exc);
            return null;
        }
    }

    protected final void bindFractalComponent(BindingController bindingController, String interfaceName, Object value) throws ExceptionType {
        try {
            bindingController.bindFc(interfaceName, value);
        }
        catch (NoSuchInterfaceException nsie) {
            ExceptionType exc = this.newException("Can not bind the Fractal component");
            ((Throwable)exc).initCause(nsie);
            this.severe(exc);
        }
        catch (IllegalBindingException ibe) {
            ExceptionType exc = this.newException("Can not bind the Fractal component");
            ((Throwable)exc).initCause(ibe);
            this.severe(exc);
        }
        catch (IllegalLifeCycleException ilce) {
            ExceptionType exc = this.newException("Can not bind the Fractal component");
            ((Throwable)exc).initCause(ilce);
            this.severe(exc);
        }
    }

    protected final void bindFractalComponent(Component component, String interfaceName, Object value) throws ExceptionType {
        this.bindFractalComponent(this.getFractalBindingController(component), interfaceName, value);
    }

    protected final Object getFractalInterface(Component component, String interfaceName) throws ExceptionType {
        try {
            return component.getFcInterface(interfaceName);
        }
        catch (NoSuchInterfaceException nsie) {
            ExceptionType exc = this.newException("Can not get the Fractal interface '" + interfaceName + "'");
            ((Throwable)exc).initCause(nsie);
            this.severe(exc);
            return null;
        }
    }

    protected final ContentController getFractalContentController(Component component) throws ExceptionType {
        try {
            return Fractal.getContentController((Component)component);
        }
        catch (NoSuchInterfaceException nsie) {
            ExceptionType exc = this.newException("Can not get the Fractal content controller");
            ((Throwable)exc).initCause(nsie);
            this.severe(exc);
            return null;
        }
    }

    protected final Object getFractalInternalInterface(ContentController contentController, String interfaceName) throws ExceptionType {
        try {
            return contentController.getFcInternalInterface(interfaceName);
        }
        catch (NoSuchInterfaceException nsie) {
            ExceptionType exc = this.newException("Can not get the Fractal internal interface '" + interfaceName + "'");
            ((Throwable)exc).initCause(nsie);
            this.severe(exc);
            return null;
        }
    }

    protected final Object getFractalInternalInterface(Component component, String interfaceName) throws ExceptionType {
        return this.getFractalInternalInterface(this.getFractalContentController(component), interfaceName);
    }

    protected final Component[] getFractalSubComponents(ContentController contentController) throws ExceptionType {
        return contentController.getFcSubComponents();
    }

    protected final Component[] getFractalSubComponents(Component composite) throws ExceptionType {
        return this.getFractalSubComponents(this.getFractalContentController(composite));
    }

    protected final void addFractalSubComponent(ContentController contentController, Component component) throws ExceptionType {
        try {
            contentController.addFcSubComponent(component);
        }
        catch (IllegalContentException ice) {
            ExceptionType exc = this.newException("Can not add a Fractal sub component");
            ((Throwable)exc).initCause(ice);
            this.severe(exc);
        }
        catch (IllegalLifeCycleException ilce) {
            ExceptionType exc = this.newException("Can not add a Fractal sub component");
            ((Throwable)exc).initCause(ilce);
            this.severe(exc);
        }
    }

    protected final void addFractalSubComponent(Component composite, Component component) throws ExceptionType {
        this.addFractalSubComponent(this.getFractalContentController(composite), component);
    }

    protected final void removeFractalSubComponent(ContentController contentController, Component component) throws ExceptionType {
        try {
            contentController.removeFcSubComponent(component);
        }
        catch (IllegalContentException ice) {
            ExceptionType exc = this.newException("Can not remove a Fractal sub component");
            ((Throwable)exc).initCause(ice);
            this.severe(exc);
        }
        catch (IllegalLifeCycleException ilce) {
            ExceptionType exc = this.newException("Can not remove a Fractal sub component");
            ((Throwable)exc).initCause(ilce);
            this.severe(exc);
        }
    }

    protected final void removeFractalSubComponent(Component composite, Component component) throws ExceptionType {
        this.removeFractalSubComponent(this.getFractalContentController(composite), component);
    }

    protected final LifeCycleController getFractalLifeCycleController(Component component) throws ExceptionType {
        try {
            return Fractal.getLifeCycleController((Component)component);
        }
        catch (NoSuchInterfaceException nsie) {
            ExceptionType exc = this.newException("Can not get the Fractal lifecycle controller");
            ((Throwable)exc).initCause(nsie);
            this.severe(exc);
            return null;
        }
    }

    protected final void startFractalComponent(LifeCycleController lifeCycleController) throws ExceptionType {
        try {
            lifeCycleController.startFc();
        }
        catch (IllegalLifeCycleException nsie) {
            ExceptionType exc = this.newException("Can not start a Fractal component");
            ((Throwable)exc).initCause(nsie);
            this.severe(exc);
        }
    }

    protected final void startFractalComponent(Component component) throws ExceptionType {
        this.startFractalComponent(this.getFractalLifeCycleController(component));
    }

    protected final void stopFractalComponent(LifeCycleController lifeCycleController) throws ExceptionType {
        try {
            lifeCycleController.stopFc();
        }
        catch (IllegalLifeCycleException nsie) {
            ExceptionType exc = this.newException("Can not stop a Fractal component");
            ((Throwable)exc).initCause(nsie);
            this.severe(exc);
        }
    }

    protected final void stopFractalComponent(Component component) throws ExceptionType {
        this.stopFractalComponent(this.getFractalLifeCycleController(component));
    }

    protected final String getFractalComponentState(LifeCycleController lifeCycleController) throws ExceptionType {
        return lifeCycleController.getFcState();
    }

    protected final String getFractalComponentState(Component component) throws ExceptionType {
        return this.getFractalComponentState(this.getFractalLifeCycleController(component));
    }

    protected final NameController getFractalNameController(Component component) throws ExceptionType {
        try {
            return Fractal.getNameController((Component)component);
        }
        catch (NoSuchInterfaceException nsie) {
            ExceptionType exc = this.newException("Can not get the Fractal name controller");
            ((Throwable)exc).initCause(nsie);
            this.severe(exc);
            return null;
        }
    }

    protected final void setFractalComponentName(NameController nameController, String name) throws ExceptionType {
        nameController.setFcName(name);
    }

    protected final void setFractalComponentName(Component component, String name) throws ExceptionType {
        this.setFractalComponentName(this.getFractalNameController(component), name);
    }

    protected final String getFractalComponentName(NameController nameController) throws ExceptionType {
        return nameController.getFcName();
    }

    protected final String getFractalComponentName(Component component) throws ExceptionType {
        return this.getFractalComponentName(this.getFractalNameController(component));
    }
}

