/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.frascati.util.FrascatiException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLoggeable {
    protected Logger log = Logger.getLogger(this.getClass().getCanonicalName());

    protected final void logDo(String message) {
        this.log.fine(message + "...");
    }

    protected final void logDone(String message) {
        this.log.fine(message + " done.");
    }

    protected final <T extends FrascatiException> void warning(T exception) throws T {
        this.log.warning(exception.getMessage());
        throw exception;
    }

    protected final <T extends FrascatiException> void severe(T exception) throws T {
        this.log.log(Level.SEVERE, exception.getMessage(), exception);
        throw exception;
    }
}

