/**
 * OW2 FraSCAti Util
 * Copyright (C) 2008-2010 INRIA, University of Lille 1
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contact: frascati@ow2.org
 *
 * Author: Damien Fournier
 *
 * Contributor(s): Philippe Merle
 *
 */

package org.ow2.frascati.util;

import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;

/**
 * OW2 FraSCAti class loader.
 *
 * @author <a href="mailto:damien.fournier@inria.fr">Damien Fournier</a>
 * @version 1.3
 * @since 0.5
 */
public class FrascatiClassLoader extends URLClassLoader {

  //---------------------------------------------------------------------------
  // Internal state.
  // --------------------------------------------------------------------------

  //---------------------------------------------------------------------------
  // Internal methods.
  // --------------------------------------------------------------------------

  //---------------------------------------------------------------------------
  // Public methods.
  // --------------------------------------------------------------------------

  /**
   * Constructs a FraSCAti class loader child of the current thread context class loader.
   */
  public FrascatiClassLoader() {
    this(Thread.currentThread().getContextClassLoader());
  }

  /**
   * Constructs a FraSCAti class loader child of a given class loader.
   */
  public FrascatiClassLoader(ClassLoader parent) {
    super(new URL[0], parent);
  }

  /**
   * Constructs a FraSCAti class loader child of the current thread context class loader.
   */
  public FrascatiClassLoader(URL[] urls) {
    super(urls, Thread.currentThread().getContextClassLoader());
  }
  
  /**
   * Constructs a FraSCAti class loader child of a given class loader.
   */
  public FrascatiClassLoader(URL[] urls, ClassLoader parent) {
    super(urls, parent);
  }

  /**
   * Constructs a FraSCAti class loader child of a given class loader.
   */
  public FrascatiClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
    super(urls, parent, factory);
  }

  /**
   * Add an URL to this class loader.
   *
   * @param url URL to add.
   */
  public final void addUrl(URL url) {
    super.addURL(url);
  }
  
}
