/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.intent.bench;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.util.Fractal;
import org.osoa.sca.annotations.Scope;
import org.ow2.frascati.intent.bench.api.Report;
import org.ow2.frascati.intent.bench.api.Statistics;

@Scope(value="COMPOSITE")
public class BenchStatistics
implements Report,
Statistics {
    protected Map<Component, Long> components = new HashMap<Component, Long>();

    public void report(Component c, long executionTime) {
        if (this.components.get(c) == null) {
            this.components.put(c, new Long(0L));
        }
        Long newBench = this.components.get(c) + Long.valueOf(executionTime);
        this.components.put(c, newBench);
    }

    public String getStats() {
        String ret = "";
        for (Component c : this.components.keySet()) {
            String name;
            Long bench = this.components.get(c);
            try {
                name = Fractal.getNameController((Component)c).getFcName();
            }
            catch (NoSuchInterfaceException e) {
                name = " ## WARNING # can't get component name ##";
            }
            ret = ret + "#=======\n";
            ret = ret + "| component: " + name + "\n";
            ret = ret + "|    has run \t" + bench + " milliseconds.\n";
            ret = ret + "#=======\n";
        }
        return ret;
    }
}

