/***
 * OW2 FraSCAti Debug intent
 * Copyright (C) 2008-2009 INRIA, USTL
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * Contact: frascati@ow2.org
 *
 * Author: Nicolas Dolet
 */
package org.ow2.frascati.intent.debug;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.util.Fractal;
import org.osoa.sca.annotations.Scope;
import org.ow2.frascati.tinfi.control.intent.IntentHandler;
import org.ow2.frascati.tinfi.control.intent.IntentJoinPoint;

/**
 * {@link IntentHandler} implementation for a simple debug
 * 
 * @author <a href="mailto:nicolas.dolet@inria.fr">Nicolas Dolet</a>
 * @version $Revision$
 */
@Scope("COMPOSITE")
public class DebugIntentHandler
  implements IntentHandler {

  // --------------------------------------------------------------------------
  // Implementation of the IntentHandler interface
  // --------------------------------------------------------------------------

  /**
   * @see org.ow2.frascati.tinfi.control.intent.IntentHandler#invoke(IntentJoinPoint)
   */
  public Object invoke(IntentJoinPoint ijp) throws Throwable {
    Object ret;
    Component c = ((Interface) ijp.getComponentContext()).getFcItfOwner();
    String componentName = Fractal.getNameController(c).getFcName();
    String methodDesc = ijp.getMethod().toString();
    String interfaceDesc = ijp.getInterface().getFcItfName();
    System.err.println("[FRASCATI-DEBUG] Entering in component '" + componentName + "'");
    System.err.println("[FRASCATI-DEBUG] \t interface: " + interfaceDesc);
    System.err.println("[FRASCATI-DEBUG] \t method: " + methodDesc);
    
    ret = ijp.proceed();
    System.err.println("[FRASCATI-DEBUG] Exiting component '" + componentName + "'");
    System.err.println("[FRASCATI-DEBUG] \t method: " + methodDesc);
    System.err.println("[FRASCATI-DEBUG] \t interface: " + interfaceDesc);
    return ret;
  }
}
