/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.intent.lib;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.fraclet.extensions.Controller;
import org.objectweb.fractal.util.Fractal;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Property;
import org.osoa.sca.annotations.Reference;
import org.ow2.frascati.intent.api.WeaverException;
import org.ow2.frascati.intent.lib.AbstractWeaver;
import org.ow2.frascati.tinfi.api.IntentHandler;
import org.ow2.frascati.tinfi.api.control.SCABasicIntentController;

public class IntentHandlerWeaver
extends AbstractWeaver {
    @Property(name="excludes-implementation-bpel")
    private boolean excludesImplementationBpel = true;
    @Controller(name="component")
    private Component component;
    private static final String INTENT_HANDLER = "intent-handler";
    private IntentHandler intentHandler;
    static long nbApplies;

    @Reference(name="intent-handler")
    private void setIntentHandler(IntentHandler ih) {
    }

    @Init
    public void init() throws NoSuchInterfaceException {
        this.intentHandler = (IntentHandler)Fractal.getBindingController((Component)this.component).lookupFc(INTENT_HANDLER);
    }

    protected final SCABasicIntentController getSCABasicIntentController(Component component) throws NoSuchInterfaceException {
        return (SCABasicIntentController)component.getFcInterface("sca-intent-controller");
    }

    protected final boolean addIntentHandler(Component component) throws WeaverException {
        try {
            this.getSCABasicIntentController(component).addFcIntentHandler(this.intentHandler);
            return true;
        }
        catch (NoSuchInterfaceException nsie) {
            this.log.warning("A component has no SCA intent controller");
        }
        catch (IllegalLifeCycleException ilce) {
            this.severe(new WeaverException("Can not add intent handler", ilce));
        }
        return false;
    }

    protected final void removeIntentHandler(Component component) throws WeaverException {
        try {
            this.getSCABasicIntentController(component).removeFcIntentHandler(this.intentHandler);
        }
        catch (NoSuchInterfaceException nsie) {
            this.log.warning("A component has no SCA intent controller");
        }
        catch (IllegalLifeCycleException ilce) {
            this.severe(new WeaverException("Can not remove intent handler", ilce));
        }
    }

    protected final void traverse(Component component, Applier applier) throws WeaverException {
        if (this.excludesImplementationBpel && "implementation.bpel".equals(this.getFractalComponentName(component))) {
            this.log.warning("Could not traverse a BPEL implementation");
            return;
        }
        applier.apply(component);
        ContentController contentController = null;
        try {
            contentController = Fractal.getContentController((Component)component);
        }
        catch (NoSuchInterfaceException nsie) {
            return;
        }
        for (Component c : this.getFractalSubComponents(contentController)) {
            this.traverse(c, applier);
        }
    }

    public final void weave(Component scaComposite2) throws WeaverException {
        nbApplies = 0L;
        long startTime = System.nanoTime();
        this.stopFractalComponent(scaComposite2);
        this.traverse(scaComposite2, new Applier(){

            public final void apply(Component component) throws WeaverException {
                if (IntentHandlerWeaver.this.addIntentHandler(component)) {
                    ++nbApplies;
                }
            }
        });
        this.startFractalComponent(scaComposite2);
        long endTime = System.nanoTime();
        this.log.info("Weare the intent on " + nbApplies + " components in " + (endTime - startTime) + "ns.");
    }

    public final void unweave(Component scaComposite2) throws WeaverException {
        this.stopFractalComponent(scaComposite2);
        this.traverse(scaComposite2, new Applier(){

            public final void apply(Component component) throws WeaverException {
                IntentHandlerWeaver.this.removeIntentHandler(component);
            }
        });
        this.startFractalComponent(scaComposite2);
    }

    static interface Applier {
        public void apply(Component var1) throws WeaverException;
    }
}

