/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.intent.trace.explorer;

import java.util.List;
import org.ow2.frascati.explorer.plugin.AbstractTablePlugin;
import org.ow2.frascati.intent.trace.api.Trace;
import org.ow2.frascati.intent.trace.api.TraceEvent;
import org.ow2.frascati.intent.trace.api.TraceEventCall;
import org.ow2.frascati.intent.trace.api.TraceEventReturn;
import org.ow2.frascati.intent.trace.api.TraceEventThrow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceTable
extends AbstractTablePlugin<Trace> {
    private static final int NB_COLUNMS = 8;

    protected final String[] getHeaders() {
        return new String[]{"Id", "Event", "Thread", "Component", "Interface", "Method", "Arguments", "Result/Throw"};
    }

    protected final void addRows(Trace trace, List<Object[]> rows) {
        int id = 1;
        for (TraceEvent traceEvent : trace.getTraceEvents()) {
            Object[] row = new Object[8];
            rows.add(row);
            row[0] = Integer.toString(id);
            ++id;
            row[1] = this.newEntry("", traceEvent);
            Thread thread = traceEvent.getThread();
            row[2] = this.newEntry(thread.getName(), thread);
            if (traceEvent instanceof TraceEventCall) {
                TraceEventCall traceEventCall = (TraceEventCall)traceEvent;
                row[3] = this.newEntry(traceEventCall.getComponentName(), traceEventCall.getComponent());
                row[4] = this.newEntry(traceEventCall.getInterfaceName(), traceEventCall.getInterface());
                row[5] = this.newEntry(traceEventCall.getMethodName(), traceEventCall.getMethod());
                row[6] = traceEventCall.getArgumentsAsString();
                String result = "";
                if (traceEventCall instanceof TraceEventReturn) {
                    result = ((TraceEventReturn)traceEventCall).getReturnValueAsString();
                } else if (traceEventCall instanceof TraceEventThrow) {
                    result = ((TraceEventThrow)traceEventCall).getThrowableAsString();
                }
                row[7] = result;
                continue;
            }
            row[7] = traceEvent.toString();
        }
    }
}

