/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.intent.umlsequencediagram.lib;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.sf.sdedit.diagram.DiagramDataProvider;
import net.sf.sdedit.text.TextHandler;
import org.oasisopen.sca.annotation.Property;
import org.ow2.frascati.intent.trace.api.Trace;
import org.ow2.frascati.intent.trace.api.TraceEvent;
import org.ow2.frascati.intent.trace.api.TraceEventAsyncCall;
import org.ow2.frascati.intent.trace.api.TraceEventAsyncEnd;
import org.ow2.frascati.intent.trace.api.TraceEventCall;
import org.ow2.frascati.intent.trace.api.TraceEventReturn;
import org.ow2.frascati.intent.trace.api.TraceEventThrow;
import org.ow2.frascati.intent.umlsequencediagram.lib.TraceDiagramGenerator;

public class TextDiagramGenerator
implements TraceDiagramGenerator {
    @Property
    protected int messageLength = 20;
    @Property
    protected boolean showCompositeAsFragment = false;
    @Property
    protected boolean showReference = false;
    List<Actor> actors = new ArrayList<Actor>();
    List<Object> diagramEvent = new ArrayList<Object>();

    private String cleanStr(String toclean) {
        toclean = toclean.trim();
        toclean = toclean.replaceAll("\n", " ");
        if ((toclean = toclean.replaceAll(":", "\\\\:")).length() > this.messageLength) {
            toclean = toclean.substring(0, this.messageLength) + "...";
        }
        return toclean;
    }

    protected Actor addActor(String name, String type, String label) {
        for (Actor actor : this.actors) {
            if (!actor.getName().equals(name)) continue;
            return actor;
        }
        Actor actor = new Actor(name, type, label);
        this.actors.add(actor);
        return actor;
    }

    private String getType(TraceEventCall call) {
        if (call.isScaComposite()) {
            return "Composite";
        }
        if (call.isScaService()) {
            return "Service";
        }
        if (call.isScaReference()) {
            return "Reference";
        }
        return call.getComponentName();
    }

    public DiagramDataProvider getDiagramDataProvider(Trace trace) {
        try {
            Stack<Calling> currentStack = new Stack<Calling>();
            for (TraceEvent event : trace.getTraceEvents()) {
                TraceEventCall ret;
                Calling pop;
                if (this.showCompositeAsFragment && event.isScaComposite()) {
                    if (event instanceof TraceEventReturn || event instanceof TraceEventThrow) {
                        if (this.diagramEvent.get(this.diagramEvent.size() - 1).toString().startsWith("[c:")) {
                            this.diagramEvent.remove(this.diagramEvent.size() - 1);
                            continue;
                        }
                        this.diagramEvent.add("[/c]");
                        continue;
                    }
                    this.diagramEvent.add("[c:" + event.getComponentName() + "]");
                    continue;
                }
                TraceEventCall tracecall = (TraceEventCall)event;
                if (!this.showReference && tracecall.isScaReference()) continue;
                if (event instanceof TraceEventReturn) {
                    pop = (Calling)currentStack.pop();
                    pop.returned = ret = (TraceEventReturn)tracecall;
                    continue;
                }
                if (event instanceof TraceEventThrow) {
                    pop = (Calling)currentStack.pop();
                    ret = (TraceEventThrow)event;
                    pop.thro = ret;
                    continue;
                }
                Actor prev = currentStack.isEmpty() ? this.addActor(trace.getName(), trace.getName(), trace.getName()) : ((Calling)currentStack.peek()).target;
                Actor actor = this.addActor(tracecall.getComponentName(), this.getType(tracecall), null);
                Calling call = new Calling();
                call.call = tracecall;
                call.src = prev;
                call.target = actor;
                call.newThread = tracecall instanceof TraceEventAsyncCall || tracecall instanceof TraceEventAsyncEnd;
                currentStack.push(call);
                this.diagramEvent.add(call);
            }
            if (!currentStack.isEmpty()) {
                String noteId = "1";
                this.diagramEvent.add("*" + noteId + " " + ((Calling)currentStack.peek()).src.getName() + "\nEnd of execution\n*1");
                ((Calling)currentStack.peek()).setNoteId("1");
            }
            StringBuffer buffer = new StringBuffer();
            for (Actor actor : this.actors) {
                buffer.append(actor).append("\n");
            }
            buffer.append("\n");
            for (Object object : this.diagramEvent) {
                buffer.append(object.toString()).append("\n");
            }
            return new TextHandler(buffer.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return new TextHandler("");
        }
    }

    private class Calling {
        TraceEventCall call;
        boolean newThread = false;
        TraceEventReturn returned;
        Actor src;
        Actor target;
        TraceEventThrow thro;
        String noteId;

        private Calling() {
        }

        public void setNoteId(String noteId) {
            this.noteId = noteId;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            if (this.noteId != null) {
                buffer.append("(").append(this.noteId).append(")");
            }
            if (this.src != null) {
                buffer.append(this.src.getName()).append(":");
            }
            if (this.newThread) {
                buffer.append(">");
            } else if (this.returned != null) {
                buffer.append(TextDiagramGenerator.this.cleanStr(this.returned.getReturnValueAsString())).append("=");
            } else if (this.thro != null) {
                buffer.append(TextDiagramGenerator.this.cleanStr(this.thro.getThrowableAsString())).append("=");
            }
            if (this.target != null) {
                buffer.append(this.target.getName());
            }
            buffer.append(".").append(this.call.getMethodName()).append("(").append(TextDiagramGenerator.this.cleanStr(this.call.getArgumentsAsString())).append(")");
            return buffer.toString();
        }
    }

    private class Actor {
        private String label;
        private final String name;
        private String type;

        public Actor(String name, String type, String label) {
            this.name = name;
            this.type = type;
            this.label = label;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Actor other = (Actor)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String getLabel() {
            return this.label;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public String toString() {
            return this.name + ":" + this.type + (this.label != null ? " \"" + this.label + "\"" : "");
        }
    }
}

