/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.infra.stamp.descartes.git;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.pitest.mutationtest.DetectionStatus;

class IssueLogger {
    boolean started;
    File survived = null;
    File killed = null;
    File noCoverage = null;
    PrintWriter survivedReport = null;
    PrintWriter killedReport = null;
    PrintWriter noCoverageReport = null;
    boolean hasSurvived = false;
    boolean hasKilled = false;
    boolean hasNoCoverage = false;

    IssueLogger() {
    }

    public IssueLogger open() {
        if (!this.started) {
            try {
                this.survived = File.createTempFile("survived", null);
                this.survivedReport = new PrintWriter(this.survived);
            }
            catch (IOException e) {
                if (this.survivedReport != null) {
                    this.survivedReport.close();
                }
                this.survived = null;
            }
            try {
                this.killed = File.createTempFile("killed", null);
                this.killedReport = new PrintWriter(this.killed);
            }
            catch (IOException e) {
                if (this.killedReport != null) {
                    this.killedReport.close();
                }
                this.killed = null;
            }
            try {
                this.noCoverage = File.createTempFile("nocoverage", null);
                this.noCoverageReport = new PrintWriter(this.noCoverage);
            }
            catch (IOException e) {
                if (this.noCoverageReport != null) {
                    this.noCoverageReport.close();
                }
                this.noCoverage = null;
            }
            this.started = true;
        }
        return this;
    }

    public void close() {
        if (this.survivedReport != null) {
            this.survivedReport.close();
        }
        if (this.killedReport != null) {
            this.killedReport.close();
        }
        if (this.noCoverageReport != null) {
            this.noCoverageReport.close();
        }
        this.started = false;
    }

    public void log(DetectionStatus what, String data) {
        if (what == DetectionStatus.SURVIVED || what == DetectionStatus.TIMED_OUT) {
            this.logSurvived(data);
        } else if (what == DetectionStatus.KILLED) {
            this.logKilled(data);
        } else if (what == DetectionStatus.NO_COVERAGE) {
            this.logNoCoverage(data);
        }
    }

    public void logSurvived(String data) {
        this.log(this.survivedReport, data);
        this.hasSurvived = true;
    }

    public void logKilled(String data) {
        this.log(this.killedReport, data);
        this.hasKilled = true;
    }

    public void logNoCoverage(String data) {
        this.log(this.noCoverageReport, data);
        this.hasNoCoverage = true;
    }

    public String getSurvivedLog() {
        if (this.survived != null && this.hasSurvived) {
            return this.survived.getAbsolutePath();
        }
        return null;
    }

    public String getKilledLog() {
        if (this.killed != null && this.hasKilled) {
            return this.killed.getAbsolutePath();
        }
        return null;
    }

    public String getNoCoverageLog() {
        if (this.noCoverage != null && this.hasNoCoverage) {
            return this.noCoverage.getAbsolutePath();
        }
        return null;
    }

    private void log(PrintWriter writer, String data) {
        if (writer != null) {
            writer.println(data);
        }
    }
}

