/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.infra.stamp.descartes.git;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.gitlab4j.api.models.Issue;
import org.ow2.infra.stamp.descartes.git.IssueLogger;
import org.ow2.infra.utils.git.GitlabIssueManager;
import org.ow2.infra.utils.misc.FileUtils;
import org.pitest.coverage.TestInfo;
import org.pitest.mutationtest.ClassMutationResults;
import org.pitest.mutationtest.DetectionStatus;
import org.pitest.mutationtest.ListenerArguments;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.MutationResultListener;

public class MutationReportListener
implements MutationResultListener {
    Properties configuration;
    Properties gitlabConfig;
    ListenerArguments listenerArguments;
    IssueLogger out;
    int coverage = 0;
    private static int reportCount = 1;

    public MutationReportListener(Properties props, ListenerArguments args) {
        this.configuration = props != null ? props : new Properties();
        this.listenerArguments = args;
        this.coverage = args.getCoverage().createSummary().getCoverage();
    }

    public void runStart() {
        System.out.println("**** STAMP MutationReportListener::runStart(" + reportCount + ")");
        this.configuration.list(System.out);
        String gitlabToken = this.configuration.getProperty("gitlabToken");
        String gitlabUrl = this.configuration.getProperty("gitlabUrl");
        String gitlabProject = this.configuration.getProperty("gitlabProject");
        if (gitlabToken != null && gitlabUrl != null && gitlabProject != null) {
            this.gitlabConfig = new Properties();
            this.gitlabConfig.setProperty("gitlab.token", gitlabToken);
            this.gitlabConfig.setProperty("gitlab.url", gitlabUrl);
            this.gitlabConfig.setProperty("gitlab.project", gitlabProject);
        }
        this.out = new IssueLogger().open();
    }

    public void handleMutationResult(ClassMutationResults results) {
        LinkedHashSet<String> succeedingTestClasses = new LinkedHashSet<String>();
        for (MutationResult mutation : results.getMutations()) {
            if ("main".equals(mutation.getDetails().getMethod())) continue;
            LinkedList<String> succeedingTests = null;
            if (this.listenerArguments.isFullMutationMatrix()) {
                succeedingTests = mutation.getSucceedingTests();
            } else if (mutation.getStatus() == DetectionStatus.SURVIVED) {
                List succeedingTestsInfo = mutation.getDetails().getTestsInOrder();
                Iterator iterator = succeedingTestsInfo.iterator();
                while (iterator.hasNext()) {
                    TestInfo testInfo = (TestInfo)iterator.next();
                    if (succeedingTests == null) {
                        succeedingTests = new LinkedList<String>();
                    }
                    succeedingTests.add(testInfo.getName());
                }
            }
            if (succeedingTests != null && succeedingTests.size() > 0) {
                this.out.log(mutation.getStatus(), "==========================================================================");
                if (mutation.getStatus() == DetectionStatus.SURVIVED) {
                    this.out.logSurvived("CRITICAL TEST FAILURE: test suite GREEN upon code mutation");
                } else {
                    this.out.logKilled("Minor test failure: some test(s) do not detect code mutation");
                }
                this.out.log(mutation.getStatus(), "In class " + mutation.getDetails().getClassName() + ", method " + mutation.getDetails().getMethod() + " (line " + mutation.getDetails().getLineNumber() + ") was updated as follows: " + mutation.getDetails().getDescription());
                this.out.log(mutation.getStatus(), "\tThe following test(s) still PASS:");
                for (String succeedingtest : succeedingTests) {
                    this.out.log(mutation.getStatus(), "\t\t" + succeedingtest);
                    String testClass = succeedingtest.substring(succeedingtest.indexOf("(") + 1, succeedingtest.length() - 1);
                    succeedingTestClasses.add(testClass);
                }
                List killingTests = mutation.getKillingTests();
                if (killingTests != null && killingTests.size() > 0) {
                    this.out.log(mutation.getStatus(), "\tThe following test(s) DETECT the issue:");
                    for (String killingtest : killingTests) {
                        this.out.log(mutation.getStatus(), "\t\t" + killingtest);
                    }
                }
                this.out.log(mutation.getStatus(), "==========================================================================");
                continue;
            }
            if (mutation.getStatus() != DetectionStatus.NO_COVERAGE) continue;
            this.out.logNoCoverage("==========================================================================");
            this.out.logNoCoverage("Missing test: no coverage");
            this.out.logNoCoverage("In class " + mutation.getDetails().getClassName() + ", method " + mutation.getDetails().getMethod() + " (line " + mutation.getDetails().getLineNumber() + ") was updated as follows: " + mutation.getDetails().getDescription());
            this.out.logNoCoverage("\tNo test provided, no chance to detect any bug here.");
            this.out.logNoCoverage("==========================================================================");
        }
    }

    public void runEnd() {
        System.out.println("**** STAMP MutationReportListener::runEnd(" + reportCount + ")");
        this.out.close();
        if (this.out.getSurvivedLog() != null) {
            this.copyFileToPrintWriter(this.out.getSurvivedLog(), new PrintWriter(this.listenerArguments.getOutputStrategy().createWriterForFile("git_critical_issue.txt")));
        }
        if (this.out.getKilledLog() != null) {
            this.copyFileToPrintWriter(this.out.getKilledLog(), new PrintWriter(this.listenerArguments.getOutputStrategy().createWriterForFile("git_minor_issue.txt")));
        }
        if (this.out.getNoCoverageLog() != null) {
            this.copyFileToPrintWriter(this.out.getNoCoverageLog(), new PrintWriter(this.listenerArguments.getOutputStrategy().createWriterForFile("git_no_coverage_issue.txt")));
        }
        Issue criticalIssue = this.findIssueByTitle("CRITICAL (STAMP generated pass #" + reportCount + ")");
        Issue minorIssue = this.findIssueByTitle("MINOR (STAMP generated pass #" + reportCount + ")");
        try {
            if (criticalIssue != null) {
                if (this.out.getSurvivedLog() != null) {
                    GitlabIssueManager.updateIssue(this.gitlabConfig, criticalIssue.getIid(), criticalIssue.getTitle(), this.gitlabIssueSummary(FileUtils.fileToString(new File(this.out.getSurvivedLog()))));
                } else {
                    GitlabIssueManager.deleteIssue(this.gitlabConfig, criticalIssue.getIid());
                }
            } else if (this.out.getSurvivedLog() != null) {
                GitlabIssueManager.createIssue(this.gitlabConfig, "CRITICAL (STAMP generated pass #" + reportCount + "): Test suite green when code removed", this.gitlabIssueSummary(FileUtils.fileToString(new File(this.out.getSurvivedLog()))));
            }
            if (minorIssue != null) {
                if (this.out.getKilledLog() != null) {
                    GitlabIssueManager.updateIssue(this.gitlabConfig, minorIssue.getIid(), minorIssue.getTitle(), this.gitlabIssueSummary(FileUtils.fileToString(new File(this.out.getKilledLog()))));
                } else {
                    GitlabIssueManager.deleteIssue(this.gitlabConfig, minorIssue.getIid());
                }
            } else if (this.out.getKilledLog() != null) {
                GitlabIssueManager.createIssue(this.gitlabConfig, "MINOR (STAMP generated pass #" + reportCount + "): Some test(s) do(es) not detect changes in code", this.gitlabIssueSummary(FileUtils.fileToString(new File(this.out.getKilledLog()))));
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        ++reportCount;
    }

    private String gitlabIssueSummary(String issueContent) {
        StringBuilder summary = new StringBuilder("When some methods are emptied or their content is replaced by a single \"return\" statement, the test suite detects nothing and passes.\n\nIn other words, massive code removal is not detected by JUnit tests: global mutation coverage is " + this.listenerArguments.getCoverage().createSummary().getCoverage() + "%\n\nDetailed report of which classe(s) / test(s) are concerned follows:\n");
        if (issueContent != null) {
            if (issueContent.length() <= 999500) {
                summary.append("\n```\n" + issueContent + "\n```\n");
            } else {
                summary.append("\n```\n" + this.summarizeReport(issueContent) + "\n```\n");
            }
        }
        return summary.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String summarizeReport(String report) {
        StringBuilder summary = new StringBuilder();
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new StringReader(report));
            while ((line = in.readLine()) != null) {
                if (line.startsWith("\t")) continue;
                summary.append(line + "\n");
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        if (summary.length() > 999500) {
            summary.setLength(999500);
        }
        return summary.toString();
    }

    private Issue findIssueByTitle(String prefix) {
        if (this.gitlabConfig != null && prefix != null && prefix.length() > 1) {
            try {
                List<Issue> issues = GitlabIssueManager.listIssues(this.gitlabConfig, "OPENED");
                if (issues != null) {
                    for (Issue issue : issues) {
                        if (!issue.getTitle().startsWith(prefix)) continue;
                        return issue;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFileToPrintWriter(String path, PrintWriter out) {
        if (path == null || out == null) {
            return;
        }
        File file = new File(path);
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                out.println(line);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        out.close();
    }
}

