/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.infra.utils.git;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.jgit.api.Git;

public class GitCloner {
    public static String cloneRepository(String uri, String destDir, boolean shortPath) throws IOException {
        try {
            int pos;
            URL url = new URL(uri);
            String path = url.getPath();
            if (path.endsWith(".git")) {
                path = path.substring(0, path.length() - 4);
            }
            if (shortPath && (pos = path.lastIndexOf("/")) >= 0) {
                path = path.substring(pos + 1);
            }
            String cloneDir = new String(destDir + File.separator + path);
            Git.cloneRepository().setURI(uri).setDirectory(new File(cloneDir)).call();
            return cloneDir;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

