/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.infra.utils.git;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.models.Assignee;
import org.gitlab4j.api.models.Issue;
import org.gitlab4j.api.models.IssueFilter;
import org.gitlab4j.api.models.Note;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitlabIssueManager {
    public static final String ISSUE_OPENED = "OPENED";
    public static final String ISSUE_CLOSED = "CLOSED";
    public static final String ISSUE_REOPENED = "REOPENED";

    public static List<Issue> listIssues(String gitlabUrl, String privateToken, Object projectIdOrPath, String state) throws IOException {
        try {
            return GitlabIssueManager.listIssues(new GitLabApi(gitlabUrl, privateToken), projectIdOrPath, Constants.IssueState.forValue((String)state));
        }
        catch (GitLabApiException e) {
            throw new IOException(e);
        }
    }

    public static List<Issue> listIssues(String gitlabUrl, String user, String password, Object projectIdOrPath, String state) throws IOException {
        try {
            return GitlabIssueManager.listIssues(new GitLabApi(gitlabUrl, user, password), projectIdOrPath, Constants.IssueState.forValue((String)state));
        }
        catch (GitLabApiException e) {
            throw new IOException(e);
        }
    }

    public static List<Issue> listIssues(Properties gitlabConfig, String state) throws IOException {
        if (gitlabConfig == null) {
            throw new IOException("Missing Gitlab URL and/or private token and/or project ID or path in gitlab.properties");
        }
        String gitlabUrl = gitlabConfig.getProperty("gitlab.url");
        String gitlabToken = gitlabConfig.getProperty("gitlab.token");
        String gitlabProject = gitlabConfig.getProperty("gitlab.project");
        if (gitlabUrl == null || gitlabToken == null || gitlabProject == null) {
            throw new IOException("Missing Gitlab URL and/or private token and/or project ID or path in gitlab.properties");
        }
        return GitlabIssueManager.listIssues(gitlabUrl, gitlabToken, gitlabProject, state);
    }

    public static Issue getIssue(String gitlabUrl, String privateToken, Object projectIdOrPath, int iid) throws IOException {
        return GitlabIssueManager.getIssue(new GitLabApi(gitlabUrl, privateToken), projectIdOrPath, iid);
    }

    public static Issue getIssue(Properties gitlabConfig, int iid) throws IOException {
        if (gitlabConfig == null) {
            throw new IOException("Missing Gitlab URL and/or private token and/or project ID or path in gitlab.properties");
        }
        String gitlabUrl = gitlabConfig.getProperty("gitlab.url");
        String gitlabToken = gitlabConfig.getProperty("gitlab.token");
        String gitlabProject = gitlabConfig.getProperty("gitlab.project");
        if (gitlabUrl == null || gitlabToken == null || gitlabProject == null) {
            throw new IOException("Missing Gitlab URL and/or private token and/or project ID or path in gitlab.properties");
        }
        return GitlabIssueManager.getIssue(gitlabUrl, gitlabToken, gitlabProject, iid);
    }

    public static boolean commentIssue(String gitlabUrl, String privateToken, Object projectIdOrPath, int iid, String comment) throws IOException {
        return GitlabIssueManager.commentIssue(new GitLabApi(gitlabUrl, privateToken), projectIdOrPath, iid, comment);
    }

    public static boolean commentIssue(Properties gitlabConfig, int iid, String body) throws IOException {
        if (gitlabConfig == null) {
            throw new IOException("Missing Gitlab URL and/or private token and/or project ID or path in gitlab.properties");
        }
        String gitlabUrl = gitlabConfig.getProperty("gitlab.url");
        String gitlabToken = gitlabConfig.getProperty("gitlab.token");
        String gitlabProject = gitlabConfig.getProperty("gitlab.project");
        if (gitlabUrl == null || gitlabToken == null || gitlabProject == null) {
            throw new IOException("Missing Gitlab URL and/or private token and/or project ID or path in gitlab.properties");
        }
        return GitlabIssueManager.commentIssue(gitlabUrl, gitlabToken, gitlabProject, iid, body);
    }

    public static Issue createIssue(String gitlabUrl, String privateToken, Object projectIdOrPath, String title, String description) throws IOException {
        return GitlabIssueManager.createIssue(new GitLabApi(gitlabUrl, privateToken), projectIdOrPath, title, description);
    }

    public static Issue createIssue(Properties gitlabConfig, String title, String description) throws IOException {
        if (gitlabConfig == null) {
            throw new IOException("Missing Gitlab URL and/or private token and/or project ID or path in gitlab.properties");
        }
        String gitlabUrl = gitlabConfig.getProperty("gitlab.url");
        String gitlabToken = gitlabConfig.getProperty("gitlab.token");
        String gitlabProject = gitlabConfig.getProperty("gitlab.project");
        if (gitlabUrl == null || gitlabToken == null || gitlabProject == null) {
            throw new IOException("Missing Gitlab URL and/or private token and/or project ID or path in gitlab.properties");
        }
        return GitlabIssueManager.createIssue(gitlabUrl, gitlabToken, gitlabProject, title, description);
    }

    public static Issue updateIssue(String gitlabUrl, String privateToken, Object projectIdOrPath, int iid, String title, String description) throws IOException {
        return GitlabIssueManager.updateIssue(new GitLabApi(gitlabUrl, privateToken), projectIdOrPath, iid, title, description);
    }

    public static Issue updateIssue(Properties gitlabConfig, int iid, String title, String description) throws IOException {
        if (gitlabConfig == null) {
            throw new IOException("Missing Gitlab URL and/or private token and/or project ID or path in gitlab.properties");
        }
        String gitlabUrl = gitlabConfig.getProperty("gitlab.url");
        String gitlabToken = gitlabConfig.getProperty("gitlab.token");
        String gitlabProject = gitlabConfig.getProperty("gitlab.project");
        if (gitlabUrl == null || gitlabToken == null || gitlabProject == null) {
            throw new IOException("Missing Gitlab URL and/or private token and/or project ID or path in gitlab.properties");
        }
        return GitlabIssueManager.updateIssue(gitlabUrl, gitlabToken, gitlabProject, iid, title, description);
    }

    public static void deleteIssue(String gitlabUrl, String privateToken, Object projectIdOrPath, int iid) throws IOException {
        GitlabIssueManager.deleteIssue(new GitLabApi(gitlabUrl, privateToken), projectIdOrPath, iid);
    }

    public static void deleteIssue(Properties gitlabConfig, int iid) throws IOException {
        if (gitlabConfig == null) {
            throw new IOException("Missing Gitlab URL and/or private token and/or project ID or path in gitlab.properties");
        }
        String gitlabUrl = gitlabConfig.getProperty("gitlab.url");
        String gitlabToken = gitlabConfig.getProperty("gitlab.token");
        String gitlabProject = gitlabConfig.getProperty("gitlab.project");
        if (gitlabUrl == null || gitlabToken == null || gitlabProject == null) {
            throw new IOException("Missing Gitlab URL and/or private token and/or project ID or path in gitlab.properties");
        }
        GitlabIssueManager.deleteIssue(gitlabUrl, gitlabToken, gitlabProject, iid);
    }

    public static boolean isExceptionLikely(Issue issue) {
        String title = issue.getTitle().toLowerCase();
        if (title.contains("exception") || title.contains("npe")) {
            return true;
        }
        String description = issue.getDescription();
        Pattern atMore = Pattern.compile("(\\t|\\s\\s+)at |(\\t|\\s\\s+)... \\d+ more");
        Matcher matcher = atMore.matcher(description);
        return matcher.find();
    }

    private static Issue getIssue(GitLabApi api, Object projectIdOrPath, int iid) throws IOException {
        try {
            return api.getIssuesApi().getIssue(projectIdOrPath, Integer.valueOf(iid));
        }
        catch (GitLabApiException e) {
            throw new IOException(e);
        }
    }

    private static Issue createIssue(GitLabApi api, Object projectIdOrPath, String title, String description) throws IOException {
        try {
            return api.getIssuesApi().createIssue(projectIdOrPath, title, description);
        }
        catch (GitLabApiException e) {
            throw new IOException(e);
        }
    }

    private static Issue updateIssue(GitLabApi api, Object projectIdOrPath, int iid, String title, String description) throws IOException {
        try {
            Issue issue = GitlabIssueManager.getIssue(api, projectIdOrPath, iid);
            if (issue != null) {
                LinkedList<Integer> ids = new LinkedList<Integer>();
                List assignees = issue.getAssignees();
                if (assignees != null) {
                    for (Assignee assignee : assignees) {
                        ids.add(assignee.getId());
                    }
                }
                if (ids.isEmpty()) {
                    ids = null;
                }
                return api.getIssuesApi().updateIssue(projectIdOrPath, Integer.valueOf(iid), title, description, issue.getConfidential(), ids, issue.getMilestone() == null ? null : issue.getMilestone().getId(), null, Constants.StateEvent.REOPEN, issue.getUpdatedAt(), issue.getDueDate());
            }
            return null;
        }
        catch (GitLabApiException e) {
            throw new IOException(e);
        }
    }

    private static void deleteIssue(GitLabApi api, Object projectIdOrPath, int iid) throws IOException {
        try {
            api.getIssuesApi().deleteIssue(projectIdOrPath, Integer.valueOf(iid));
        }
        catch (GitLabApiException e) {
            throw new IOException(e);
        }
    }

    private static boolean commentIssue(GitLabApi api, Object projectIdOrPath, int iid, String body) throws IOException {
        Note result = null;
        try {
            result = api.getNotesApi().createIssueNote(projectIdOrPath, Integer.valueOf(iid), body);
        }
        catch (GitLabApiException e) {
            throw new IOException(e);
        }
        return result != null;
    }

    private static List<Issue> listIssues(GitLabApi api, Object projectIdOrPath, Constants.IssueState state) throws GitLabApiException {
        IssueFilter issueFilter = new IssueFilter();
        issueFilter.setState(state);
        return api.getIssuesApi().getIssues(projectIdOrPath, issueFilter);
    }
}

