/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.infra.utils.misc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class FileUtils {
    public static void deleteIfExists(File file) throws IOException {
        File[] entries;
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isDirectory() && (entries = file.listFiles()) != null) {
            for (File entry : entries) {
                FileUtils.deleteIfExists(entry);
            }
        }
        if (!file.delete()) {
            throw new IOException("Failed to delete " + file);
        }
    }

    public static String tempFile(String data) throws IOException {
        return FileUtils.tempFile(data, false);
    }

    public static String tempFile(String data, boolean keep) throws IOException {
        File temp = File.createTempFile("stamp", null);
        if (!keep) {
            temp.deleteOnExit();
        }
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(temp));
            out.print(data);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return temp.getAbsolutePath();
    }

    public static String fileToString(File file) throws IOException {
        BufferedReader in = null;
        StringBuilder result = null;
        try {
            String line;
            in = new BufferedReader(new FileReader(file));
            result = new StringBuilder();
            boolean first = true;
            while ((line = in.readLine()) != null) {
                result.append((first ? "" : "\n") + line);
                first = false;
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return result.toString();
    }
}

