/**
 * Ishmael : An open source implementation of JSR-88
 * Copyright (C) 2006
 * Contact: ishmael-dev@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: IDeploymentSpecific.java 325 2007-07-20 09:24:21 +0000 (Fri, 20 Jul 2007) benoitf $
 * --------------------------------------------------------------------------
 */
package org.ow2.ishmael.deploy.spi.impl;

import java.util.List;
import java.util.Properties;

import javax.enterprise.deploy.shared.ModuleType;

import org.ow2.ishmael.deploy.spi.exceptions.DeploymentException;

/**
 * Interface that all implementation needs to implement
 * @author Florent Benoit
 */
public interface IDeploymentSpecific {

    /**
     * List modules type in a given state
     * @param state STATUS_RUNNING = 1, STATUS_STOPPED = 2, STATUS_ALL = 0
     * @param type TYPE_JAR = 1, TYPE_WAR = 2, TYPE_EAR = 3, TYPE_RAR = 4 public
     *        final int TYPE_CAR = 5;
     * @return
     * @throws DeploymentException
     */
    List listModules(ModuleType type, int state) throws DeploymentException;


    /**
     * deploy the file on the server : call genic to generate class for JOnAS
     * and copy the result file into JOnAS server directory for deployment
     * @param type
     * @param file
     * @param name
     * @throws DeploymentException
     */
    String deployFile(ModuleType type, byte[] file, String name, String[] genicArgs) throws DeploymentException;


    /**
     * distribute (send)  the file on the server
     * and copy the result file into JOnAS server directory for deployment
     * @param type  of the archive
     * @param file Byte Array representing the file to upload
     * @param name name of the file
     * @return path to the distributed file
     * @throws DeploymentException
     */
    String sendFile(byte[] file, String name ) throws DeploymentException;

    /**
     * deploy application p
     * @param p
     * @throws DeploymentException
     */
    void deployApplication(Properties p) throws DeploymentException;


    /**
     * Stop application p
     * @param p
     * @throws DeploymentException
     */
    void stopApplication(Properties p) throws DeploymentException;


    /**
     * Undeploy application p
     * @param p
     * @throws DeploymentException
     */
    public void undeployApplication(Properties p) throws DeploymentException;

}
