/**
 * Ishmael : An open source implementation of JSR-88
 * Copyright (C) 2006
 * Contact: ishmael-dev@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DistributeProgressObject.java 322 2007-05-11 15:59:39 +0000 (Fri, 11 May 2007) benoitf $
 * --------------------------------------------------------------------------
 */
package org.ow2.ishmael.deploy.spi.status;

import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressEvent;

import org.ow2.ishmael.deploy.spi.status.DeploymentStatusImpl;
import org.ow2.ishmael.deploy.spi.status.ProgressObjectImpl;
import org.ow2.ishmael.deploy.spi.TargetModuleIDImpl;
import org.ow2.ishmael.deploy.spi.exceptions.DeploymentException;
import org.ow2.ishmael.deploy.spi.impl.IDeploymentSpecific;

public class DistributeProgressObject extends ProgressObjectImpl {
    byte[] file = null;
    String name = null;
    ModuleType type = null;
    String[] genicArgs = null;
    boolean conform = true;

    public DistributeProgressObject(IDeploymentSpecific adm, Target[] targets, byte[] file, String name, ModuleType type, String[] genicArgs, boolean conform) {
        super(adm, targets);
        this.file = file;
        this.name = name;
        this.type = type;
        this.status = new DeploymentStatusImpl(StateType.RUNNING, CommandType.DISTRIBUTE, ActionType.EXECUTE, "Preparing Deployment...");
        this.genicArgs = genicArgs;
        this.conform = conform;
    }


    public TargetModuleID[] getResultTargetModuleIDs() {
        TargetModuleIDImpl ids[] = new TargetModuleIDImpl[1];
        ids[0] = new TargetModuleIDImpl(name, targets[0], null);
        return ids;
    }

    /**
     *  distribute (send)  the archive  on the server only if it is a valid one
     * @throws Exception
     */
    private void distribute() throws Exception{
        String appdeploy = null;
        if (!conform) {
               throw new Exception("Descriptor not valid");
        } else {
            try {
                appdeploy = adm.sendFile(file, name);
            } catch (DeploymentException e) {
                throw new IllegalStateException(e);
            }
        }
        if (appdeploy != null)
            this.name = appdeploy;

    }

    public void run() {
        try {
            status = new DeploymentStatusImpl(StateType.RUNNING, CommandType.DISTRIBUTE, ActionType.EXECUTE, name + " deploying");
            ProgressEvent event = new ProgressEvent(this, null, status);
            fireEvent(event);
            distribute();
            status = new DeploymentStatusImpl(StateType.COMPLETED, CommandType.DISTRIBUTE, ActionType.EXECUTE, name + " successfully deployed");
            ProgressEvent event1 = new ProgressEvent(this, null, status);
            fireEvent(event1);
        } catch (Exception e) {
            status = new DeploymentStatusImpl(StateType.FAILED, CommandType.DISTRIBUTE, ActionType.EXECUTE, name + " failed to be deployed " + e.getMessage());
            ProgressEvent event = new ProgressEvent(this, null, status);
            fireEvent(event);
        }
    }

}