/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.ishmael.deploy.spi;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.ow2.ishmael.deploy.spi.BasicDeploymentManager;
import org.ow2.ishmael.deploy.spi.TargetModuleIDImpl;
import org.ow2.ishmael.deploy.spi.exceptions.IshmaelDeploymentManagerCreationException;
import org.ow2.ishmael.deploy.spi.impl.DeploymentSpecificEasyBeans;
import org.ow2.ishmael.deploy.spi.impl.DeploymentSpecificJOnAS;
import org.ow2.ishmael.deploy.spi.impl.IDeploymentSpecific;
import org.ow2.ishmael.deploy.spi.status.DistributeProgressObject;
import org.ow2.ishmael.deploy.spi.status.StartProgressObject;
import org.ow2.ishmael.deploy.spi.status.StopProgressObject;
import org.ow2.ishmael.deploy.spi.status.UnDeployProgressObject;
import org.ow2.ishmael.deploymentplan.JonasPlan;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.CARDeployable;
import org.ow2.util.ee.deploy.api.deployable.EARDeployable;
import org.ow2.util.ee.deploy.api.deployable.EJBDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.RARDeployable;
import org.ow2.util.ee.deploy.api.deployable.WARDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.impl.helper.DeployableEntry;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelperException;
import org.ow2.util.ee.deploy.impl.helper.ModifyDeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.PackDeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.UnpackDeployableHelper;
import org.ow2.util.ee.metadata.common.impl.xml.parsing.ParsingException;
import org.ow2.util.ee.metadata.war.impl.xml.parsing.WARDeploymentDescLoader;
import org.ow2.util.file.FileUtils;
import org.ow2.util.url.URLUtils;

public class BasicConnectedDeploymentManager
extends BasicDeploymentManager {
    private File tmpFolder = null;
    private File tmpPackFolder = null;
    private File tmpUnPackFolder = null;
    public static final String APPLICATION_FILE_NAME = "META-INF/application.xml";
    public static final String JONAS_APPLICATION_FILE_NAME = "META-INF/jonas-application.xml";
    public static final String RA_FILE_NAME = "META-INF/ra.xml";
    public static final String JONAS_RA_FILE_NAME = "META-INF/jonas-ra.xml";
    public static final String CLIENT_FILE_NAME = "META-INF/application-client.xml";
    public static final String JONAS_CLIENT_FILE_NAME = "META-INF/jonas-client.xml";
    public static final String EJB_JAR_FILE_NAME = "META-INF/ejb-jar.xml";
    public static final String JONAS_EJB_JAR_FILE_NAME = "META-INF/jonas-ejb-jar.xml";
    public static final String WEB_FILE_NAME = "WEB-INF/web.xml";
    public static final String JONAS_WEB_FILE_NAME = "WEB-INF/jonas-web.xml";
    public static final String WS_EJBJAR_FILE_NAME = "META-INF/webservices.xml";
    public static final String JONAS_WS_EJBJAR_FILE_NAME = "META-INF/jonas-webservices.xml";
    public static final String WS_WEBAPP_FILE_NAME = "WEB-INF/webservices.xml";
    public static final String JONAS_WS_WEBAPP_FILE_NAME = "WEB-INF/jonas-webservices.xml";
    IDeploymentSpecific deployerImpl = null;
    private boolean releasedMode = false;
    public static final String WSGENClASSNAME = "org.ow2.jonas.generators.wsgen.WsGen";

    public BasicConnectedDeploymentManager(String uri, String userName, String password) throws IshmaelDeploymentManagerCreationException {
        this.deployerImpl = uri.contains("syBeans") ? new DeploymentSpecificEasyBeans(uri, userName, password) : new DeploymentSpecificJOnAS(uri, userName, password);
    }

    public ProgressObject start(TargetModuleID[] param1) throws IllegalStateException {
        this.checkNotReleased();
        StartProgressObject po = new StartProgressObject(this.deployerImpl, param1);
        new Thread(po).start();
        return po;
    }

    public ProgressObject stop(TargetModuleID[] param1) throws IllegalStateException {
        this.checkNotReleased();
        StopProgressObject po = new StopProgressObject(this.deployerImpl, param1);
        new Thread(po).start();
        return po;
    }

    public Target[] getTargets() throws IllegalStateException {
        this.checkNotReleased();
        Target[] targets = new Target[]{new JOnASTarget()};
        return targets;
    }

    public TargetModuleID[] getRunningModules(ModuleType param1, Target[] param2) throws TargetException, IllegalStateException {
        this.checkNotReleased();
        try {
            List l = this.deployerImpl.listModules(param1, 1);
            TargetModuleID[] ids = new TargetModuleID[l.size()];
            for (int i = 0; i < ids.length; ++i) {
                String desc = (String)l.get(i);
                Target targetToDeploy = null;
                if (param2 != null) {
                    targetToDeploy = param2[0];
                }
                ids[i] = new TargetModuleIDImpl(desc, targetToDeploy);
            }
            return ids;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TargetException(e.getMessage());
        }
    }

    public TargetModuleID[] getNonRunningModules(ModuleType param1, Target[] param2) throws TargetException, IllegalStateException {
        this.checkNotReleased();
        try {
            List l = this.deployerImpl.listModules(param1, 0);
            TargetModuleID[] ids = new TargetModuleID[l.size()];
            for (int i = 0; i < ids.length; ++i) {
                String desc = (String)l.get(i);
                Target targetToDeploy = null;
                if (param2 != null) {
                    targetToDeploy = param2[0];
                }
                ids[i] = new TargetModuleIDImpl(desc, targetToDeploy);
            }
            return ids;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TargetException(e.getMessage());
        }
    }

    public TargetModuleID[] getAvailableModules(ModuleType param1, Target[] param2) throws TargetException, IllegalStateException {
        this.checkNotReleased();
        try {
            List l = this.deployerImpl.listModules(param1, 0);
            TargetModuleID[] ids = new TargetModuleID[l.size()];
            for (int i = 0; i < ids.length; ++i) {
                String pathModule = (String)l.get(i);
                Target targetToDeploy = null;
                if (param2 != null) {
                    targetToDeploy = param2[0];
                }
                ids[i] = new TargetModuleIDImpl(pathModule, targetToDeploy);
            }
            return ids;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TargetException(e.getMessage());
        }
    }

    public ProgressObject distribute(Target[] targets, InputStream archive, InputStream plan) throws IllegalStateException {
        this.checkNotReleased();
        try {
            byte[] binarchive = new byte[archive.available()];
            archive.read(binarchive);
            byte[] binplan = null;
            if (plan != null) {
                binplan = new byte[plan.available()];
                plan.read(binplan);
            }
            String userName = System.getProperty("user.name");
            File archiveFile = File.createTempFile(userName + "archive", ".tmp");
            FileOutputStream outarchive = new FileOutputStream(archiveFile);
            outarchive.write(binarchive);
            outarchive.close();
            ModuleType type = this.findTypeArchive(ArchiveManager.getInstance().getArchive((Object)archiveFile));
            String pathArchiveGoodExtension = archiveFile.getAbsolutePath().substring(0, archiveFile.getAbsolutePath().indexOf(".tmp"));
            pathArchiveGoodExtension = pathArchiveGoodExtension + type.getModuleExtension();
            File tempFileReturn = new File(pathArchiveGoodExtension);
            this.copyStream(new FileInputStream(archiveFile), new FileOutputStream(tempFileReturn));
            if (plan != null) {
                File planFile = File.createTempFile(userName + "plan", ".jar");
                FileOutputStream outplan = new FileOutputStream(planFile);
                outplan.write(binplan);
                outplan.close();
                tempFileReturn.deleteOnExit();
                return this.distribute(targets, tempFileReturn, planFile);
            }
            return this.distribute(targets, tempFileReturn, null);
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
            throw new IllegalStateException("Problem deploying the application : " + ioe.toString());
        }
    }

    public ProgressObject distribute(Target[] arg0, ModuleType arg1, InputStream arg2, InputStream arg3) throws IllegalStateException {
        return this.distribute(arg0, arg2, arg3);
    }

    public ProgressObject distribute(Target[] targets, File fileArchive, File plan) throws IllegalStateException {
        ModuleType type;
        IDeployable archivetoDeploy;
        String shorterArchiveName;
        File packedArchive;
        boolean isValidModule;
        block14: {
            isValidModule = true;
            packedArchive = null;
            this.checkNotReleased();
            IArchive archive = ArchiveManager.getInstance().getArchive((Object)fileArchive);
            shorterArchiveName = URLUtils.shorterName((URL)archive.getURL());
            try {
                archivetoDeploy = DeployableHelper.getDeployable((IArchive)archive);
            }
            catch (DeployableHelperException e) {
                throw new Exception("Cannot get a deployable for the archive '" + archive + "'", e);
            }
            type = this.findTypeArchive(archive);
            if (plan != null) break block14;
            FileInputStream in = new FileInputStream(fileArchive);
            byte[] fileToDeployed = new byte[in.available()];
            in.read(fileToDeployed);
            in.close();
            String[] genicArgsnull = new String[]{""};
            DistributeProgressObject po = new DistributeProgressObject(this.deployerImpl, targets, fileToDeployed, new File(archive.getURL().getFile()).getName(), type, genicArgsnull, isValidModule);
            new Thread(po).start();
            DistributeProgressObject distributeProgressObject = po;
            return distributeProgressObject;
        }
        try {
            JonasPlan jonasDeploymentPlan;
            block15: {
                jonasDeploymentPlan = new JonasPlan();
                jonasDeploymentPlan.createPlan(plan);
                File tmpPackFolder = this.getTemporaryPackFolder();
                try {
                    if (type == ModuleType.EAR) {
                        packedArchive = this.updateEAR(archivetoDeploy, jonasDeploymentPlan);
                        break block15;
                    }
                    if (type == ModuleType.RAR) {
                        shorterArchiveName = jonasDeploymentPlan.getArchiveName();
                        this.updateRAR(archivetoDeploy, jonasDeploymentPlan, shorterArchiveName);
                        packedArchive = PackDeployableHelper.pack((IDeployable)archivetoDeploy, (File)tmpPackFolder, (String)shorterArchiveName);
                        break block15;
                    }
                    if (type == ModuleType.EJB) {
                        File packedArchivetmp = null;
                        this.updateJARWARCAR(archivetoDeploy, jonasDeploymentPlan, jonasDeploymentPlan.getArchiveName());
                        packedArchivetmp = PackDeployableHelper.pack((IDeployable)archivetoDeploy, (File)tmpPackFolder, (String)shorterArchiveName);
                        String filename = packedArchivetmp.getAbsolutePath();
                        try {
                            ClassLoader clientClassloader = Thread.currentThread().getContextClassLoader();
                            Class<?> clazz = clientClassloader.loadClass(WSGENClASSNAME);
                            Method executeMethod = clazz.getDeclaredMethod("execute", String[].class);
                            Object wsgen = clazz.newInstance();
                            String[] args = new String[]{"-d", tmpPackFolder.getName(), "-verbose", filename};
                            String nfile = (String)executeMethod.invoke(wsgen, new Object[]{args});
                            packedArchive = nfile.endsWith(".ear") ? new File(nfile) : packedArchivetmp;
                            break block15;
                        }
                        catch (Exception e) {
                            throw new DeployerException("Cannot execute WSGen on '" + filename + "'", (Throwable)e);
                        }
                    }
                    this.updateJARWARCAR(archivetoDeploy, jonasDeploymentPlan, jonasDeploymentPlan.getArchiveName());
                    packedArchive = PackDeployableHelper.pack((IDeployable)archivetoDeploy, (File)tmpPackFolder, (String)shorterArchiveName);
                }
                catch (InvalidModuleException ie) {
                    isValidModule = false;
                    packedArchive = fileArchive;
                }
            }
            FileInputStream in = new FileInputStream(packedArchive);
            byte[] fileToDeployed = new byte[in.available()];
            in.read(fileToDeployed);
            in.close();
            DistributeProgressObject po = new DistributeProgressObject(this.deployerImpl, targets, fileToDeployed, jonasDeploymentPlan.getArchiveName(), type, null, isValidModule);
            new Thread(po).start();
            DistributeProgressObject distributeProgressObject = po;
            return distributeProgressObject;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("ISHMAEL :Exception", e);
        }
    }

    private void deleteTemporaries() {
        FileUtils.delete((File)this.getTemporaryFolder());
    }

    private ModuleType findTypeArchive(IArchive archive) throws Exception {
        IDeployable deployable;
        try {
            deployable = DeployableHelper.getDeployable((IArchive)archive);
        }
        catch (DeployableHelperException e) {
            throw new Exception("Cannot get a deployable for the archive '" + archive + "'", e);
        }
        if (deployable instanceof CARDeployable) {
            return ModuleType.CAR;
        }
        if (deployable instanceof EJBDeployable) {
            return ModuleType.EJB;
        }
        if (deployable instanceof WARDeployable) {
            return ModuleType.WAR;
        }
        if (deployable instanceof EARDeployable) {
            return ModuleType.EAR;
        }
        if (deployable instanceof RARDeployable) {
            return ModuleType.RAR;
        }
        return ModuleType.EAR;
    }

    private void copyStream(InputStream input, OutputStream output) throws IOException {
        BufferedInputStream reader = new BufferedInputStream(input);
        BufferedOutputStream writer = new BufferedOutputStream(output);
        byte[] cbuf = new byte[reader.available()];
        reader.read(cbuf);
        writer.write(cbuf);
        writer.flush();
        writer.close();
    }

    private void checkDescriptorValidity(IDeployable deployable) throws InvalidModuleException {
        block4: {
            IArchive archive = deployable.getArchive();
            try {
                ModuleType type = this.findTypeArchive(archive);
                if (type != ModuleType.WAR) break block4;
                URL webXmlURL = archive.getResource(WEB_FILE_NAME);
                Object document = null;
                try {
                    WARDeploymentDescLoader.loadDeploymentDescriptor((URL)webXmlURL, (boolean)true);
                }
                catch (ParsingException e) {
                    throw new InvalidModuleException("Cannot parse the url");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new InvalidModuleException("Invalid deploiement descriptor");
            }
        }
    }

    private void updateJARWARCAR(IDeployable deployable, JonasPlan plan, String shorterArchiveName) throws InvalidModuleException, DeployerException {
        File tmpUnpackFolder = this.getTemporaryUnPackFolder();
        this.checkDescriptorValidity(deployable);
        List<DeployableEntry> deployablesEntries = plan.getDeployableEntries(shorterArchiveName);
        ModifyDeployableHelper.addInDeployable((IDeployable)deployable, deployablesEntries, (File)tmpUnpackFolder);
    }

    private void updateRAR(IDeployable deployable, JonasPlan plan, String archiveName) throws InvalidModuleException, DeployerException {
        File tmpUnpackFolder = this.getTemporaryUnPackFolder();
        this.checkDescriptorValidity(deployable);
        List<DeployableEntry> deployablesEntries = plan.getDeployableEntries(archiveName);
        ModifyDeployableHelper.addInDeployable((IDeployable)deployable, deployablesEntries, (File)tmpUnpackFolder);
    }

    private File getTemporaryFolder() {
        if (this.tmpFolder == null) {
            this.tmpFolder = new File(System.getProperty("java.io.tmpdir") + File.separator + System.getProperty("user.name", "default") + "ishmael-tmp");
        }
        return this.tmpFolder;
    }

    private File getTemporaryPackFolder() {
        if (this.tmpPackFolder == null) {
            this.tmpPackFolder = new File(this.getTemporaryFolder(), "pack");
            this.tmpPackFolder.mkdirs();
        }
        return this.tmpPackFolder;
    }

    private File getTemporaryUnPackFolder() {
        if (this.tmpUnPackFolder == null) {
            this.tmpUnPackFolder = new File(this.getTemporaryFolder(), "unpack");
            this.tmpUnPackFolder.mkdirs();
        }
        return this.tmpUnPackFolder;
    }

    private File updateEAR(IDeployable deployable, JonasPlan plan) throws Exception {
        File tmpUnpackFolder = this.getTemporaryUnPackFolder();
        File tmpPackFolder = this.getTemporaryPackFolder();
        URL urlArchive = deployable.getArchive().getURL();
        String initialArchiveName = URLUtils.shorterName((URL)urlArchive);
        EARDeployable unpackDeployable = (EARDeployable)UnpackDeployableHelper.unpack((IDeployable)((EARDeployable)deployable), (File)tmpUnpackFolder, (String)initialArchiveName);
        List<DeployableEntry> deployablesEntries = plan.getDeployableEntries(initialArchiveName);
        ModifyDeployableHelper.addInDeployable((IDeployable)deployable, deployablesEntries, (File)tmpUnpackFolder);
        List lejbs = unpackDeployable.getEJBDeployables();
        for (EJBDeployable ejbjar : lejbs) {
            String archiveName = URLUtils.shorterName((URL)ejbjar.getArchive().getURL());
            this.updateJARWARCAR((IDeployable)ejbjar, plan, archiveName);
        }
        List lcars = unpackDeployable.getCARDeployables();
        for (CARDeployable car : lcars) {
            String archiveName = URLUtils.shorterName((URL)car.getArchive().getURL());
            this.updateJARWARCAR((IDeployable)car, plan, archiveName);
        }
        List lrars = unpackDeployable.getRARDeployables();
        for (RARDeployable rar : lrars) {
            String archiveName = URLUtils.shorterName((URL)rar.getArchive().getURL());
            this.updateRAR((IDeployable)rar, plan, archiveName);
        }
        List lwars = unpackDeployable.getWARDeployables();
        for (WARDeployable war : lwars) {
            String archiveName = URLUtils.shorterName((URL)war.getArchive().getURL());
            this.updateJARWARCAR((IDeployable)war, plan, archiveName);
        }
        File packedArchive = PackDeployableHelper.pack((IDeployable)unpackDeployable, (File)tmpPackFolder, (String)("new-" + initialArchiveName));
        return packedArchive;
    }

    public ProgressObject undeploy(TargetModuleID[] param1) throws IllegalStateException {
        this.checkNotReleased();
        UnDeployProgressObject po = new UnDeployProgressObject(this.deployerImpl, param1);
        new Thread(po).start();
        return po;
    }

    public void release() {
        this.releasedMode = true;
    }

    private void checkNotReleased() {
        if (this.releasedMode) {
            throw new IllegalStateException("The release() method was called, then no more methods can be called");
        }
    }

    protected class JOnASTarget
    implements Target {
        private String name = "Main";
        private String description = "The main jonas server";

        protected JOnASTarget() {
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

