/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.ishmael.deploy.spi.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.ow2.ishmael.deploy.spi.exceptions.DeploymentException;
import org.ow2.ishmael.deploy.spi.exceptions.IshmaelDeploymentManagerCreationException;
import org.ow2.ishmael.deploy.spi.impl.IDeploymentSpecific;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsDeploymentSpecific
implements IDeploymentSpecific {
    private JMXConnector jmxConnector = null;
    private MBeanServerConnection mBeanServerConnection = null;
    private ObjectName objectName = null;
    private static final String PREFIX_URL = "deployer:ishmael:";
    private String uri = null;
    private static final int AVAILABLE = 0;
    private static final int RUNNING = 1;
    private Map<Integer, List<String>> jarModules = null;
    private Map<Integer, List<String>> warModules = null;
    private Map<Integer, List<String>> rarModules = null;
    private Map<Integer, List<String>> earModules = null;

    public AbsDeploymentSpecific(String uri) throws IshmaelDeploymentManagerCreationException {
        this.uri = uri;
        try {
            this.objectName = new ObjectName(this.getStringObjectName());
        }
        catch (MalformedObjectNameException e) {
            throw new IshmaelDeploymentManagerCreationException("Cannot create ObjectName", e);
        }
        catch (NullPointerException e) {
            throw new IshmaelDeploymentManagerCreationException("Cannot create ObjectName", e);
        }
        this.init();
    }

    protected ObjectName getObjectName() {
        return this.objectName;
    }

    protected MBeanServerConnection getMBeanServerConnection() {
        return this.mBeanServerConnection;
    }

    protected abstract String getStringObjectName();

    private void init() throws IshmaelDeploymentManagerCreationException {
        try {
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("java.naming.factory.initial", "org.objectweb.carol.jndi.spi.MultiOrbInitialContextFactory");
            this.jmxConnector = JMXConnectorFactory.connect(this.getJmxServiceUrl(), env);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IshmaelDeploymentManagerCreationException("Cannot connect to the JMX connector", e);
        }
        catch (DeploymentManagerCreationException e) {
            e.printStackTrace();
            throw new IshmaelDeploymentManagerCreationException("Cannot connect to the JMX connector", e);
        }
        try {
            this.mBeanServerConnection = this.jmxConnector.getMBeanServerConnection();
        }
        catch (IOException e) {
            throw new IshmaelDeploymentManagerCreationException("Cannot get MBean Server connection", e);
        }
        this.jarModules = new HashMap<Integer, List<String>>();
        this.jarModules.put(0, new ArrayList());
        this.jarModules.put(1, new ArrayList());
        this.warModules = new HashMap<Integer, List<String>>();
        this.warModules.put(0, new ArrayList());
        this.warModules.put(1, new ArrayList());
        this.earModules = new HashMap<Integer, List<String>>();
        this.earModules.put(0, new ArrayList());
        this.earModules.put(1, new ArrayList());
        this.rarModules = new HashMap<Integer, List<String>>();
        this.rarModules.put(0, new ArrayList());
        this.rarModules.put(1, new ArrayList());
    }

    private JMXServiceURL getJmxServiceUrl() throws DeploymentManagerCreationException {
        if (!this.uri.startsWith(PREFIX_URL)) {
            throw new DeploymentManagerCreationException("Invalid URL '" + this.uri + "'. It doesn't start with " + PREFIX_URL);
        }
        String jmxConnectorURL = this.uri.substring(PREFIX_URL.length());
        System.out.println("Using JMX connector " + jmxConnectorURL);
        try {
            return new JMXServiceURL(jmxConnectorURL);
        }
        catch (MalformedURLException e) {
            DeploymentManagerCreationException newE = new DeploymentManagerCreationException("Cannot make url on '" + this.uri + "'.");
            newE.initCause((Throwable)e);
            throw newE;
        }
    }

    @Override
    public List<String> listModules(ModuleType type, int state) throws DeploymentException {
        List<Object> listReturned = new ArrayList();
        try {
            if (type.equals(ModuleType.EAR)) {
                listReturned = this.earModules.get(state);
            } else if (type.equals(ModuleType.EJB)) {
                listReturned = this.jarModules.get(state);
            } else if (type.equals(ModuleType.RAR)) {
                listReturned = this.rarModules.get(state);
            } else if (type.equals(ModuleType.WAR)) {
                listReturned = this.warModules.get(state);
            }
        }
        catch (Exception e) {
            throw new DeploymentException(e.getMessage());
        }
        return listReturned;
    }

    @Override
    public void deployApplication(Properties p) throws DeploymentException {
        String file = p.getProperty("file");
        if (file == null) {
            throw new DeploymentException("No file to deploy");
        }
        this.deploy(p);
        this.addRunning(file);
    }

    @Override
    public void undeployApplication(Properties p) throws DeploymentException {
        String fileName = p.getProperty("file");
        if (fileName == null) {
            throw new DeploymentException("No file to undeploy");
        }
        if (this.isDeployedApplication(p)) {
            throw new DeploymentException("Application must be stopped before they can be undeployed.");
        }
        File app = new File(fileName);
        boolean isdelete = app.delete();
        System.out.println(">>>>>>>>>> in undeployApplication " + fileName + " has been deleted");
        this.removeModule(fileName);
        if (!isdelete) {
            throw new DeploymentException("Deleted application : " + fileName + " is not a success.");
        }
    }

    @Override
    public void stopApplication(Properties p) throws DeploymentException {
        String file = p.getProperty("file");
        if (file == null) {
            throw new DeploymentException("No file to stop");
        }
        this.stop(file);
        this.removeRunning(file);
    }

    public boolean isDeployedApplication(Properties p) throws DeploymentException {
        String file = p.getProperty("file");
        if (file == null) {
            throw new DeploymentException("Unknow file into isDeployedFile");
        }
        HashMap<Integer, List<String>> moduleList = this.getModuleList(file);
        List<String> lmodules = moduleList.get(1);
        return lmodules.contains(file);
    }

    public void addAvailable(String module) {
        HashMap<Integer, List<String>> moduleList = this.getModuleList(module);
        List<String> lmodules = moduleList.get(0);
        if (!lmodules.contains(module)) {
            lmodules.add(module);
        }
    }

    public void addRunning(String module) {
        HashMap<Integer, List<String>> moduleList = this.getModuleList(module);
        List<String> lavailables = moduleList.get(0);
        List<String> lrunning = moduleList.get(1);
        if (lavailables.contains(module)) {
            lavailables.remove(module);
        }
        if (!lrunning.contains(module)) {
            lrunning.add(module);
        }
    }

    public void removeRunning(String module) {
        HashMap<Integer, List<String>> moduleList = this.getModuleList(module);
        List<String> lavailables = moduleList.get(0);
        List<String> lrunning = moduleList.get(1);
        if (lrunning.contains(module)) {
            lrunning.remove(module);
        }
        if (!lavailables.contains(module)) {
            lavailables.add(module);
        }
    }

    public void removeModule(String module) {
        HashMap<Integer, List<String>> moduleList = this.getModuleList(module);
        List<String> lavailables = moduleList.get(0);
        List<String> lrunning = moduleList.get(1);
        if (lrunning.contains(module)) {
            lrunning.remove(module);
        }
        if (lavailables.contains(module)) {
            lavailables.remove(module);
        }
    }

    public HashMap<Integer, List<String>> getModuleList(String module) {
        ModuleType type = null;
        HashMap moduleList = null;
        try {
            type = this.findType(module);
            if (type.equals(ModuleType.EAR)) {
                moduleList = (HashMap)this.earModules;
            } else if (type.equals(ModuleType.EJB)) {
                moduleList = (HashMap)this.jarModules;
            } else if (type.equals(ModuleType.WAR)) {
                moduleList = (HashMap)this.warModules;
            } else if (type.equals(ModuleType.RAR)) {
                moduleList = (HashMap)this.rarModules;
            }
        }
        catch (DeploymentException e) {
            // empty catch block
        }
        return moduleList;
    }

    @Override
    public String deployFile(ModuleType type, byte[] file, String name, String[] genicArgs) throws DeploymentException {
        Object[] param = new Object[]{name, file};
        String[] signature = new String[]{"java.lang.String", "[B"};
        String nameapp = null;
        try {
            nameapp = (String)this.getMBeanServerConnection().invoke(this.getObjectName(), "dumpFile", param, signature);
            this.addAvailable(nameapp);
            return nameapp;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new DeploymentException(e.getMessage());
        }
    }

    @Override
    public String sendFile(byte[] file, String name) throws DeploymentException {
        Object[] param = new Object[]{name, file};
        String[] signature = new String[]{"java.lang.String", "[B"};
        String nameapp = null;
        try {
            System.out.println(">>>>>>>>>>> call to J2eeServer.distribute " + name);
            nameapp = (String)this.getMBeanServerConnection().invoke(this.getObjectName(), "distribute", param, signature);
            this.addAvailable(nameapp);
            return nameapp;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new DeploymentException(e.getMessage());
        }
    }

    protected void deploy(Properties info) throws DeploymentException {
        String earFile = info.getProperty("file");
        Object[] param = new String[]{earFile};
        String[] signature = new String[]{"java.lang.String"};
        try {
            System.out.println(">>>>>>>>>>> call to J2eeServer.deploy " + earFile);
            this.getMBeanServerConnection().invoke(this.getObjectName(), "deploy", param, signature);
        }
        catch (Exception e) {
            throw new DeploymentException("Error during EAR deployment" + e.getMessage());
        }
    }

    protected void stop(String file) throws DeploymentException {
        Object[] param = new String[]{file};
        String[] signature = new String[]{"java.lang.String"};
        try {
            System.out.println(">>>>>>>>>>> (stop) call to J2eeServer.undeploy " + file);
            this.getMBeanServerConnection().invoke(this.getObjectName(), "undeploy", param, signature);
        }
        catch (Exception e) {
            throw new DeploymentException(e.getMessage());
        }
    }

    protected boolean isEarDeployed(Properties p) throws DeploymentException {
        String ear_file = p.getProperty("file");
        Object[] param = new String[]{ear_file};
        String[] signature = new String[]{"java.lang.String"};
        Object deployed = null;
        try {
            deployed = this.getMBeanServerConnection().invoke(this.getObjectName(), "isEarDeployed", param, signature);
        }
        catch (Exception e) {
            throw new DeploymentException(e.getMessage());
        }
        return Boolean.parseBoolean(deployed.toString());
    }

    protected boolean isJarDeployed(Properties p) throws DeploymentException {
        String ejb_file = p.getProperty("file");
        Object[] param = new String[]{ejb_file};
        String[] signature = new String[]{"java.lang.String"};
        Object deployed = null;
        try {
            deployed = this.getMBeanServerConnection().invoke(this.getObjectName(), "isJarDeployed", param, signature);
        }
        catch (Exception e) {
            throw new DeploymentException(e.getMessage());
        }
        return Boolean.parseBoolean(deployed.toString());
    }

    protected ModuleType findType(String path) throws DeploymentException {
        if (path.endsWith(ModuleType.EJB.getModuleExtension())) {
            return ModuleType.EJB;
        }
        if (path.endsWith(ModuleType.EAR.getModuleExtension())) {
            return ModuleType.EAR;
        }
        if (path.endsWith(ModuleType.WAR.getModuleExtension())) {
            return ModuleType.WAR;
        }
        if (path.endsWith(ModuleType.RAR.getModuleExtension())) {
            return ModuleType.RAR;
        }
        throw new DeploymentException("No module type found for path '" + path + "'.");
    }
}

