/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.ishmael.deploy.spi.impl;

import java.util.Properties;
import javax.enterprise.deploy.shared.ModuleType;
import org.ow2.ishmael.deploy.spi.exceptions.DeploymentException;
import org.ow2.ishmael.deploy.spi.exceptions.IshmaelDeploymentManagerCreationException;
import org.ow2.ishmael.deploy.spi.impl.AbsDeploymentSpecific;

public class DeploymentSpecificEasyBeans
extends AbsDeploymentSpecific {
    private static final String DEFAULT_OBJECTNAME = ":type=Deployer,name=EasyBeans";

    public DeploymentSpecificEasyBeans(String uri, String userName, String password) throws IshmaelDeploymentManagerCreationException {
        super(uri);
    }

    protected String getStringObjectName() {
        return DEFAULT_OBJECTNAME;
    }

    public String deployFile(ModuleType type, byte[] file, String name, String[] genicArgs) throws DeploymentException {
        Object[] param = new Object[]{name, file};
        String[] signature = new String[]{"java.lang.String", "[B"};
        String nameapp = null;
        try {
            nameapp = (String)this.getMBeanServerConnection().invoke(this.getObjectName(), "dumpFile", param, signature);
            return nameapp;
        }
        catch (Exception e) {
            throw new DeploymentException("Error during the deployment of '" + name + "'.", e);
        }
    }

    public String sendFile(ModuleType type, byte[] file, String name) throws DeploymentException {
        Object[] param = new Object[]{name, file};
        String[] signature = new String[]{"java.lang.String", "[B"};
        String nameapp = null;
        try {
            nameapp = (String)this.getMBeanServerConnection().invoke(this.getObjectName(), "distribute", param, signature);
            this.addAvailable(nameapp);
            return nameapp;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new DeploymentException(e.getMessage());
        }
    }

    public void deployApplication(Properties info) throws DeploymentException {
        String file = info.getProperty("file");
        Object[] param = new String[]{file};
        String[] signature = new String[]{"java.lang.String"};
        try {
            this.getMBeanServerConnection().invoke(this.getObjectName(), "deploy", param, signature);
        }
        catch (Exception e) {
            throw new DeploymentException("Error during the deployment", e);
        }
    }

    public void undeployApplication(Properties info) throws DeploymentException {
        String file = info.getProperty("file");
        Object[] param = new String[]{file};
        String[] signature = new String[]{"java.lang.String"};
        try {
            this.getMBeanServerConnection().invoke(this.getObjectName(), "undeploy", param, signature);
        }
        catch (Exception e) {
            throw new DeploymentException("Error during the deployment", e);
        }
    }
}

