/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.ishmael.deploy.spi.status;

import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import org.ow2.ishmael.deploy.spi.TargetModuleIDImpl;
import org.ow2.ishmael.deploy.spi.exceptions.DeploymentException;
import org.ow2.ishmael.deploy.spi.impl.IDeploymentSpecific;
import org.ow2.ishmael.deploy.spi.status.DeploymentStatusImpl;
import org.ow2.ishmael.deploy.spi.status.ProgressObjectImpl;

public class DistributeProgressObject
extends ProgressObjectImpl {
    byte[] file = null;
    String name = null;
    ModuleType type = null;
    String[] genicArgs = null;
    boolean conform = true;

    public DistributeProgressObject(IDeploymentSpecific adm, Target[] targets, byte[] file, String name, ModuleType type, String[] genicArgs, boolean conform) {
        super(adm, targets);
        this.file = file;
        this.name = name;
        this.type = type;
        this.status = new DeploymentStatusImpl(StateType.RUNNING, CommandType.DISTRIBUTE, ActionType.EXECUTE, "Preparing Deployment...");
        this.genicArgs = genicArgs;
        this.conform = conform;
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        TargetModuleID[] ids = new TargetModuleIDImpl[]{new TargetModuleIDImpl(this.name, this.targets[0], null)};
        return ids;
    }

    private void distribute() throws Exception {
        String appdeploy = null;
        if (!this.conform) {
            throw new Exception("Descriptor not valid");
        }
        try {
            appdeploy = this.adm.sendFile(this.file, this.name);
        }
        catch (DeploymentException e) {
            throw new IllegalStateException(e);
        }
        if (appdeploy != null) {
            this.name = appdeploy;
        }
    }

    public void run() {
        try {
            this.status = new DeploymentStatusImpl(StateType.RUNNING, CommandType.DISTRIBUTE, ActionType.EXECUTE, this.name + " deploying");
            ProgressEvent event = new ProgressEvent((Object)this, null, this.status);
            this.fireEvent(event);
            this.distribute();
            this.status = new DeploymentStatusImpl(StateType.COMPLETED, CommandType.DISTRIBUTE, ActionType.EXECUTE, this.name + " successfully deployed");
            ProgressEvent event1 = new ProgressEvent((Object)this, null, this.status);
            this.fireEvent(event1);
        }
        catch (Exception e) {
            this.status = new DeploymentStatusImpl(StateType.FAILED, CommandType.DISTRIBUTE, ActionType.EXECUTE, this.name + " failed to be deployed " + e.getMessage());
            ProgressEvent event = new ProgressEvent((Object)this, null, this.status);
            this.fireEvent(event);
        }
    }
}

