/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.ishmael.deploy.spi.status;

import java.util.Properties;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import org.ow2.ishmael.deploy.spi.impl.IDeploymentSpecific;
import org.ow2.ishmael.deploy.spi.status.DeploymentStatusImpl;
import org.ow2.ishmael.deploy.spi.status.ProgressObjectImpl;

public class StartProgressObject
extends ProgressObjectImpl {
    TargetModuleID[] paths;

    public StartProgressObject(IDeploymentSpecific adm, TargetModuleID[] paths) {
        super(adm, null);
        this.paths = paths;
        this.status = new DeploymentStatusImpl(StateType.RUNNING, CommandType.START, ActionType.EXECUTE, "Preparing Start...");
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        return this.paths;
    }

    private void startModules() throws Exception {
        for (int i = 0; i < this.paths.length; ++i) {
            String path = this.paths[i].getModuleID();
            Properties p = new Properties();
            p.setProperty("file", path);
            this.status = new DeploymentStatusImpl(StateType.RUNNING, CommandType.START, ActionType.EXECUTE, path + " starting");
            ProgressEvent event = new ProgressEvent((Object)this, null, this.status);
            this.fireEvent(event);
            this.adm.deployApplication(p);
            this.status = new DeploymentStatusImpl(StateType.COMPLETED, CommandType.START, ActionType.EXECUTE, path + " started");
            ProgressEvent event1 = new ProgressEvent((Object)this, null, this.status);
            this.fireEvent(event1);
        }
    }

    public void run() {
        try {
            this.startModules();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            this.status = new DeploymentStatusImpl(StateType.FAILED, CommandType.START, ActionType.EXECUTE, "Failed to be started " + e.getMessage());
            ProgressEvent event = new ProgressEvent((Object)this, null, this.status);
            this.fireEvent(event);
        }
    }
}

