/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.ishmael.deploy.spi.status;

import java.util.Properties;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import org.ow2.ishmael.deploy.spi.impl.IDeploymentSpecific;
import org.ow2.ishmael.deploy.spi.status.DeploymentStatusImpl;
import org.ow2.ishmael.deploy.spi.status.ProgressObjectImpl;

public class UnDeployProgressObject
extends ProgressObjectImpl {
    TargetModuleID[] paths;

    public UnDeployProgressObject(IDeploymentSpecific adm, TargetModuleID[] paths) {
        super(adm, null);
        this.paths = paths;
        this.status = new DeploymentStatusImpl(StateType.RUNNING, CommandType.UNDEPLOY, ActionType.EXECUTE, "Preparing Undeployment...");
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        return this.paths;
    }

    private void undeployModules() throws Exception {
        for (int i = 0; i < this.paths.length; ++i) {
            String path = this.paths[i].getModuleID();
            this.status = new DeploymentStatusImpl(StateType.RUNNING, CommandType.UNDEPLOY, ActionType.EXECUTE, path + " undeploying");
            ProgressEvent event = new ProgressEvent((Object)this, null, this.status);
            this.fireEvent(event);
            Properties p = new Properties();
            p.setProperty("file", path);
            this.adm.undeployApplication(p);
            this.status = new DeploymentStatusImpl(StateType.COMPLETED, CommandType.UNDEPLOY, ActionType.EXECUTE, path + " undeployed");
            ProgressEvent event1 = new ProgressEvent((Object)this, null, this.status);
            this.fireEvent(event1);
        }
    }

    public void run() {
        try {
            this.undeployModules();
        }
        catch (Exception e) {
            this.status = new DeploymentStatusImpl(StateType.FAILED, CommandType.UNDEPLOY, ActionType.EXECUTE, "Failed to be undeployed " + e.getMessage());
            ProgressEvent event = new ProgressEvent((Object)this, null, this.status);
            this.fireEvent(event);
        }
    }
}

