/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.ishmael.deploymentplan;

import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.impl.helper.DeployableEntry;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelperException;
import org.ow2.util.ee.deploy.impl.helper.UnpackDeployableHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;
import org.ow2.util.xml.DocumentParser;
import org.ow2.util.xml.DocumentParserException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JonasPlan {
    private static final String JDEPLOYMENTPLAN = "jonas-deployment-plan.xml";
    private static Log logger = LogFactory.getLog(JonasPlan.class);
    private String archiveName = null;
    private File file = null;
    private Hashtable planMap = new Hashtable();

    public void createPlan(File file) throws Exception {
        IDeployable deployable;
        IArchive deploymentPlanArchive = ArchiveManager.getInstance().getArchive((Object)file);
        try {
            deployable = DeployableHelper.getDeployable((IArchive)deploymentPlanArchive);
        }
        catch (DeployableHelperException e) {
            throw new Exception("Cannot get a deployable for the archive '" + deploymentPlanArchive + "'", e);
        }
        IDeployable unpackedPlan = UnpackDeployableHelper.unpack((IDeployable)deployable, (String)"jonas-plan");
        URL urlarchive = URLUtils.fileToURL2((File)file);
        String shorterArchiveName = URLUtils.shorterName((URL)urlarchive);
        Iterator itResouces = null;
        try {
            itResouces = unpackedPlan.getArchive().getResources();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get the resources on the archive '" + deploymentPlanArchive + "'.", (Throwable)e);
        }
        while (itResouces.hasNext()) {
            Node node;
            URL url = (URL)itResouces.next();
            String path = URLDecoder.decode(url.getPath(), "UTF-8");
            String entryName = path.substring(path.lastIndexOf(shorterArchiveName) + shorterArchiveName.length() + 1);
            this.updateMap(entryName, url);
            if (!entryName.equals(JDEPLOYMENTPLAN)) continue;
            Document document = null;
            try {
                document = DocumentParser.getDocument((URL)url, (boolean)false, null);
            }
            catch (DocumentParserException e) {
                throw new DeployerException("Cannot parse the url '" + url + "'", (Throwable)e);
            }
            Element planRootElement = document.getDocumentElement();
            NodeList moduleList = planRootElement.getElementsByTagName("archive-name");
            if (moduleList.getLength() <= 0 || (node = moduleList.item(0).getFirstChild()) == null) continue;
            this.setArchiveName(node.getNodeValue());
        }
        if (deploymentPlanArchive != null) {
            deploymentPlanArchive.close();
        }
        this.setFile(file);
    }

    private void updateMap(String entryName, URL urlEntry) {
        ArrayList alf = null;
        if (this.validentry(entryName)) {
            Entry entry = new Entry(entryName);
            entry.setUrlEntry(urlEntry);
            String key = entry.getArchiveName();
            if (!this.planMap.containsKey(key)) {
                alf = new ArrayList();
                this.planMap.put(key, alf);
            } else {
                alf = (ArrayList)this.planMap.get(key);
            }
            alf.add(entry);
        }
    }

    public void dumpMap() {
        System.out.println(">>>>> archivename: " + this.getArchiveName());
        Set keys = this.planMap.keySet();
        for (String key : keys) {
            ArrayList alf = null;
            alf = (ArrayList)this.planMap.get(key);
            System.out.println(" Key : " + key);
            for (int i = 0; i < alf.size(); ++i) {
                Entry en = (Entry)alf.get(i);
                System.out.println(">>>>> entry: " + en.getEntryName());
                System.out.println(">>>>> url: " + en.getUrlEntry().toString());
            }
        }
    }

    private boolean validentry(String entryName) {
        if (entryName.toLowerCase().startsWith("meta-inf/")) {
            return false;
        }
        return !entryName.equalsIgnoreCase(JDEPLOYMENTPLAN);
    }

    public void setArchiveName(String archiveName) {
        this.archiveName = archiveName;
    }

    public String getArchiveName() {
        return this.archiveName;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    File getResource(String name) {
        File res = (File)this.planMap.get(name);
        return res;
    }

    public List<DeployableEntry> getDeployableEntries(String key) {
        ArrayList<DeployableEntry> deployablesEntries = new ArrayList<DeployableEntry>();
        if (this.planMap.containsKey(key)) {
            ArrayList alf = (ArrayList)this.planMap.get(key);
            for (int i = 0; i < alf.size(); ++i) {
                Entry en = (Entry)alf.get(i);
                DeployableEntry de = new DeployableEntry();
                de.setFile(URLUtils.urlToFile((URL)en.getUrlEntry()));
                de.setName(en.getEntryName());
                deployablesEntries.add(de);
            }
            return deployablesEntries;
        }
        return null;
    }

    public class Entry {
        public String archiveName = null;
        public String entryName = null;
        public URL urlEntry = null;

        public Entry(String ddentryName) {
            StringTokenizer st = new StringTokenizer(ddentryName);
            String dir = st.nextToken().toUpperCase();
            String following = st.nextToken();
            StringTokenizer stf = new StringTokenizer(following, ".");
            String baseArchiveName = stf.nextToken();
            String extArchiveName = stf.nextToken();
            String baseDDName = stf.nextToken();
            String extDDName = stf.nextToken();
            this.archiveName = baseArchiveName + "." + extArchiveName;
            this.entryName = dir + "/" + baseDDName + "." + extDDName;
        }

        public String getArchiveName() {
            return this.archiveName;
        }

        public void setArchiveName(String archiveName) {
            this.archiveName = archiveName;
        }

        public String getEntryName() {
            return this.entryName;
        }

        public void setEntryName(String entryName) {
            this.entryName = entryName;
        }

        public URL getUrlEntry() {
            return this.urlEntry;
        }

        public void setUrlEntry(URL urlEntry) {
            this.urlEntry = urlEntry;
        }
    }
}

