/**
 * Ishmael : An open source implementation of JSR-88
 * Copyright (C) 2006
 * Contact: ishmael-dev@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DeploymentSpecificJOnAS.java 331 2007-09-10 12:11:37 +0000 (Mon, 10 Sep 2007) benoitf $
 * --------------------------------------------------------------------------
 */
package org.ow2.ishmael.deploy.spi.impl;

import org.ow2.ishmael.deploy.spi.exceptions.IshmaelDeploymentManagerCreationException;

/**
 * EJB3 deployment Specific
 */
public class DeploymentSpecificJOnAS extends AbsDeploymentSpecific  {   

    /**
     * Default object name
     */
    private static final String DEFAULT_OBJECTNAME = ":j2eeType=J2EEServer,name=jonas";

    /**
     * Constructor. Initialize connector to the remote system.
     * @param uri URI given by deployment tool
     */
    public DeploymentSpecificJOnAS(String uri, String userName, String password) throws IshmaelDeploymentManagerCreationException {
        super(uri);
    }


    @Override
    protected String getStringObjectName() {
        return DEFAULT_OBJECTNAME;
    }

}