/**
 * Ishmael : An open source implementation of JSR-88
 * Copyright (C) 2006
 * Contact: ishmael-dev@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: BasicDeploymentManager.java 345 2007-10-25 09:33:28Z benoitf $
 * --------------------------------------------------------------------------
 */
package org.ow2.ishmael.deploy.spi;

import java.io.File;
import java.io.InputStream;
import java.util.Locale;

import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;


/**
 * BasicDeploymentManager.java
 *
 * This is the disconnected-mode JSR-88 DeploymentManager for JOnAS.
 *
 * Created: Fri Nov 22 15:36:32 2002
 *
 * @author <a href="mailto:timh@mousetech.com">Tim Holloway</a>
 * @author Dean Jennings
 * @version
 */

public class BasicDeploymentManager implements DeploymentManager  {

    public BasicDeploymentManager () {

    }
    // implementation of javax.enterprise.deploy.spi.DeploymentManager interface

    /**
     * Start one or more targets.
     * @exception java.lang.IllegalStateException thrown because we're in disconnected mode
     */
    public ProgressObject start(TargetModuleID[] param1) throws IllegalStateException {
        throw new java.lang.IllegalStateException("\"start\" function is unavailable in disconnected mode");
    }

    /**
     * Stop one or more targets.
     * @exception java.lang.IllegalStateException thrown because we're in disconnected mode
     */
    public ProgressObject stop(TargetModuleID[] param1) throws IllegalStateException {
        throw new java.lang.IllegalStateException("\"stop\" function is unavailable in disconnected mode");
    }

    /**
     * @exception java.lang.IllegalStateException thrown because we're in disconnected mode
     */
    public Target[] getTargets() throws IllegalStateException {
        throw new java.lang.IllegalStateException("\"getTargets\" function is unavailable in disconnected mode");
    }

    /**
     *
     * @param param1 <description>
     * @param param2 <description>
     * @return <description>
     * @exception javax.enterprise.deploy.spi.exceptions.TargetException <description>
     * @exception java.lang.IllegalStateException <description>
     */
    public TargetModuleID[] getRunningModules(ModuleType param1, Target[] param2) throws TargetException, IllegalStateException {
        throw new java.lang.IllegalStateException("\"getRunningModules\" function is unavailable in disconnected mode");
    }

    /**
     *
     * @param param1 <description>
     * @param param2 <description>
     * @return <description>
     * @exception javax.enterprise.deploy.spi.exceptions.TargetException <description>
     * @exception java.lang.IllegalStateException <description>
     */
    public TargetModuleID[] getNonRunningModules(ModuleType param1, Target[] param2) throws TargetException, IllegalStateException {
        throw new java.lang.IllegalStateException("\"getNonRunningModules\" function is unavailable in disconnected mode");
    }

    /**
     *
     * @param param1 <description>
     * @param param2 <description>
     * @return <description>
     * @exception javax.enterprise.deploy.spi.exceptions.TargetException <description>
     * @exception java.lang.IllegalStateException <description>
     */
    public TargetModuleID[] getAvailableModules(ModuleType param1, Target[] param2) throws TargetException, IllegalStateException {
        throw new java.lang.IllegalStateException("\"getAvailableModules\" function is unavailable in disconnected mode");
    }

    /**
     *
     * @param dobj <description>
     * @return <description>
     * @exception javax.enterprise.deploy.spi.exceptions.InvalidModuleException <description>
     */
    public DeploymentConfiguration createConfiguration(DeployableObject dobj) throws InvalidModuleException {
        if (dobj == null) throw new InvalidModuleException("Null object passed");
        if (ModuleType.EJB.equals(dobj.getType())) {
            throw new InvalidModuleException("Not supported as yet");
        } else if (ModuleType.EAR.equals(dobj.getType())) {
            throw new InvalidModuleException("Not supported as yet");
        } else if (ModuleType.WAR.equals(dobj.getType())) {
            throw new InvalidModuleException("Not supported as yet");
        } else if (ModuleType.CAR.equals(dobj.getType())) {
            throw new InvalidModuleException("Not supported as yet");
        } else if (ModuleType.RAR.equals(dobj.getType())) {
            throw new InvalidModuleException("Not supported as yet");
        } else {
            throw new InvalidModuleException("Not supported as yet");
        }

    }

    /**
     *
     * @param param1 <description>
     * @param param2 <description>
     * @param param3 <description>
     * @return <description>
     * @exception java.lang.IllegalStateException <description>
     */
    public ProgressObject distribute(Target[] param1, File param2, File param3) throws IllegalStateException {
        throw new java.lang.IllegalStateException("\"distribute\" function (using file) is unavailable in disconnected mode");
    }

    /**
     *
     * @param param1 <description>
     * @param param2 <description>
     * @param param3 <description>
     * @return <description>
     * @exception java.lang.IllegalStateException <description>
     */
    public ProgressObject distribute(Target[] param1, InputStream param2, InputStream param3) throws IllegalStateException {
        throw new java.lang.IllegalStateException("\"distribute\" function (dynamic) is unavailable in disconnected mode");
    }

    public ProgressObject distribute(Target[] arg0, ModuleType arg1,
            InputStream arg2, InputStream arg3) throws IllegalStateException {
         throw new java.lang.IllegalStateException("\"distribute\" function (dynamic) is unavailable in disconnected mode");
    }

    /**
     *
     * @param param1 <description>
     * @return <description>
     * @exception java.lang.IllegalStateException <description>
     */
    public ProgressObject undeploy(TargetModuleID[] param1) throws IllegalStateException {
        throw new java.lang.IllegalStateException("\"undeploy\" function is unavailable in disconnected mode");
    }

    /**
     *
     * @return <description>
     */
    public boolean isRedeploySupported() {
        return false;
    }

    /**
     *
     * @param param1 <description>
     * @param param2 <description>
     * @param param3 <description>
     * @return <description>
     * @exception java.lang.UnsupportedOperationException <description>
     * @exception java.lang.IllegalStateException <description>
     */
    public ProgressObject redeploy(TargetModuleID[] param1, File param2, File param3) throws UnsupportedOperationException, IllegalStateException {
        throw new java.lang.UnsupportedOperationException("\"redeploy\" function (from file) is unavailable in disconnected mode");
    }

    /**
     *
     * @param param1 <description>
     * @param param2 <description>
     * @param param3 <description>
     * @return <description>
     * @exception java.lang.UnsupportedOperationException <description>
     * @exception java.lang.IllegalStateException <description>
     */
    public ProgressObject redeploy(TargetModuleID[] param1, InputStream param2, InputStream param3) throws UnsupportedOperationException, IllegalStateException {
        throw new java.lang.UnsupportedOperationException("\"redeploy\" function (dynamic) is unavailable in disconnected mode");
    }

    /**
     *
     */
    public void release() {
    // TODO: implement this javax.enterprise.deploy.spi.DeploymentManager method
    }

    /**
     *
     * @return <description>
     */
    public Locale getDefaultLocale() {
        // TODO: implement this javax.enterprise.deploy.spi.DeploymentManager method
        return Locale.getDefault();
    }

    /**
     *
     * @return <description>
     */
    public Locale getCurrentLocale() {
        // TODO: implement this javax.enterprise.deploy.spi.DeploymentManager method
        return Locale.getDefault();
    }

    /**
     *
     * @param loc <description>
     * @exception java.lang.UnsupportedOperationException <description>
     */
    public void setLocale(Locale loc) throws UnsupportedOperationException {
        Locale.setDefault(loc);
    }

    /**
     *
     * @return <description>
     */
    public Locale[] getSupportedLocales() {
        // TODO: implement this javax.enterprise.deploy.spi.DeploymentManager method
        return Locale.getAvailableLocales();
    }

    /**
     *
     * @param locale locale is supported or not ?
     * @return true if it's supported, else fails
     */
    public boolean isLocaleSupported(Locale locale) {
        Locale[] locales = Locale.getAvailableLocales();
        for (int l = 0; l < locales.length; l++) {
          if (locales[l].equals(locale)) {
              // supported locale
              return true;
          }
        }
        return false;
    }

    /**
     *
     * @return <description>
     */
    public DConfigBeanVersionType getDConfigBeanVersion() {
        // TODO: implement this javax.enterprise.deploy.spi.DeploymentManager method
        return null;
    }

    /**
     *
     * @param param1 <description>
     * @return <description>
     */
    public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType param1) {
        // TODO: implement this javax.enterprise.deploy.spi.DeploymentManager method
        return false;
    }

    /**
     *
     * @param param1 <description>
     * @exception javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException <description>
     */
    public void setDConfigBeanVersion(DConfigBeanVersionType param1) throws DConfigBeanVersionUnsupportedException {
        // TODO: implement this javax.enterprise.deploy.spi.DeploymentManager method
    }



}
