/**
 * Ishmael : An open source implementation of JSR-88
 * Copyright (C) 2006
 * Contact: ishmael-dev@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: TargetModuleIDImpl.java 345 2007-10-25 09:33:28Z benoitf $
 * --------------------------------------------------------------------------
 */
package org.ow2.ishmael.deploy.spi;

import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;

public class TargetModuleIDImpl implements TargetModuleID {

    private String id;

    private Target target;

    private String url;

    public TargetModuleIDImpl(final String id, final Target target, final String url) {
        this.target = target;
        this.id = id;
        this.url = url;
    }

    public TargetModuleIDImpl(final String id, final Target target) {
        this.target = target;
        this.id = id;
    }

    // TODO: add child for ear module
    public TargetModuleID[] getChildTargetModuleID() {
        TargetModuleID[] noChildForEar = {};
        TargetModuleID[] noChildForStandAloneApp = null;
        if (id.endsWith("ear")) {
            return noChildForEar;
        } else {
            return noChildForStandAloneApp;
        }
    }

    public String getModuleID() {
        return id;
    }

    public TargetModuleID getParentTargetModuleID() {
        return null;
    }

    public Target getTarget() {
        return target;
    }

    public String getWebURL() {
        return url;
    }

    @Override
    public String toString() {
        return id + ":" + target.getName();
    }

    @Override
    public boolean equals(final Object id) {
        if (id == null) {
            return false;
        }
        if (id instanceof TargetModuleID) {
            TargetModuleID otherTargetModuleId = (TargetModuleID) id;
            String otherModuleId = otherTargetModuleId.getModuleID();
            Target otherTarget = otherTargetModuleId.getTarget();
            if (otherModuleId == null || otherTarget == null) {
                return false;
            }
            return (otherModuleId.equalsIgnoreCase(this.getModuleID()) && (otherTarget.getName().equalsIgnoreCase(this
                    .getTarget().getName())));
        }
        return false;
    }

    public int hashCode() {
        return toString().hashCode();
    }

}
