/**
 * Ishmael : An open source implementation of JSR-88
 * Copyright (C) 2006
 * Contact: ishmael-dev@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DeploymentFactoryImpl.java 317 2006-02-15 13:58:25 +0000 (Wed, 15 Feb 2006) benoitf $
 * --------------------------------------------------------------------------
 */
package org.ow2.ishmael.deploy.spi.factories;

import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;

import org.ow2.ishmael.deploy.spi.BasicConnectedDeploymentManager;
import org.ow2.ishmael.deploy.spi.BasicDeploymentManager;

/**
 * DeploymentFactoryImpl URI Form: deployer:jonas:server:port
 * server=servername/jonasname or "offline" Created: Sun Nov 24 09:02:10 2002
 * @author <a href="mailto:timh@mousetech.com">Tim Holloway</a>
 * @version
 */

public class DeploymentFactoryImpl implements DeploymentFactory {

    /**
     * URIs we respons to
     */
    public static final String TEST_URI = "deployer:ishmael";

    /**
     * Name of this deployer
     */
    public static final String DEPLOYER_NAME = "Ishmael Lite Deployer";

    /**
     * Version
     */
    public static final String VERSION = "0.1";

    public DeploymentFactoryImpl() {

    }

    /**
     * @return <description>
     */
    public String getDisplayName() {
        return DEPLOYER_NAME;
    }

    /**
     * @param uri a <code>String</code> value
     * @return <code>true</code> if this factory can handle the indicated URI.
     */
    public boolean handlesURI(String uri) {
        return uri.startsWith(TEST_URI);
    }

    /**
     * Describe <code>getDeploymentManager</code> method here.
     * @param uri used to manufacture a <code>DeploymentManager</code>,
     * @param username Username used to login
     * @param password Password used to login
     * @return A JOnAS-sepcific <code>DeploymentManager</code>
     * @exception DeploymentManagerCreationException if an error occurs
     * @exception
     *            javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException
     *            <description>
     */
    public DeploymentManager getDeploymentManager(String uri, String username, String password)
            throws DeploymentManagerCreationException {
        return new BasicConnectedDeploymentManager(uri, username, password);
    }

    /**
     * Describe <code>getDisconnectedDeploymentManager</code> method here.
     * @param uri a <code>String</code> value
     * @return <description>
     * @exception DeploymentManagerCreationException if an error occurs
     * @exception
     *            javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException
     *            <description>
     */
    public DeploymentManager getDisconnectedDeploymentManager(String uri) {
        return new BasicDeploymentManager();
    }

    /**
     * @return <description>
     */
    public String getProductVersion() {
        return VERSION;
    }
}
