/**
 * Ishmael : An open source implementation of JSR-88
 * Copyright (C) 2006-2007
 * Contact: ishmael-dev@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DeploymentSpecificEasyBeans.java 323 2007-05-14 09:56:57 +0000 (Mon, 14 May 2007) benoitf $
 * --------------------------------------------------------------------------
 */
package org.ow2.ishmael.deploy.spi.impl;

import java.util.Properties;

import javax.enterprise.deploy.shared.ModuleType;

import org.ow2.ishmael.deploy.spi.exceptions.DeploymentException;
import org.ow2.ishmael.deploy.spi.exceptions.IshmaelDeploymentManagerCreationException;

/**
 * EJB3 deployment Specific
 */
public class DeploymentSpecificEasyBeans extends AbsDeploymentSpecific {

    /**
     * Default object name
     */
    private static final String DEFAULT_OBJECTNAME = ":type=Deployer,name=EasyBeans";

    /**
     * Constructor. Initialize connector to the remote system.
     * @param uri URI given by deployment tool
     */
    public DeploymentSpecificEasyBeans(String uri, String userName, String password)
            throws IshmaelDeploymentManagerCreationException {
        super(uri);
    }

    @Override
    protected String getStringObjectName() {
        return DEFAULT_OBJECTNAME;
    }

    /**
     * deploy the file on the server : call genic to generate class for JOnAS
     * and copy the result file into JOnAS server directory for deployment
     * @param type
     * @param file
     * @param name
     * @throws DeploymentException
     */
    public String deployFile(ModuleType type, byte[] file, String name, String[] genicArgs) throws DeploymentException {
        Object param[] = {name, file};
        String signature[] = {"java.lang.String", "[B", };

        // invoke method on the MBean
        String nameapp = null;
        try {
            nameapp = (String) getMBeanServerConnection().invoke(getObjectName(), "dumpFile", param, signature);
            return nameapp;
        } catch (Exception e) {
            throw new DeploymentException("Error during the deployment of '" + name + "'.", e);
        }
    }
    /**
     * distribute (send)  the file on the server
     * and copy the result file into JOnAS server directory for deployment
     * @param type  of the archive
     * @param file Byte Array representing the file to upload
     * @param name name of the file
     * @return path to the distributed file
     * @throws DeploymentException
     */
    public String sendFile(ModuleType type, byte[] file, String name) throws DeploymentException {
        Object param[] = {name, file};
        String signature[] = {"java.lang.String", "[B" };
        // invoke method on the MBean
        String nameapp = null;
        try {
            nameapp = (String) getMBeanServerConnection().invoke(getObjectName(), "distribute", param, signature);
            addAvailable(nameapp);
            return nameapp;


        } catch (Exception e) {
            e.printStackTrace(System.out);
            throw (new DeploymentException(e.getMessage()));
        }
    }


    /**
     * Deploy a file on EasyBeans.
     * @param info property name file indicate the name of the file to deploy
     * @throws DeploymentException if the deployment fails
     */
    /**
     * deploy application p
     * @param p
     * @throws DeploymentException
     */
    public void deployApplication(final Properties info) throws DeploymentException {
        String file = info.getProperty("file");
        String param[] = { file };
        String signature[] = { "java.lang.String" };

        // invoke method on the MBean
        try {
            getMBeanServerConnection().invoke(getObjectName(), "deploy", param, signature);
        } catch (Exception e) {
            throw new DeploymentException("Error during the deployment", e);
        }
    }

    /**
     * Undeploy application p
     * @param p
     * @throws DeploymentException
     */
    public void undeployApplication(final Properties info) throws DeploymentException {
        String file = info.getProperty("file");
        String param[] = { file };
        String signature[] = { "java.lang.String" };

        // invoke method on the MBean
        try {
            getMBeanServerConnection().invoke(getObjectName(), "undeploy", param, signature);
        } catch (Exception e) {
            throw new DeploymentException("Error during the deployment", e);
        }
   }

}