/**
 * Ishmael : An open source implementation of JSR-88
 * Copyright (C) 2006
 * Contact: ishmael-dev@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: IDeploymentSpecific.java 325 2007-07-20 09:24:21 +0000 (Fri, 20 Jul 2007) benoitf $
 * --------------------------------------------------------------------------
 */
package org.ow2.ishmael.deploy.spi.impl;

import java.util.List;
import java.util.Properties;

import javax.enterprise.deploy.shared.ModuleType;

import org.ow2.ishmael.deploy.spi.exceptions.DeploymentException;

/**
 * Interface that all implementation needs to implement
 * @author Florent Benoit
 */
public interface IDeploymentSpecific {

    /**
       * State of the modules distributed on the Server but undeployed
       */
       static final int AVAILABLE = 0;

      /**
       * State of the modules deployed on the Server
       */
       static final int RUNNING = 1;

    /**
     * List modules type in a given state
     * @param state of the module
     * @param  J2EE module types
     *
     * @return  a list of J2EE modules in   the given state
     * @throws DeploymentException
     */
    
    List listModules(ModuleType type, int state) throws DeploymentException;

    /*
     *   get deployed modules
     *   @param  J2EE module types
     *
     *    @return  a list of deployed J2EE module  of the given state
     */
      List getDeployedModules(ModuleType type) throws DeploymentException;




    /**
     * distribute (send)  the file on the server
     * and copy the result file into JOnAS server directory for deployment
     * @param type  of the archive
     * @param file Byte Array representing the file to upload
     * @param name name of the file
     * @return path to the distributed file
     * @throws DeploymentException
     */
    String sendFile(byte[] file, String name ) throws DeploymentException;

    /**
     * deploy application p
     * @param p
     * @throws DeploymentException
     */
    void deployApplication(Properties p) throws DeploymentException;


    /**
     * Stop application p
     * @param p
     * @throws DeploymentException
     */
    void stopApplication(Properties p) throws DeploymentException;


    /**
     * Undeploy application p
     * @param p
     * @throws DeploymentException
     */
    public void undeployApplication(Properties p) throws DeploymentException;

}
