/**
 * Ishmael : An open source implementation of JSR-88
 * Copyright (C) 2006
 * Contact: ishmael-dev@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DeploymentStatusImpl.java 317 2006-02-15 13:58:25 +0000 (Wed, 15 Feb 2006) benoitf $
 * --------------------------------------------------------------------------
 */
package org.ow2.ishmael.deploy.spi.status;

import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.status.DeploymentStatus;

public class DeploymentStatusImpl implements DeploymentStatus {

	StateType state;
	CommandType command;
	ActionType action;
	String message;

	public DeploymentStatusImpl(StateType state, CommandType command, ActionType action, String message) {
		this.state = state;
		this.command = command;
		this.action = action;
		this.message = message;
	}

	public ActionType getAction() {
		return action;
	}
	public CommandType getCommand() {
		return command;
	}
	public String getMessage() {
		return message;
	}
	public StateType getState() {
		return state;
	}
	public boolean isCompleted() {
		return (state.getValue() == StateType.COMPLETED.getValue());
	}
	public boolean isFailed() {
		return (state.getValue() == StateType.FAILED.getValue());
	}
	public boolean isRunning() {
		return (state.getValue() == StateType.RUNNING.getValue());
	}


}