/**
 * Ishmael : An open source implementation of JSR-88
 * Copyright (C) 2006
 * Contact: ishmael-dev@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ProgressObjectImpl.java 317 2006-02-15 13:58:25 +0000 (Wed, 15 Feb 2006) benoitf $
 * --------------------------------------------------------------------------
 */
package org.ow2.ishmael.deploy.spi.status;

import java.util.ArrayList;
import java.util.List;

import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;

import org.ow2.ishmael.deploy.spi.impl.IDeploymentSpecific;


public abstract class ProgressObjectImpl implements ProgressObject, Runnable {
    List<ProgressListener> listeners = new ArrayList<ProgressListener>();
    IDeploymentSpecific adm = null;
    Target[] targets;
    DeploymentStatus status = null;

    public ProgressObjectImpl(IDeploymentSpecific adm, Target[] targets) {
        this.adm = adm;
        this.targets = targets;
    }

    public void addProgressListener(ProgressListener pol) {
        listeners.add(pol);
    }
    public void cancel() {
        throw new UnsupportedOperationException("Not Supported");
    }
    public ClientConfiguration getClientConfiguration(TargetModuleID id) {
        return null;
    }
    public DeploymentStatus getDeploymentStatus() {
        return status;
    }

    public boolean isCancelSupported() {
        return false;
    }
    public boolean isStopSupported() {
        return false;
    }
    public void removeProgressListener(ProgressListener pol) {
        listeners.remove(pol);
    }

    public void stop() {
        throw new UnsupportedOperationException("Not Supported");
    }

    protected void fireEvent(ProgressEvent event) {
        for (ProgressListener pl : listeners) {
            pl.handleProgressEvent(event);
        }
    }

}