/**
 * Ishmael : An open source implementation of JSR-88
 * Copyright (C) 2006
 * Contact: ishmael-dev@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: StopProgressObject.java 317 2006-02-15 13:58:25 +0000 (Wed, 15 Feb 2006) benoitf $
 * --------------------------------------------------------------------------
 */
package org.ow2.ishmael.deploy.spi.status;

import java.util.Properties;

import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressEvent;

import org.ow2.ishmael.deploy.spi.impl.IDeploymentSpecific;

public class StopProgressObject extends ProgressObjectImpl {
    TargetModuleID[] paths;

    public StopProgressObject(IDeploymentSpecific adm, TargetModuleID[] paths) {
        super(adm, null);
        this.paths = paths;
        this.status = new DeploymentStatusImpl(StateType.RUNNING, CommandType.STOP, ActionType.EXECUTE, "Preparing stop...");
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        return paths;
    }

    private void stopModules() throws Exception {
        for (int i = 0; i < paths.length; i++) {
            String path = paths[i].getModuleID();

            Properties p = new Properties();
            p.setProperty("file",path);

            status = new DeploymentStatusImpl(StateType.RUNNING, CommandType.STOP, ActionType.EXECUTE, path + " stopping");
            ProgressEvent event = new ProgressEvent(this, null,status);
            fireEvent(event);

            adm.stopApplication(p);

            status = new DeploymentStatusImpl(StateType.COMPLETED, CommandType.STOP, ActionType.EXECUTE, path + " stopped");
            ProgressEvent event1 = new ProgressEvent(this, null,status);
            fireEvent(event1);
        }
    }

    public void run() {
        try {
            stopModules();
    } catch (Exception e) {
            status = new DeploymentStatusImpl(StateType.FAILED, CommandType.STOP, ActionType.EXECUTE, "Failed to be stopped " + e.getMessage());
            ProgressEvent event = new ProgressEvent(this, null,status);
            fireEvent(event);
        }
    }

}