/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.ishmael.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import junit.framework.TestCase;
import org.ow2.ishmael.deploy.spi.BasicConnectedDeploymentManager;

public class TestDeploymentJOnAS
extends TestCase {
    BasicConnectedDeploymentManager man = null;
    File archiveEAREE5 = new File("ressources/test/ear/javaee5-earsample.ear");
    File archiveEJB3 = new File("ressources/test/ejb/ejb3.jar");
    File archiveEAR = new File("ressources/test/ear/earsample.ear");
    File planEar = new File("ressources/test/ear/depplanEarSample.jar");
    File archiveEJB2 = new File("ressources/test/ejb/eb.jar");
    File planEjb2 = new File("ressources/test/ejb/depplanEb.jar");
    private static int timeToSleep = 1000;
    private static int timeMaxtoWait = timeToSleep * 10;

    public TestDeploymentJOnAS(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.man = new BasicConnectedDeploymentManager("deployer:ishmael:service:jmx:rmi://localhost/jndi/rmi://localhost:1099/jrmpconnector_jonas", "", "");
    }

    public void tearDown() {
        this.man = null;
    }

    public void testDeployEJB3Files() throws Exception {
        TargetModuleID[] oneTargetEJB3 = new TargetModuleID[1];
        oneTargetEJB3 = this.deployEJBFiles(this.archiveEJB3, null);
        TestDeploymentJOnAS.assertNotNull((Object)oneTargetEJB3[0].getModuleID());
    }

    public void testDeployEJB2Files() throws Exception {
        TargetModuleID[] oneTargetEJB2 = new TargetModuleID[1];
        oneTargetEJB2 = this.deployEJBFiles(this.archiveEJB2, this.planEjb2);
        TestDeploymentJOnAS.assertNotNull((Object)oneTargetEJB2[0].getModuleID());
    }

    private TargetModuleID[] deployEJBFiles(File fileToDeploy, File depPlan) throws Exception {
        if (fileToDeploy.exists()) {
            ProgressObject po = this.man.distribute(this.man.getTargets(), fileToDeploy, depPlan);
            TestListener t = new TestListener();
            po.addProgressListener((ProgressListener)t);
            boolean pass = false;
            long start = System.currentTimeMillis();
            while (!pass && System.currentTimeMillis() - start < (long)timeMaxtoWait) {
                DeploymentStatus state = t.getState();
                if (state != null && state.isCompleted()) {
                    pass = true;
                } else if (state != null && state.isFailed()) {
                    TestDeploymentJOnAS.fail((String)("Deployment Failed " + state.getMessage()));
                }
                Thread.sleep(timeToSleep);
            }
            if (!pass) {
                TestDeploymentJOnAS.fail((String)"Deployment took too long");
                return null;
            }
            return po.getResultTargetModuleIDs();
        }
        TestDeploymentJOnAS.fail((String)("EJB application doesn't exist : " + this.archiveEJB3.getAbsolutePath()));
        return null;
    }

    public void testDeployEJB3Streams() throws Exception {
        FileInputStream fst = new FileInputStream(this.archiveEJB3);
        ProgressObject po = this.man.distribute(this.man.getTargets(), (InputStream)fst, null);
        TestListener t = new TestListener();
        po.addProgressListener((ProgressListener)t);
        boolean pass = false;
        long start = System.currentTimeMillis();
        while (!pass && System.currentTimeMillis() - start < (long)timeMaxtoWait) {
            DeploymentStatus state = t.getState();
            if (state != null && state.isCompleted()) {
                pass = true;
            } else if (state != null && state.isFailed()) {
                TestDeploymentJOnAS.fail((String)("Deployment Failed " + state.getMessage()));
            }
            Thread.sleep(timeToSleep);
        }
        if (!pass) {
            TestDeploymentJOnAS.fail((String)"Deployment took too long");
        }
    }

    public void testDeployEAREE5Streams() throws Exception {
        FileInputStream fst = new FileInputStream(this.archiveEAREE5);
        ProgressObject po = this.man.distribute(this.man.getTargets(), (InputStream)fst, null);
        TestListener t = new TestListener();
        po.addProgressListener((ProgressListener)t);
        boolean pass = false;
        long start = System.currentTimeMillis();
        while (!pass && System.currentTimeMillis() - start < (long)timeMaxtoWait) {
            DeploymentStatus state = t.getState();
            if (state != null && state.isCompleted()) {
                pass = true;
            } else if (state != null && state.isFailed()) {
                TestDeploymentJOnAS.fail((String)("Deployment Failed " + state.getMessage()));
            }
            Thread.sleep(timeToSleep);
        }
        if (!pass) {
            TestDeploymentJOnAS.fail((String)"Deployment took too long");
        }
    }

    private TargetModuleID[] deployEARFiles(File fileToDeploy, File depPlan) throws Exception {
        ProgressObject po = this.man.distribute(this.man.getTargets(), fileToDeploy, depPlan);
        TestListener t = new TestListener();
        po.addProgressListener((ProgressListener)t);
        boolean pass = false;
        long start = System.currentTimeMillis();
        while (!pass && System.currentTimeMillis() - start < (long)timeMaxtoWait) {
            DeploymentStatus state = t.getState();
            if (state != null && state.isCompleted()) {
                pass = true;
            } else if (state != null && state.isFailed()) {
                TestDeploymentJOnAS.fail((String)("Deployment Failed " + state.getMessage()));
            }
            Thread.sleep(timeToSleep);
        }
        if (!pass) {
            TestDeploymentJOnAS.fail((String)"Deployment took too long");
            return null;
        }
        return po.getResultTargetModuleIDs();
    }

    public void testDeployEAREE5Files() throws Exception {
        TargetModuleID[] oneTargetEAREE5 = new TargetModuleID[1];
        oneTargetEAREE5 = this.deployEARFiles(this.archiveEAREE5, null);
        TestDeploymentJOnAS.assertNotNull((Object)oneTargetEAREE5[0].getModuleID());
    }

    public void testDeployEARFiles() throws Exception {
        TargetModuleID[] oneTargetEAR = new TargetModuleID[1];
        oneTargetEAR = this.deployEARFiles(this.archiveEAR, this.planEar);
        TestDeploymentJOnAS.assertNotNull((Object)oneTargetEAR[0].getModuleID());
    }

    public void testUndeployEjb3() throws Exception {
        TargetModuleID[] ids = this.deployEJBFiles(this.archiveEJB3, null);
        ProgressObject po = this.man.undeploy(ids);
        TestListener t = new TestListener();
        po.addProgressListener((ProgressListener)t);
        boolean pass = false;
        long start = System.currentTimeMillis();
        while (!pass && System.currentTimeMillis() - start < (long)timeMaxtoWait) {
            DeploymentStatus state = t.getState();
            if (state != null && state.isCompleted()) {
                pass = true;
            } else if (state != null && state.isFailed()) {
                TestDeploymentJOnAS.fail((String)("Start Failed " + state.getMessage()));
            }
            Thread.sleep(timeToSleep);
        }
        if (!pass) {
            TestDeploymentJOnAS.fail((String)"Undeploy took too long");
        }
    }

    public void testEJBModules() throws Exception {
        try {
            TargetModuleID[] ids = this.man.getAvailableModules(ModuleType.EJB, this.man.getTargets());
            for (int i = 0; i < ids.length; ++i) {
                System.out.println("Path : " + ids[i].getModuleID());
            }
        }
        catch (Exception e) {
            TestDeploymentJOnAS.fail((String)("getAvailableModules" + e.toString()));
        }
    }

    public void testEarModules() throws Exception {
        try {
            TargetModuleID[] ids = this.man.getAvailableModules(ModuleType.EAR, this.man.getTargets());
            for (int i = 0; i < ids.length; ++i) {
                System.out.println("Path : " + ids[i].getModuleID());
            }
        }
        catch (Exception e) {
            TestDeploymentJOnAS.fail((String)("getAvailableModules" + e.toString()));
        }
    }

    public void testRunningEJB3Modules() throws Exception {
        TargetModuleID[] idsAfter = this.man.getRunningModules(ModuleType.EJB, this.man.getTargets());
        TargetModuleID[] ids = this.deployEJBFiles(this.archiveEJB3, null);
        if (ids == null) {
            TestDeploymentJOnAS.fail((String)"Start Failed because testDeployEARFiles return null");
        } else {
            TargetModuleID[] idsBefore;
            ProgressObject po = this.man.start(ids);
            TestListener t = new TestListener();
            po.addProgressListener((ProgressListener)t);
            boolean pass = false;
            long start = System.currentTimeMillis();
            while (!pass && System.currentTimeMillis() - start < (long)timeMaxtoWait) {
                DeploymentStatus state = t.getState();
                if (state != null && state.isCompleted()) {
                    pass = true;
                } else if (state != null && state.isFailed()) {
                    TestDeploymentJOnAS.fail((String)("Start Failed " + state.getMessage()));
                }
                Thread.sleep(timeToSleep);
            }
            if (!pass) {
                TestDeploymentJOnAS.fail((String)"Start took too long");
            }
            if (idsAfter.length + 1 != (idsBefore = this.man.getRunningModules(ModuleType.EJB, this.man.getTargets())).length) {
                TestDeploymentJOnAS.fail((String)"The number of EJB deploy is incorrect");
            }
            ProgressObject postop = this.man.undeploy(ids);
            TestListener tstop = new TestListener();
            postop.addProgressListener((ProgressListener)tstop);
            boolean passstop = false;
            long startstop = System.currentTimeMillis();
            while (!passstop && System.currentTimeMillis() - startstop < (long)timeMaxtoWait) {
                DeploymentStatus state = tstop.getState();
                if (state != null && state.isCompleted()) {
                    passstop = true;
                } else if (state != null && state.isFailed()) {
                    TestDeploymentJOnAS.fail((String)("Stop Failed " + state.getMessage()));
                }
                Thread.sleep(timeToSleep);
            }
            if (!passstop) {
                TestDeploymentJOnAS.fail((String)"Stop took too long");
            }
        }
    }

    public void testRunningEAREE5Modules() throws Exception {
        TargetModuleID[] idsAfter = this.man.getRunningModules(ModuleType.EAR, this.man.getTargets());
        TargetModuleID[] ids = this.deployEJBFiles(this.archiveEAREE5, null);
        if (ids == null) {
            TestDeploymentJOnAS.fail((String)"Start Failed because testDeployEARFiles return null");
        } else {
            TargetModuleID[] idsBefore;
            ProgressObject po = this.man.start(ids);
            TestListener t = new TestListener();
            po.addProgressListener((ProgressListener)t);
            boolean pass = false;
            long start = System.currentTimeMillis();
            while (!pass && System.currentTimeMillis() - start < (long)timeMaxtoWait) {
                DeploymentStatus state = t.getState();
                if (state != null && state.isCompleted()) {
                    pass = true;
                } else if (state != null && state.isFailed()) {
                    TestDeploymentJOnAS.fail((String)("Start Failed " + state.getMessage()));
                }
                Thread.sleep(timeToSleep);
            }
            if (!pass) {
                TestDeploymentJOnAS.fail((String)"Start took too long");
            }
            if (idsAfter.length + 1 != (idsBefore = this.man.getRunningModules(ModuleType.EAR, this.man.getTargets())).length) {
                TestDeploymentJOnAS.fail((String)"The number of EAR deploy is incorrect");
            }
            ProgressObject postop = this.man.undeploy(ids);
            TestListener tstop = new TestListener();
            postop.addProgressListener((ProgressListener)tstop);
            boolean passstop = false;
            long startstop = System.currentTimeMillis();
            while (!passstop && System.currentTimeMillis() - startstop < (long)timeMaxtoWait) {
                DeploymentStatus state = tstop.getState();
                if (state != null && state.isCompleted()) {
                    passstop = true;
                } else if (state != null && state.isFailed()) {
                    TestDeploymentJOnAS.fail((String)("Stop Failed " + state.getMessage()));
                }
                Thread.sleep(timeToSleep);
            }
            if (!passstop) {
                TestDeploymentJOnAS.fail((String)"Stop took too long");
            }
        }
    }

    public void testStartStopEar() throws Exception {
        TargetModuleID[] ids = this.deployEARFiles(this.archiveEAR, this.planEar);
        if (ids == null) {
            TestDeploymentJOnAS.fail((String)"Start Failed because testDeployEARFiles return null");
        } else {
            ProgressObject po = this.man.start(ids);
            TestListener t = new TestListener();
            po.addProgressListener((ProgressListener)t);
            boolean pass = false;
            long start = System.currentTimeMillis();
            while (!pass && System.currentTimeMillis() - start < 300000L) {
                DeploymentStatus state = t.getState();
                if (state != null && state.isCompleted()) {
                    pass = true;
                } else if (state != null && state.isFailed()) {
                    TestDeploymentJOnAS.fail((String)("Start Failed " + state.getMessage()));
                }
                Thread.sleep(5000L);
            }
            if (!pass) {
                TestDeploymentJOnAS.fail((String)"Start took too long");
            }
            ProgressObject postop = this.man.stop(ids);
            TestListener tstop = new TestListener();
            postop.addProgressListener((ProgressListener)tstop);
            boolean passstop = false;
            long startstop = System.currentTimeMillis();
            while (!passstop && System.currentTimeMillis() - startstop < 300000L) {
                DeploymentStatus state = tstop.getState();
                if (state != null && state.isCompleted()) {
                    passstop = true;
                } else if (state != null && state.isFailed()) {
                    TestDeploymentJOnAS.fail((String)("Stop Failed " + state.getMessage()));
                }
                Thread.sleep(5000L);
            }
            if (!passstop) {
                TestDeploymentJOnAS.fail((String)"Stop took too long");
            }
        }
    }

    public void testStartStopEjb2() throws Exception {
        TargetModuleID[] ids = this.deployEJBFiles(this.archiveEJB2, this.planEjb2);
        if (ids == null) {
            TestDeploymentJOnAS.fail((String)"Start Failed because testDeployEJBFiles return null");
        } else {
            System.out.println(">>> archiveEJB2 distributed");
            ProgressObject po = this.man.start(ids);
            TestListener t = new TestListener();
            po.addProgressListener((ProgressListener)t);
            boolean pass = false;
            long start = System.currentTimeMillis();
            while (!pass && System.currentTimeMillis() - start < 300000L) {
                DeploymentStatus state = t.getState();
                if (state != null && state.isCompleted()) {
                    pass = true;
                } else if (state != null && state.isFailed()) {
                    TestDeploymentJOnAS.fail((String)("Start Failed " + state.getMessage()));
                }
                Thread.sleep(5000L);
            }
            if (!pass) {
                TestDeploymentJOnAS.fail((String)"Start took too long");
            }
            System.out.println(">>> archiveEJB2 started");
            ProgressObject postop = this.man.stop(ids);
            TestListener tstop = new TestListener();
            postop.addProgressListener((ProgressListener)tstop);
            boolean passstop = false;
            long startstop = System.currentTimeMillis();
            while (!passstop && System.currentTimeMillis() - startstop < 300000L) {
                DeploymentStatus state = tstop.getState();
                if (state != null && state.isCompleted()) {
                    passstop = true;
                } else if (state != null && state.isFailed()) {
                    TestDeploymentJOnAS.fail((String)("Stop Failed " + state.getMessage()));
                }
                Thread.sleep(5000L);
            }
            if (!pass) {
                TestDeploymentJOnAS.fail((String)"Stop took too long");
            }
            System.out.println(">>> archiveEJB2 stopped");
        }
    }

    public static class TestListener
    implements ProgressListener {
        DeploymentStatus status = null;

        public void handleProgressEvent(ProgressEvent event) {
            System.out.println("Event fired " + event.getDeploymentStatus().getMessage());
            this.status = event.getDeploymentStatus();
        }

        public DeploymentStatus getState() {
            return this.status;
        }
    }
}

