/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.ishmael.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import junit.framework.TestCase;
import org.ow2.ishmael.deploy.spi.BasicConnectedDeploymentManager;

public class TestDeploymentEasyBeans
extends TestCase {
    BasicConnectedDeploymentManager man = null;
    File archiveEJB3 = new File("ressources/test/ejb/ejb3.jar");
    private static int timeToSleep = 1000;
    private static int timeMaxtoWait = timeToSleep * 10;

    public TestDeploymentEasyBeans(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.man = new BasicConnectedDeploymentManager("deployer:ishmael:service:jmx:rmi:///jndi/rmi://localhost:1099/EasyBeansConnector", "", "");
    }

    public void tearDown() {
        this.man = null;
    }

    public void testdeployEJB3Files() throws Exception {
        TargetModuleID[] oneTargetEJB3 = new TargetModuleID[1];
        oneTargetEJB3 = this.deployEJB3Files();
        TestDeploymentEasyBeans.assertNotNull((Object)oneTargetEJB3[0].getModuleID());
    }

    private TargetModuleID[] deployEJB3Files() throws Exception {
        if (this.archiveEJB3.exists()) {
            ProgressObject po = this.man.distribute(this.man.getTargets(), this.archiveEJB3, null);
            TestListener t = new TestListener();
            po.addProgressListener((ProgressListener)t);
            boolean pass = false;
            long start = System.currentTimeMillis();
            while (!pass && System.currentTimeMillis() - start < (long)timeMaxtoWait) {
                DeploymentStatus state = t.getState();
                if (state != null && state.isCompleted()) {
                    pass = true;
                } else if (state != null && state.isFailed()) {
                    TestDeploymentEasyBeans.fail((String)("Deployment Failed " + state.getMessage()));
                }
                Thread.currentThread();
                Thread.sleep(timeToSleep);
            }
            if (!pass) {
                TestDeploymentEasyBeans.fail((String)"Deployment took too long");
                return null;
            }
            return po.getResultTargetModuleIDs();
        }
        TestDeploymentEasyBeans.fail((String)("EJB application doesn't exist : " + this.archiveEJB3.getAbsolutePath()));
        return null;
    }

    public void testDeployEJBStreams() throws Exception {
        FileInputStream fst = new FileInputStream(this.archiveEJB3);
        ProgressObject po = this.man.distribute(this.man.getTargets(), (InputStream)fst, null);
        TestListener t = new TestListener();
        po.addProgressListener((ProgressListener)t);
        boolean pass = false;
        long start = System.currentTimeMillis();
        while (!pass && System.currentTimeMillis() - start < (long)timeMaxtoWait) {
            DeploymentStatus state = t.getState();
            if (state != null && state.isCompleted()) {
                pass = true;
            } else if (state != null && state.isFailed()) {
                TestDeploymentEasyBeans.fail((String)("Deployment Failed " + state.getMessage()));
            }
            Thread.currentThread();
            Thread.sleep(timeToSleep);
        }
        if (!pass) {
            TestDeploymentEasyBeans.fail((String)"Deployment took too long");
        }
    }

    public void testUndeployEJB() throws Exception {
        TargetModuleID[] ids = this.deployEJB3Files();
        ProgressObject po = this.man.undeploy(ids);
        TestListener t = new TestListener();
        po.addProgressListener((ProgressListener)t);
        boolean pass = false;
        long start = System.currentTimeMillis();
        while (!pass && System.currentTimeMillis() - start < 300000L) {
            DeploymentStatus state = t.getState();
            if (state != null && state.isCompleted()) {
                pass = true;
            } else if (state != null && state.isFailed()) {
                TestDeploymentEasyBeans.fail((String)("Start Failed " + state.getMessage()));
            }
            Thread.currentThread();
            Thread.sleep(timeToSleep);
        }
        if (!pass) {
            TestDeploymentEasyBeans.fail((String)"Undeploy took too long");
        }
    }

    public void testEJBModules() throws Exception {
        try {
            TargetModuleID[] ids = this.man.getAvailableModules(ModuleType.EJB, null);
            for (int i = 0; i < ids.length; ++i) {
                System.out.println("Path : " + ids[i].getModuleID());
            }
        }
        catch (Exception e) {
            TestDeploymentEasyBeans.fail((String)("getAvailableModules" + e.toString()));
        }
    }

    public void testRunningEJBModules() throws Exception {
        TargetModuleID[] idsAfter = this.man.getRunningModules(ModuleType.EJB, null);
        TargetModuleID[] ids = this.deployEJB3Files();
        if (ids == null) {
            TestDeploymentEasyBeans.fail((String)"Start Failed because testDeployEJB3Files return null");
        } else {
            TargetModuleID[] idsBefore;
            ProgressObject po = this.man.start(ids);
            TestListener t = new TestListener();
            po.addProgressListener((ProgressListener)t);
            boolean pass = false;
            long start = System.currentTimeMillis();
            while (!pass && System.currentTimeMillis() - start < (long)timeMaxtoWait) {
                DeploymentStatus state = t.getState();
                if (state != null && state.isCompleted()) {
                    pass = true;
                } else if (state != null && state.isFailed()) {
                    TestDeploymentEasyBeans.fail((String)("Start Failed " + state.getMessage()));
                }
                Thread.currentThread();
                Thread.sleep(timeToSleep);
            }
            if (!pass) {
                TestDeploymentEasyBeans.fail((String)"Start took too long");
            }
            if (idsAfter.length + 1 != (idsBefore = this.man.getRunningModules(ModuleType.EJB, null)).length) {
                TestDeploymentEasyBeans.fail((String)"The number of EJB deploy is incorrect");
            }
            ProgressObject postop = this.man.stop(ids);
            TestListener tstop = new TestListener();
            postop.addProgressListener((ProgressListener)tstop);
            boolean passstop = false;
            long startstop = System.currentTimeMillis();
            while (!passstop && System.currentTimeMillis() - startstop < (long)timeMaxtoWait) {
                DeploymentStatus state = tstop.getState();
                if (state != null && state.isCompleted()) {
                    passstop = true;
                } else if (state != null && state.isFailed()) {
                    TestDeploymentEasyBeans.fail((String)("Stop Failed " + state.getMessage()));
                }
                Thread.currentThread();
                Thread.sleep(timeToSleep);
            }
            if (!passstop) {
                TestDeploymentEasyBeans.fail((String)"Stop took too long");
            }
        }
    }

    public class TestListener
    implements ProgressListener {
        DeploymentStatus status = null;

        public void handleProgressEvent(ProgressEvent event) {
            System.out.println("Event fired " + event.getDeploymentStatus().getMessage());
            this.status = event.getDeploymentStatus();
        }

        public DeploymentStatus getState() {
            return this.status;
        }
    }
}

