/*
 * Ishmael : An open source implementation of JSR-88
 * Contact: ishmael-dev@lists.debian-sf.objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */
package org.ow2.ishmael.test;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;

import junit.framework.TestCase;

import org.ow2.ishmael.deploy.spi.BasicConnectedDeploymentManager;


public class TestDeploymentJOnAS extends TestCase {

    BasicConnectedDeploymentManager man = null;

    File archiveEAREE5 = new File("ressources/test/ear/javaee5-earsample.ear");
    File archiveEJB3 = new File("ressources/test/ejb/ejb3.jar");

    File archiveEAR = new File("ressources/test/ear/earsample.ear");
    File planEar = new File("ressources/test/ear/depplanEarSample.jar");

    File archiveEJB2 = new File("ressources/test/ejb/eb.jar");
    File planEjb2 = new File("ressources/test/ejb/depplanEb.jar");

    private static int timeToSleep = 1000 ; // en millisecondes temps d'attente entre chaque verification du status du deploiement
    private static int timeMaxtoWait = timeToSleep * 10 ; // temps max au bout duquel on arrete le test en echec

    public TestDeploymentJOnAS(String name) {
        super(name);
        //Log.configure("trace.properties", false);

    }

    public void setUp() throws Exception {
        //System.setSecurityManager(new RMISecurityManager());
        man = new BasicConnectedDeploymentManager("deployer:ishmael:service:jmx:rmi://localhost/jndi/rmi://localhost:1099/jrmpconnector_jonas","","");
    }

    public void tearDown() {
        man = null;
    }

    public void testDeployEJB3Files()throws Exception {
        TargetModuleID[] oneTargetEJB3 = new TargetModuleID[1];
        oneTargetEJB3 = deployEJBFiles(archiveEJB3, null);
        assertNotNull(oneTargetEJB3[0].getModuleID());
    }

    public void testDeployEJB2Files()throws Exception {
        TargetModuleID[] oneTargetEJB2 = new TargetModuleID[1];
        oneTargetEJB2 = deployEJBFiles(archiveEJB2, planEjb2);
        assertNotNull(oneTargetEJB2[0].getModuleID());
    }

    private TargetModuleID[] deployEJBFiles(File fileToDeploy, File depPlan) throws Exception {
        // pas de deployementPlan avec un EJB3
        if (fileToDeploy.exists()) {
            ProgressObject po = man.distribute(man.getTargets(), fileToDeploy, depPlan);
            TestListener t = new TestListener();
            po.addProgressListener(t);
            boolean pass = false;
            long start = System.currentTimeMillis();
            while(!pass && ((System.currentTimeMillis() - start) < timeMaxtoWait)) {
                DeploymentStatus state = t.getState();
                if (state!= null && state.isCompleted()) {
                    pass = true;
                } else if (state!= null && state.isFailed()) {
                    fail("Deployment Failed " + state.getMessage());
                }
                Thread.sleep(timeToSleep);
            }

            if (!pass) {
                fail("Deployment took too long");
                return null;
            } else
                return po.getResultTargetModuleIDs();
        } else {
            fail("EJB application doesn't exist : " + archiveEJB3.getAbsolutePath());
            return null;
        }
    }

    public void testDeployEJB3Streams() throws Exception {
        // pas de deployementPlan avec un EJB3
        InputStream fst = new FileInputStream(archiveEJB3);
        ProgressObject po = man.distribute(man.getTargets(), fst, null);
        TestListener t = new TestListener();
        po.addProgressListener(t);
        boolean pass = false;
        long start = System.currentTimeMillis();
        while(!pass && ((System.currentTimeMillis() - start) < timeMaxtoWait)) {
            DeploymentStatus state = t.getState();
            if (state!= null && state.isCompleted()) {
                pass = true;
            } else if (state!= null && state.isFailed()) {
                fail("Deployment Failed " + state.getMessage());
            }
            Thread.sleep(timeToSleep);
        }

        if (!pass) {
            fail("Deployment took too long");
        }

    }

    public void testDeployEAREE5Streams() throws Exception {
        // pas de deployementPlan avec une archive j2ee5
        InputStream fst = new FileInputStream(archiveEAREE5);
        ProgressObject po = man.distribute(man.getTargets(), fst, null);
        TestListener t = new TestListener();
        po.addProgressListener(t);
        boolean pass = false;
        long start = System.currentTimeMillis();
        while(!pass && ((System.currentTimeMillis() - start) < timeMaxtoWait)) {
            DeploymentStatus state = t.getState();
            if (state!= null && state.isCompleted()) {
                pass = true;
            } else if (state!= null && state.isFailed()) {
                fail("Deployment Failed " + state.getMessage());
            }
            Thread.sleep(timeToSleep);
        }
        if (!pass) {
            fail("Deployment took too long");
        }

    }

    private TargetModuleID[] deployEARFiles(File fileToDeploy, File depPlan) throws Exception {
        // pas de deployementPlan avec une archive j2ee5
        ProgressObject po = man.distribute(man.getTargets(), fileToDeploy, depPlan);
        TestListener t = new TestListener();
        po.addProgressListener(t);
        boolean pass = false;
        long start = System.currentTimeMillis();
        while(!pass && ((System.currentTimeMillis() - start) < timeMaxtoWait)) {
            DeploymentStatus state = t.getState();
            if (state!= null && state.isCompleted()) {
                pass = true;
            } else if (state!= null && state.isFailed()) {
                fail("Deployment Failed " + state.getMessage());
            }
            Thread.sleep(timeToSleep);
        }

        if (!pass) {
            fail("Deployment took too long");
            return null;
        }else
            return po.getResultTargetModuleIDs(); // used for another test
        // don't clean up the test for another test
    }

    public void testDeployEAREE5Files() throws Exception {
        TargetModuleID[] oneTargetEAREE5 = new TargetModuleID[1];
        oneTargetEAREE5 = deployEARFiles(archiveEAREE5, null);
        assertNotNull(oneTargetEAREE5[0].getModuleID());
    }

    public void testDeployEARFiles() throws Exception {
        TargetModuleID[] oneTargetEAR = new TargetModuleID[1];
        oneTargetEAR = deployEARFiles(archiveEAR, planEar);
        assertNotNull(oneTargetEAR[0].getModuleID());
    }

    public void testUndeployEjb3() throws Exception {
        TargetModuleID ids[];
        ids = this.deployEJBFiles(archiveEJB3, null);
        ProgressObject po = man.undeploy(ids);
        TestListener t = new TestListener();
        po.addProgressListener(t);
        boolean pass = false;

        long start = System.currentTimeMillis();
        while(!pass && ((System.currentTimeMillis() - start) < timeMaxtoWait)) {
            DeploymentStatus state = t.getState();
            if (state!= null && state.isCompleted()) {
                pass = true;
            } else if (state!= null && state.isFailed()) {
                fail("Start Failed " + state.getMessage());
            }
            Thread.sleep(timeToSleep);
        }

        if (!pass) {
            fail("Undeploy took too long");
        }
    }

    public void testEJBModules() throws Exception {
        try {
            TargetModuleID[] ids = man.getAvailableModules(ModuleType.EJB, man.getTargets());
            for (int i = 0; i < ids.length; i++) {
                System.out.println("Path : " + ids[i].getModuleID());
            }
        } catch (Exception e) {
            fail("getAvailableModules"+e.toString());
        }
    }

    public void testEarModules() throws Exception {
        try {
            TargetModuleID[] ids = man.getAvailableModules(ModuleType.EAR, man.getTargets());
            for (int i = 0; i < ids.length; i++) {
                System.out.println("Path : " + ids[i].getModuleID());
            }
        } catch (Exception e) {
            fail("getAvailableModules"+e.toString());
        }
    }

    /*
     * Junit Test .
     * 4/09/07 : JCA
     * La partie clean up ne fonctionne pas (undeploiement non implemente du cote serveur) : test qui passe uniquement lors du premier appel.
     * Sur le serveur l'erreur ClientGenStub est levee mais n'empeche pas le deployement (ClientGenStub qui ne sait pas traiter des EJB3).
     * 2007-09-04 11:32:10,231 : J2EEServerMBean.dumpFile : Cannot launch ClientGenStub on the file /tmp/JOnAS-Deployer/ejb3.jar : Parse error in jonas-ejb-jar Descriptor.
     * java.lang.Exception: Exception when executing ClientstubGen.execute(String[])
     *
     */
    public void testRunningEJB3Modules() throws Exception {
        TargetModuleID[] idsAfter = man.getRunningModules(ModuleType.EJB, man.getTargets());

        TargetModuleID ids[];
        ids = deployEJBFiles(archiveEJB3, null);
        if (ids == null) // testDeployEARFiles failed
            fail("Start Failed because testDeployEARFiles return null");
        else {
            ProgressObject po = man.start(ids);
            TestListener t = new TestListener();
            po.addProgressListener(t);
            boolean pass = false;

            long start = System.currentTimeMillis();
            while(!pass && ((System.currentTimeMillis() - start) < timeMaxtoWait)) {
                DeploymentStatus state = t.getState();
                if (state!= null && state.isCompleted()) {
                    pass = true;
                } else if (state!= null && state.isFailed()) {
                    fail("Start Failed " + state.getMessage());
                }
                Thread.sleep(timeToSleep);
            }

            if (!pass) {
                fail("Start took too long");
            }

            TargetModuleID[] idsBefore = man.getRunningModules(ModuleType.EJB,  man.getTargets());

            if ((idsAfter.length + 1) != idsBefore.length)
                fail("The number of EJB deploy is incorrect");


            //clean up
            ProgressObject postop = man.undeploy(ids);
            TestListener tstop = new TestListener();
            postop.addProgressListener(tstop);
            boolean passstop = false;

            long startstop = System.currentTimeMillis();
            while(!passstop && ((System.currentTimeMillis() - startstop) < timeMaxtoWait)) {
                DeploymentStatus state = tstop.getState();
                if (state!= null && state.isCompleted()) {
                    passstop = true;
                } else if (state!= null && state.isFailed()) {
                    fail("Stop Failed " + state.getMessage());
                }
                Thread.sleep(timeToSleep);
            }
            if (!passstop) {
                fail("Stop took too long");
            }
        }
    }


    /*
     * Junit Test .
     * 4/09/07 : JCA
     * La partie clean up ne fonctionne pas (undeploiement non implemente du cote serveur) : test qui passe uniquement lors du premier appel.
     * Sur le serveur l'erreur ClientGenStub est levee mais n'empeche pas le deployement (ClientGenStub qui ne sait pas traiter des EJB3).
     * 2007-09-04 11:32:10,231 : J2EEServerMBean.dumpFile : Cannot launch ClientGenStub on the file /tmp/JOnAS-Deployer/ejb3.jar : Parse error in jonas-ejb-jar Descriptor.
     * java.lang.Exception: Exception when executing ClientstubGen.execute(String[])
     *
     */
    public void testRunningEAREE5Modules() throws Exception {
        TargetModuleID[] idsAfter = man.getRunningModules(ModuleType.EAR, man.getTargets());

        TargetModuleID ids[];
        ids = deployEJBFiles(archiveEAREE5, null);
        if (ids == null) // testDeployEARFiles failed
            fail("Start Failed because testDeployEARFiles return null");
        else {
            ProgressObject po = man.start(ids);
            TestListener t = new TestListener();
            po.addProgressListener(t);
            boolean pass = false;

            long start = System.currentTimeMillis();
            while(!pass && ((System.currentTimeMillis() - start) < timeMaxtoWait)) {
                DeploymentStatus state = t.getState();
                if (state!= null && state.isCompleted()) {
                    pass = true;
                } else if (state!= null && state.isFailed()) {
                    fail("Start Failed " + state.getMessage());
                }
                Thread.sleep(timeToSleep);
            }

            if (!pass) {
                fail("Start took too long");
            }

            TargetModuleID[] idsBefore = man.getRunningModules(ModuleType.EAR, man.getTargets());

            if ((idsAfter.length + 1) != idsBefore.length)
                fail("The number of EAR deploy is incorrect");


            //clean up
            ProgressObject postop = man.undeploy(ids);
            TestListener tstop = new TestListener();
            postop.addProgressListener(tstop);
            boolean passstop = false;

            long startstop = System.currentTimeMillis();
            while(!passstop && ((System.currentTimeMillis() - startstop) < timeMaxtoWait)) {
                DeploymentStatus state = tstop.getState();
                if (state!= null && state.isCompleted()) {
                    passstop = true;
                } else if (state!= null && state.isFailed()) {
                    fail("Stop Failed " + state.getMessage());
                }
                Thread.sleep(timeToSleep);
            }
            if (!passstop) {
                fail("Stop took too long");
            }
        }
    }


    public void testStartStopEar() throws Exception {
        TargetModuleID ids[];
        ids = deployEARFiles(archiveEAR, planEar);
        if (ids == null) // testDeployEARFiles failed
            fail("Start Failed because testDeployEARFiles return null");
        else {
            ProgressObject po = man.start(ids);
            TestListener t = new TestListener();
            po.addProgressListener(t);
            boolean pass = false;

            long start = System.currentTimeMillis();
            while(!pass && ((System.currentTimeMillis() - start) < 300000)) {
                DeploymentStatus state = t.getState();
                if (state!= null && state.isCompleted()) {
                    pass = true;
                } else if (state!= null && state.isFailed()) {
                    fail("Start Failed " + state.getMessage());
                }
                Thread.sleep(5000);
            }

            if (!pass) {
                fail("Start took too long");
            }
            //clean up
            ProgressObject postop = man.stop(ids);
            TestListener tstop = new TestListener();
            postop.addProgressListener(tstop);
            boolean passstop = false;

            long startstop = System.currentTimeMillis();
            while(!passstop && ((System.currentTimeMillis() - startstop) < 300000)) {
                DeploymentStatus state = tstop.getState();
                if (state!= null && state.isCompleted()) {
                    passstop = true;
                } else if (state!= null && state.isFailed()) {
                    fail("Stop Failed " + state.getMessage());
                }
                Thread.sleep(5000);
            }
            if (!passstop) {
                fail("Stop took too long");
            }
        }
    }

    public void testStartStopEjb2() throws Exception {
        TargetModuleID ids[];
        ids = deployEJBFiles(archiveEJB2, planEjb2);
        if (ids == null) // testDeployEARFiles failed
            fail("Start Failed because testDeployEJBFiles return null");
        else {
            System.out.println(">>> archiveEJB2 distributed");
            ProgressObject po = man.start(ids);
            TestListener t = new TestListener();
            po.addProgressListener(t);
            boolean pass = false;

            long start = System.currentTimeMillis();
            while(!pass && ((System.currentTimeMillis() - start) < 300000)) {
                DeploymentStatus state = t.getState();
                if (state!= null && state.isCompleted()) {
                    pass = true;
                } else if (state!= null && state.isFailed()) {
                    fail("Start Failed " + state.getMessage());
                }
                Thread.sleep(5000);
            }

            if (!pass) {
                fail("Start took too long");
            }
            System.out.println(">>> archiveEJB2 started");
            //clean up
            ProgressObject postop = man.stop(ids);
            TestListener tstop = new TestListener();
            postop.addProgressListener(tstop);
            boolean passstop = false;

            long startstop = System.currentTimeMillis();
            while(!passstop && ((System.currentTimeMillis() - startstop) < 300000)) {
                DeploymentStatus state = tstop.getState();
                if (state!= null && state.isCompleted()) {
                    passstop = true;
                } else if (state!= null && state.isFailed()) {
                    fail("Stop Failed " + state.getMessage());
                }
                Thread.sleep(5000);
            }
            if (!pass) {
                fail("Stop took too long");
            }
            System.out.println(">>> archiveEJB2 stopped");
        }
    }


    static public class TestListener implements ProgressListener {
        DeploymentStatus status = null;
        public void handleProgressEvent(ProgressEvent event) {
            System.out.println("Event fired " + event.getDeploymentStatus().getMessage());
            status = event.getDeploymentStatus();
        }
        public  DeploymentStatus getState() {
            return status;
        }
    }
}