/*
 * Ishmael : An open source implementation of JSR-88
 * Contact: ishmael-dev@lists.debian-sf.objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */
package org.ow2.ishmael.test;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;

import junit.framework.TestCase;

import org.ow2.ishmael.deploy.spi.BasicConnectedDeploymentManager;


public class TestDeploymentEasyBeans extends TestCase {

    BasicConnectedDeploymentManager man = null;

    File archiveEJB3 = new File("ressources/test/ejb/ejb3.jar");

    private static int timeToSleep = 5000 ; // en millisecondes temps d'attente entre chaque verification du status du deploiement
    private static int timeMaxtoWait = timeToSleep * 10 ; // temps max au bout duquel on arrete le test en echec

    public TestDeploymentEasyBeans(String name) {
        super(name);
        //Log.configure("trace.properties", false);
    }

    public void setUp() throws Exception {
        //System.setSecurityManager(new RMISecurityManager());
        man = new BasicConnectedDeploymentManager("deployer:ishmael:service:jmx:rmi:///jndi/rmi://localhost:1099/EasyBeansConnector","","");
        //man = new BasicConnectedDeploymentManager("deployer:ishmael:service:jmx:rmi://localhost/jndi/rmi://localhost:1099/jrmpconnector_jonas","","");
    }

    public void tearDown() {
        man = null;
    }

    public void testdeployEJB3Files()throws Exception {
        TargetModuleID[] oneTargetEJB3 = new TargetModuleID[1];
        oneTargetEJB3 = deployEJB3Files();
        assertNotNull(oneTargetEJB3[0].getModuleID());
    }

    private TargetModuleID[] deployEJB3Files() throws Exception {
        if (archiveEJB3.exists()) {
            ProgressObject po = man.distribute(man.getTargets(), archiveEJB3, null);
            TestListener t = new TestListener();
            po.addProgressListener(t);
            boolean pass = false;
            long start = System.currentTimeMillis();
            while(!pass && ((System.currentTimeMillis() - start) < timeMaxtoWait)) {
                DeploymentStatus state = t.getState();
                if (state!= null && state.isCompleted()) {
                    pass = true;
                } else if (state!= null && state.isFailed()) {
                    fail("Deployment Failed " + state.getMessage());
                }
                Thread.currentThread().sleep(timeToSleep);
            }

            if (!pass) {
                fail("Deployment took too long");
                return null;
            } else
                return po.getResultTargetModuleIDs();
        } else {
            fail("EJB application doesn't exist : " + archiveEJB3.getAbsolutePath());
            return null;
        }
    }

    public void testDeployEJBStreams() throws Exception {
        InputStream fst = new FileInputStream(archiveEJB3);
        ProgressObject po = man.distribute(man.getTargets(), fst, null);
        TestListener t = new TestListener();
        po.addProgressListener(t);
        boolean pass = false;
        long start = System.currentTimeMillis();
        while(!pass && ((System.currentTimeMillis() - start) < timeMaxtoWait)) {
            DeploymentStatus state = t.getState();
            if (state!= null && state.isCompleted()) {
                pass = true;
            } else if (state!= null && state.isFailed()) {
                fail("Deployment Failed " + state.getMessage());
            }
            Thread.currentThread().sleep(timeToSleep);
        }

        if (!pass) {
            fail("Deployment took too long");
        }

    }

    public void testUndeployEJB() throws Exception {
        TargetModuleID ids[];
        ids = this.deployEJB3Files();
        ProgressObject po = man.undeploy(ids);
        TestListener t = new TestListener();
        po.addProgressListener(t);
        boolean pass = false;

        long start = System.currentTimeMillis();
        while(!pass && ((System.currentTimeMillis() - start) < 300000)) {
            DeploymentStatus state = t.getState();
            if (state!= null && state.isCompleted()) {
                pass = true;
            } else if (state!= null && state.isFailed()) {
                fail("Start Failed " + state.getMessage());
            }
            Thread.currentThread().sleep(timeToSleep);
        }

        if (!pass) {
            fail("Undeploy took too long");
        }
    }


    public void testEJBModules() throws Exception {
        try {
            TargetModuleID[] ids = man.getAvailableModules(ModuleType.EJB, null);
            for (int i = 0; i < ids.length; i++) {
                System.out.println("Path : " + ids[i].getModuleID());
            }
        } catch (Exception e) {
            fail("getAvailableModules"+e.toString());
        }
    }

    public void testRunningEJBModules() throws Exception {
        TargetModuleID[] idsAfter = man.getRunningModules(ModuleType.EJB, null);

        TargetModuleID ids[];
        ids = deployEJB3Files();
        if (ids == null) // testDeployEJB3Files failed
            fail("Start Failed because testDeployEJB3Files return null");
        else {
            ProgressObject po = man.start(ids);
            TestListener t = new TestListener();
            po.addProgressListener(t);
            boolean pass = false;

            long start = System.currentTimeMillis();
            while(!pass && ((System.currentTimeMillis() - start) < timeMaxtoWait)) {
                DeploymentStatus state = t.getState();
                if (state!= null && state.isCompleted()) {
                    pass = true;
                } else if (state!= null && state.isFailed()) {
                    fail("Start Failed " + state.getMessage());
                }
                Thread.currentThread().sleep(timeToSleep);
            }

            if (!pass) {
                fail("Start took too long");
            }

            TargetModuleID[] idsBefore = man.getRunningModules(ModuleType.EJB, null);

            if ((idsAfter.length + 1) != idsBefore.length)
                fail("The number of EJB deploy is incorrect");


            //clean up
            ProgressObject postop = man.stop(ids);
            TestListener tstop = new TestListener();
            postop.addProgressListener(tstop);
            boolean passstop = false;

            long startstop = System.currentTimeMillis();
            while(!passstop && ((System.currentTimeMillis() - startstop) < timeMaxtoWait)) {
                DeploymentStatus state = tstop.getState();
                if (state!= null && state.isCompleted()) {
                    passstop = true;
                } else if (state!= null && state.isFailed()) {
                    fail("Stop Failed " + state.getMessage());
                }
                Thread.currentThread().sleep(timeToSleep);
            }
            if (!passstop) {
                fail("Stop took too long");
            }
        }
    }

    public class TestListener implements ProgressListener {
        DeploymentStatus status = null;
        public void handleProgressEvent(ProgressEvent event) {
            System.out.println("Event fired " + event.getDeploymentStatus().getMessage());
            status = event.getDeploymentStatus();
        }
        public  DeploymentStatus getState() {
            return status;
        }
    }
}