/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.agent.remote.discovery.application.postgresql;

import java.util.ArrayList;
import java.util.List;
import org.ow2.jasmine.agent.common.discovery.ApplicationProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgreSQLApplicationPropertiesMap {
    public static final String LISTEN_KEY = "Listening addresses";
    public static final String PORT_KEY = "Listening port";
    public static final String MAX_KEY = "Maximum Connections";
    private int port;
    private String listeningAddresses;
    private int maxConnections;

    public PostgreSQLApplicationPropertiesMap() {
    }

    public PostgreSQLApplicationPropertiesMap(List<ApplicationProperty> list) {
        this.setListeningAddresses(this.getPropFromList(LISTEN_KEY, list));
        this.setMaxConnections(this.setValue(this.getPropFromList(MAX_KEY, list)));
        this.setPort(this.setValue(this.getPropFromList(PORT_KEY, list)));
    }

    public int setValue(String val) {
        if (val == null) {
            return 0;
        }
        return Integer.parseInt(val);
    }

    private String getPropFromList(String key, List<ApplicationProperty> props) {
        for (ApplicationProperty prop : props) {
            if (!prop.getPropertyName().equals(key)) continue;
            return prop.getPropertyValue();
        }
        return null;
    }

    public List<ApplicationProperty> getPropertiesList() {
        ArrayList<ApplicationProperty> list = new ArrayList<ApplicationProperty>();
        list.add(new ApplicationProperty(LISTEN_KEY, this.listeningAddresses));
        list.add(new ApplicationProperty(PORT_KEY, this.getValue(this.port)));
        list.add(new ApplicationProperty(MAX_KEY, this.getValue(this.maxConnections)));
        return list;
    }

    public String getValue(int val) {
        if (String.valueOf(val).equals("0")) {
            return null;
        }
        return String.valueOf(val);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getListeningAddresses() {
        return this.listeningAddresses;
    }

    public void setListeningAddresses(String listeningAddresses) {
        this.listeningAddresses = listeningAddresses;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }
}

