/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.agent.remote.discovery.application.postgresql;

import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.ow2.jasmine.agent.common.discovery.Application;
import org.ow2.jasmine.agent.common.discovery.ApplicationDiscoveryService;
import org.ow2.jasmine.agent.common.discovery.ApplicationState;
import org.ow2.jasmine.agent.common.utils.AgentFileFilter;
import org.ow2.jasmine.agent.common.utils.Utilities;
import org.ow2.jasmine.agent.remote.RemoteService;
import org.ow2.jasmine.agent.remote.discovery.application.postgresql.PostgreSQLApplicationPropertiesMap;
import org.ow2.jasmine.agent.utils.filesystem.discovery.FileSystemDiscovery;
import org.ow2.jasmine.agent.utils.pattern.DiscoveryPattern;
import org.ow2.jasmine.agent.utils.pattern.PatternUtility;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(name="JASMINe Agent PostgreSQL Discovery", propagation=true)
@Provides
public class PostgreSQLDiscovery
extends RemoteService
implements ApplicationDiscoveryService,
Pojo {
    private InstanceManager __IM;
    public static final String POSTGRE_PATTERN_FILE = "/postgresql.xml";
    public static final String POSTGRE_PATTERN_FILE_2 = "/postgresqlv2.xml";
    public static final String TYPE = "PostgreSQL";
    public static final String POSTGRE_CONF_PORT_KEY = "port";
    public static final String POSTGRE_CONF_LISTEN_ADDRESSES_KEY = "listen_addresses";
    public static final String POSTGRE_CONF_MAX_CONNECTIONS_KEY = "max_connections";
    private static Log logger = LogFactory.getLog(PostgreSQLDiscovery.class);
    private boolean __FfsService;
    @Requires
    private FileSystemDiscovery fsService;
    private boolean __MdiscoverApplications;
    private boolean __MdiscoverApplications_dynamic$java_util_List;
    private boolean __MdiscoverApplications_static;
    private boolean __MgetType;

    FileSystemDiscovery __getfsService() {
        if (!this.__FfsService) {
            return this.fsService;
        }
        return (FileSystemDiscovery)this.__IM.onGet((Object)this, "fsService");
    }

    void __setfsService(FileSystemDiscovery fileSystemDiscovery) {
        if (!this.__FfsService) {
            this.fsService = fileSystemDiscovery;
            return;
        }
        this.__IM.onSet((Object)this, "fsService", (Object)fileSystemDiscovery);
    }

    public PostgreSQLDiscovery() {
        this(null);
    }

    private PostgreSQLDiscovery(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public synchronized List<Application> discoverApplications() {
        List<Application> list;
        if (!this.__MdiscoverApplications) {
            return this.__discoverApplications();
        }
        try {
            this.__IM.onEntry((Object)this, "discoverApplications", new Object[0]);
            list = this.__discoverApplications();
            this.__IM.onExit((Object)this, "discoverApplications", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "discoverApplications", throwable);
            throw throwable;
        }
        return list;
    }

    private List<Application> __discoverApplications() {
        return this.discoverApplications_dynamic(this.discoverApplications_static());
    }

    private List<Application> discoverApplications_dynamic(List<Application> list) {
        List<Application> list2;
        if (!this.__MdiscoverApplications_dynamic$java_util_List) {
            return this.__discoverApplications_dynamic(list);
        }
        try {
            this.__IM.onEntry((Object)this, "discoverApplications_dynamic$java_util_List", new Object[]{list});
            list2 = this.__discoverApplications_dynamic(list);
            this.__IM.onExit((Object)this, "discoverApplications_dynamic$java_util_List", list2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "discoverApplications_dynamic$java_util_List", throwable);
            throw throwable;
        }
        return list2;
    }

    private List<Application> __discoverApplications_dynamic(List<Application> discoveredApplicationsStatic) {
        for (Application application : discoveredApplicationsStatic) {
            PostgreSQLApplicationPropertiesMap map = new PostgreSQLApplicationPropertiesMap(application.getApplicationProperties());
            int port = map.getPort();
            boolean isListening = false;
            try {
                isListening = Utilities.scan((int)port, (InetAddress)InetAddress.getLocalHost());
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            if (!isListening) continue;
            application.setState(ApplicationState.MAYBE_RUNNING);
        }
        return discoveredApplicationsStatic;
    }

    private List<Application> discoverApplications_static() {
        List<Application> list;
        if (!this.__MdiscoverApplications_static) {
            return this.__discoverApplications_static();
        }
        try {
            this.__IM.onEntry((Object)this, "discoverApplications_static", new Object[0]);
            list = this.__discoverApplications_static();
            this.__IM.onExit((Object)this, "discoverApplications_static", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "discoverApplications_static", throwable);
            throw throwable;
        }
        return list;
    }

    private List<Application> __discoverApplications_static() {
        ArrayList<Application> applicationList = new ArrayList<Application>();
        DiscoveryPattern postgrePattern = PatternUtility.convertFileToPattern((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(POSTGRE_PATTERN_FILE));
        DiscoveryPattern postgrePattern2 = PatternUtility.convertFileToPattern((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(POSTGRE_PATTERN_FILE_2));
        logger.info((Object)"Starting discovering Postgresql", new Object[0]);
        List fileList = this.__getfsService().searchPattern(postgrePattern);
        fileList.addAll(this.__getfsService().searchPattern(postgrePattern2));
        for (File file : fileList) {
            Application application = new Application();
            application.setApplicationType(TYPE);
            application.setRootLocation(file.getAbsolutePath());
            application.setState(ApplicationState.UNKNOWN);
            try {
                File confdir;
                try {
                    confdir = file.listFiles((FileFilter)new AgentFileFilter("data"))[0];
                }
                catch (Exception e) {
                    confdir = file.listFiles((FileFilter)new AgentFileFilter("main"))[0];
                }
                PostgreSQLApplicationPropertiesMap map = new PostgreSQLApplicationPropertiesMap();
                if (!confdir.canRead()) {
                    logger.warn((Object)"Unable to get PostgreSQL configuration at {0}, you do not have enough rights", new Object[]{file.getAbsolutePath()});
                } else {
                    String token;
                    StringTokenizer tokenizer;
                    File conf = confdir.listFiles((FileFilter)new AgentFileFilter("postgresql.conf"))[0];
                    String portLine = Utilities.getStringInFile((String)POSTGRE_CONF_PORT_KEY, (File)conf);
                    String listenLine = Utilities.getStringInFile((String)POSTGRE_CONF_LISTEN_ADDRESSES_KEY, (File)conf);
                    String maxLine = Utilities.getStringInFile((String)POSTGRE_CONF_MAX_CONNECTIONS_KEY, (File)conf);
                    int port = 0;
                    String listenAddresses = null;
                    int maxConnections = 0;
                    boolean keepon = true;
                    if (portLine != null) {
                        tokenizer = new StringTokenizer(portLine, " ");
                        while (keepon && tokenizer.hasMoreTokens()) {
                            token = tokenizer.nextToken();
                            if (!token.equals(POSTGRE_CONF_PORT_KEY)) {
                                keepon = false;
                                continue;
                            }
                            token = tokenizer.nextToken();
                            if (token.equals("=")) {
                                port = Integer.parseInt(new StringTokenizer(tokenizer.nextToken(), "\t").nextToken());
                            }
                            keepon = false;
                        }
                    }
                    if (listenLine != null) {
                        tokenizer = new StringTokenizer(listenLine, " ");
                        keepon = true;
                        while (keepon && tokenizer.hasMoreTokens()) {
                            token = tokenizer.nextToken();
                            if (!token.equals(POSTGRE_CONF_LISTEN_ADDRESSES_KEY)) {
                                keepon = false;
                                continue;
                            }
                            token = tokenizer.nextToken();
                            if (token.equals("=")) {
                                listenAddresses = new StringTokenizer(tokenizer.nextToken(), "\t").nextToken();
                            }
                            keepon = false;
                        }
                    }
                    if (maxLine != null) {
                        tokenizer = new StringTokenizer(maxLine, " ");
                        keepon = true;
                        while (keepon && tokenizer.hasMoreTokens()) {
                            token = tokenizer.nextToken();
                            if (!token.equals(POSTGRE_CONF_MAX_CONNECTIONS_KEY)) {
                                keepon = false;
                                continue;
                            }
                            token = tokenizer.nextToken();
                            if (token.equals("=")) {
                                maxConnections = Integer.parseInt(new StringTokenizer(tokenizer.nextToken(), "\t").nextToken());
                            }
                            keepon = false;
                        }
                    }
                    map.setListeningAddresses(listenAddresses);
                    map.setMaxConnections(maxConnections);
                    map.setPort(port);
                }
                application.setApplicationProperties(map.getPropertiesList());
            }
            catch (Exception e) {
                logger.warn((Object)"Unable to get PostgreSQL configuration at {0}, exception is : {1}", new Object[]{file.getAbsolutePath(), e.getMessage()});
                e.printStackTrace();
            }
            applicationList.add(application);
        }
        return applicationList;
    }

    public String getType() {
        String string;
        if (!this.__MgetType) {
            return this.__getType();
        }
        try {
            this.__IM.onEntry((Object)this, "getType", new Object[0]);
            string = this.__getType();
            this.__IM.onExit((Object)this, "getType", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getType", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getType() {
        return TYPE;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null && set.contains("fsService")) {
            this.__FfsService = true;
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("discoverApplications")) {
                this.__MdiscoverApplications = true;
            }
            if (set.contains("discoverApplications_dynamic$java_util_List")) {
                this.__MdiscoverApplications_dynamic$java_util_List = true;
            }
            if (set.contains("discoverApplications_static")) {
                this.__MdiscoverApplications_static = true;
            }
            if (set.contains("getType")) {
                this.__MgetType = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

