/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.agent.remote.discovery.application.jonas;

import java.util.ArrayList;
import java.util.List;
import org.ow2.jasmine.agent.common.discovery.ApplicationProperty;
import org.ow2.jasmine.agent.remote.discovery.application.jonas.JonasType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JonasApplicationPropertiesMap {
    public static final String JMX_CONNECTOR_KEY = "JMX Connector";
    public static final String JONAS_TYPE_KEY = "Installation Type";
    public static final String JONAS_VERSION_KEY = "Version";
    public static final String JONAS_BASE_KEY = "JOnAS Base";
    public static final String JONAS_ROOT_KEY = "JOnAS Root";
    private String jmxConnector;
    private JonasType jonasType;
    private String jonasVersion;
    private String confirmedJonasBase;
    private String confirmedJonasRoot;

    public JonasApplicationPropertiesMap() {
        this.jmxConnector = null;
    }

    public JonasApplicationPropertiesMap(List<ApplicationProperty> properties) {
        this.setJmxConnector(this.getPropFromList(JMX_CONNECTOR_KEY, properties));
        this.setJonasType(this.stringToJonasType(this.getPropFromList(JONAS_TYPE_KEY, properties)));
        this.setJonasVersion(this.getPropFromList(JONAS_VERSION_KEY, properties));
        this.setConfirmedJonasBase(this.getPropFromList(JONAS_BASE_KEY, properties));
        this.setConfirmedJonasRoot(this.getPropFromList(JONAS_ROOT_KEY, properties));
    }

    private String getPropFromList(String key, List<ApplicationProperty> props) {
        for (ApplicationProperty prop : props) {
            if (!prop.getPropertyName().equals(key)) continue;
            return prop.getPropertyValue();
        }
        return null;
    }

    private JonasType stringToJonasType(String string) {
        if (string.equalsIgnoreCase(JonasType.JONAS_BASE.toString())) {
            return JonasType.JONAS_BASE;
        }
        if (string.equalsIgnoreCase(JonasType.JONAS_ROOT.toString())) {
            return JonasType.JONAS_ROOT;
        }
        if (string.equalsIgnoreCase(JonasType.JONAS_ROOT_AND_BASE.toString())) {
            return JonasType.JONAS_ROOT_AND_BASE;
        }
        if (string.equalsIgnoreCase(JonasType.MICRO_JONAS.toString())) {
            return JonasType.MICRO_JONAS;
        }
        return null;
    }

    public JonasApplicationPropertiesMap(String jmxConnector) {
        this.jmxConnector = jmxConnector;
    }

    public List<ApplicationProperty> getPropertiesList() {
        ArrayList<ApplicationProperty> list = new ArrayList<ApplicationProperty>();
        list.add(new ApplicationProperty(JMX_CONNECTOR_KEY, this.jmxConnector));
        list.add(new ApplicationProperty(JONAS_TYPE_KEY, this.jonasType.toString()));
        list.add(new ApplicationProperty(JONAS_VERSION_KEY, this.jonasVersion));
        list.add(new ApplicationProperty(JONAS_BASE_KEY, this.confirmedJonasBase));
        list.add(new ApplicationProperty(JONAS_ROOT_KEY, this.confirmedJonasRoot));
        return list;
    }

    public String getJmxConnector() {
        return this.jmxConnector;
    }

    public void setJmxConnector(String jmxConnector) {
        this.jmxConnector = jmxConnector;
    }

    public JonasType getJonasType() {
        return this.jonasType;
    }

    public void setJonasType(JonasType jonasType) {
        this.jonasType = jonasType;
    }

    public String getJonasVersion() {
        return this.jonasVersion;
    }

    public void setJonasVersion(String jonasVersion) {
        this.jonasVersion = jonasVersion;
    }

    public String getConfirmedJonasBase() {
        return this.confirmedJonasBase;
    }

    public void setConfirmedJonasBase(String confirmedJonasBase) {
        this.confirmedJonasBase = confirmedJonasBase;
    }

    public String getConfirmedJonasRoot() {
        return this.confirmedJonasRoot;
    }

    public void setConfirmedJonasRoot(String confirmedJonasRoot) {
        this.confirmedJonasRoot = confirmedJonasRoot;
    }
}

