/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.agent.remote.discovery.application.jonas;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.jgroups.Address;
import org.jgroups.ChannelListener;
import org.jgroups.Receiver;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.stack.IpAddress;
import org.ow2.jasmine.agent.common.discovery.Application;
import org.ow2.jasmine.agent.common.discovery.ApplicationDiscoveryService;
import org.ow2.jasmine.agent.common.discovery.ApplicationState;
import org.ow2.jasmine.agent.common.utils.AgentFileFilter;
import org.ow2.jasmine.agent.common.utils.PropertyManager;
import org.ow2.jasmine.agent.common.utils.Utilities;
import org.ow2.jasmine.agent.remote.RemoteService;
import org.ow2.jasmine.agent.remote.discovery.application.jonas.JGroupsHandler;
import org.ow2.jasmine.agent.remote.discovery.application.jonas.JonasApplicationPropertiesMap;
import org.ow2.jasmine.agent.remote.discovery.application.jonas.JonasType;
import org.ow2.jasmine.agent.utils.filesystem.discovery.FileSystemDiscovery;
import org.ow2.jasmine.agent.utils.pattern.DiscoveryPattern;
import org.ow2.jasmine.agent.utils.pattern.PatternUtility;
import org.ow2.jonas.discovery.base.comm.DiscEvent;
import org.ow2.jonas.discovery.jgroups.utils.IDiscoveryChannel;
import org.ow2.jonas.discovery.jgroups.utils.JGroupsDiscoveryUtils;
import org.ow2.util.cluster.jgroups.ConnectionManager;
import org.ow2.util.cluster.jgroups.JChannelWrapper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(name="JASMINe Agent Jonas Discovery", propagation=true)
@Provides
public class JonasDiscovery
extends RemoteService
implements ApplicationDiscoveryService,
Pojo {
    private InstanceManager __IM;
    private static Log logger = LogFactory.getLog(JonasDiscovery.class);
    private static final String TYPE = "JOnAS";
    private static final String JONAS_BASE_PATTERN_FILE = "/jonasbase.xml";
    private static final String MICRO_JONAS_PATTERN_FILE = "/microjonas.xml";
    private static final String JONAS_ROOT_PATTERN_FILE = "/jonasroot.xml";
    private static final String ALREADY_STARTED_JONAS_PATTERN_FILE = "/alreadystartedjonas.xml";
    private static final String VERSION_PROPERTY_FILE_NAME = "versions.properties";
    private static final String JONAS_VERSION_PROPERTY_NAME = "org.ow2.jonas";
    private static final String CAROL_FILE_NAME = "carol.properties";
    private static final String CONF_DIRECTORY_NAME = "conf";
    private static final String CAROL_PROTOCOLS_KEY = "carol.protocols";
    private static final String JONAS_BASE_MBEAN_ATTRIBUTE_NAME = "jonasBase";
    private static final String JONAS_ROOT_MBEAN_ATTRIBUTE_NAME = "jonasRoot";
    private static final String JONAS_J2EE_SERVER_OBJECTNAME_PATTERN = "*:j2eeType=J2EEServer,*";
    private static final String JONAS_SERVICES_KEY = "jonas.services";
    private static final String DISCOVERY_SERVICE_NAME = "discovery";
    private static final String JGROUPS_CONFIGURATION_FILE_KEY = "jonas.service.discovery.jgroups.conf";
    private static final String JGROUPS_GROUP_NAME_KEY = "jonas.service.discovery.group.name";
    private static final String JGROUPS_TIMEOUT_KEY = "jonas.service.discovery.reconnection.timeout";
    private static final String JONAS_NAME_KEY = "jonas.name";
    private static final String JONAS_DOMAIN_KEY = "domain.name";
    private static final String JONAS_PROPS_FILE_NAME = "jonas.properties";
    private static final String LOCAL_SERVER_NAME = "jasmineagent";
    private static final int DEFAULT_WAITING_TIME_FOR_JGROUPS_EVENT = 2000;
    private boolean __FfsService;
    @Requires
    private FileSystemDiscovery fsService;
    private boolean __MdiscoverApplications;
    private boolean __MdiscoverApplications_dynamic$java_util_List;
    private boolean __MgetJonasBase$java_lang_String;
    private boolean __MgetJonasRoot$java_lang_String;
    private boolean __MgetAttributeFromMBeanServer$java_lang_String$java_lang_String$java_lang_String;
    private boolean __MtryConnectToUrl$java_lang_String;
    private boolean __MgetPossibleUrlFromCarol$java_io_File$java_io_File;
    private boolean __MgetPossibleUrlFromCarol$java_io_File$java_io_File$java_lang_String;
    private boolean __MgetPropertyFile$java_lang_String$java_lang_String;
    private boolean __MdiscoverApplications_static;
    private boolean __MgetStringInFile$java_lang_String$java_io_File;
    private boolean __MgetType;

    FileSystemDiscovery __getfsService() {
        if (!this.__FfsService) {
            return this.fsService;
        }
        return (FileSystemDiscovery)this.__IM.onGet((Object)this, "fsService");
    }

    void __setfsService(FileSystemDiscovery fileSystemDiscovery) {
        if (!this.__FfsService) {
            this.fsService = fileSystemDiscovery;
            return;
        }
        this.__IM.onSet((Object)this, "fsService", (Object)fileSystemDiscovery);
    }

    public JonasDiscovery() {
        this(null);
    }

    private JonasDiscovery(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public synchronized List<Application> discoverApplications() {
        List<Application> list;
        if (!this.__MdiscoverApplications) {
            return this.__discoverApplications();
        }
        try {
            this.__IM.onEntry((Object)this, "discoverApplications", new Object[0]);
            list = this.__discoverApplications();
            this.__IM.onExit((Object)this, "discoverApplications", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "discoverApplications", throwable);
            throw throwable;
        }
        return list;
    }

    private List<Application> __discoverApplications() {
        return this.discoverApplications_dynamic(this.discoverApplications_static());
    }

    private List<Application> discoverApplications_dynamic(List<Application> list) {
        List<Application> list2;
        if (!this.__MdiscoverApplications_dynamic$java_util_List) {
            return this.__discoverApplications_dynamic(list);
        }
        try {
            this.__IM.onEntry((Object)this, "discoverApplications_dynamic$java_util_List", new Object[]{list});
            list2 = this.__discoverApplications_dynamic(list);
            this.__IM.onExit((Object)this, "discoverApplications_dynamic$java_util_List", list2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "discoverApplications_dynamic$java_util_List", throwable);
            throw throwable;
        }
        return list2;
    }

    private List<Application> __discoverApplications_dynamic(List<Application> discoverApplicationsStatic) {
        File f = null;
        if (!System.getProperty("os.name").startsWith("Win")) {
            try {
                Process p = Runtime.getRuntime().exec("/bin/ps aux");
                f = Utilities.convertStreamToFile((InputStream)p.getInputStream());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (Application application : discoverApplicationsStatic) {
            block13: {
                String res;
                String jmxUrl = this.getPossibleUrlFromCarol(this.getPropertyFile(CAROL_FILE_NAME, application.getRootLocation()), this.getPropertyFile(JONAS_PROPS_FILE_NAME, application.getRootLocation()));
                if (this.tryConnectToUrl(jmxUrl).booleanValue()) {
                    String jonasRoot = this.getJonasRoot(jmxUrl);
                    String jonasBase = this.getJonasBase(jmxUrl);
                    if (jonasBase.equalsIgnoreCase(application.getRootLocation())) {
                        JonasApplicationPropertiesMap jonasProps = new JonasApplicationPropertiesMap(application.getApplicationProperties());
                        jonasProps.setJmxConnector(jmxUrl);
                        jonasProps.setConfirmedJonasBase(jonasBase);
                        jonasProps.setConfirmedJonasRoot(jonasRoot);
                        application.setState(ApplicationState.RUNNING);
                        application.setApplicationProperties(jonasProps.getPropertiesList());
                    }
                }
                if (f != null && !application.stateAsApplicationState().equals((Object)ApplicationState.RUNNING) && !application.getProperty("Installation Type").equals(JonasType.JONAS_ROOT.toString()) && (res = this.getStringInFile("-Djonas.base=" + application.getRootLocation(), f)) != null && res.contains("-Djonas.name")) {
                    StringTokenizer tokenizer = new StringTokenizer(res, " ");
                    boolean keepon = true;
                    while (keepon && tokenizer.hasMoreTokens()) {
                        String next = tokenizer.nextToken();
                        if (!next.contains("-Djonas.name")) continue;
                        keepon = false;
                        next = next.replaceAll("-Djonas.name=", "");
                        String jmxNewUrl = this.getPossibleUrlFromCarol(this.getPropertyFile(CAROL_FILE_NAME, application.getRootLocation()), this.getPropertyFile(JONAS_PROPS_FILE_NAME, application.getRootLocation()), next);
                        if (!this.tryConnectToUrl(jmxNewUrl).booleanValue()) continue;
                        String jonasRoot = this.getJonasRoot(jmxNewUrl);
                        String jonasBase = this.getJonasBase(jmxNewUrl);
                        if (!jonasBase.equalsIgnoreCase(application.getRootLocation())) continue;
                        JonasApplicationPropertiesMap jonasProps = new JonasApplicationPropertiesMap(application.getApplicationProperties());
                        jonasProps.setJmxConnector(jmxNewUrl);
                        jonasProps.setConfirmedJonasBase(jonasBase);
                        jonasProps.setConfirmedJonasRoot(jonasRoot);
                        application.setState(ApplicationState.RUNNING);
                        application.setApplicationProperties(jonasProps.getPropertiesList());
                    }
                }
                if (!application.stateAsApplicationState().equals((Object)ApplicationState.RUNNING)) {
                    try {
                        File conf = new File(application.getRootLocation(), CONF_DIRECTORY_NAME);
                        File confFile = new File(conf, JONAS_PROPS_FILE_NAME);
                        PropertyManager prop = new PropertyManager(confFile.getAbsolutePath());
                        String runningServices = prop.getProperty(JONAS_SERVICES_KEY);
                        if (!runningServices.contains(DISCOVERY_SERVICE_NAME)) break block13;
                        JChannelWrapper channel = null;
                        URL confile = new File(conf, prop.getProperty(JGROUPS_CONFIGURATION_FILE_KEY)).toURL();
                        ProtocolStackConfigurator configurator = ConfiguratorFactory.getStackConfigurator((URL)confile);
                        channel = new JChannelWrapper(configurator.getProtocolStackString());
                        channel.setOpt(3, (Object)false);
                        channel.setOpt(5, (Object)true);
                        ConnectionManager invocationHandler = new ConnectionManager((long)Integer.parseInt(prop.getProperty(JGROUPS_TIMEOUT_KEY)), (Object)channel, IDiscoveryChannel.class);
                        channel.addChannelListener((ChannelListener)invocationHandler);
                        channel.connect(prop.getProperty(JGROUPS_GROUP_NAME_KEY));
                        String sourceAddr = ((IpAddress)channel.getLocalAddress()).getIpAddress().toString();
                        int sourcePort = ((IpAddress)channel.getLocalAddress()).getPort();
                        String serverName = LOCAL_SERVER_NAME;
                        String domainName = prop.getProperty(JONAS_DOMAIN_KEY);
                        String serverId = LOCAL_SERVER_NAME;
                        String[] connectorURLs = null;
                        boolean isMaster = true;
                        DiscEvent event = new DiscEvent(sourceAddr, sourcePort, serverName, domainName, serverId, connectorURLs, isMaster);
                        event.setState("starting up");
                        JGroupsHandler comHandler = new JGroupsHandler();
                        channel.setReceiver((Receiver)comHandler);
                        channel.send(null, (Address)((IpAddress)channel.getLocalAddress()), (Serializable)JGroupsDiscoveryUtils.objectToBytes((Serializable)event));
                        Thread.currentThread();
                        Thread.sleep(2000L);
                        channel.close();
                        List<String> urlConnectors = comHandler.getUrlConnectors();
                        for (String connector : urlConnectors) {
                            if (!this.tryConnectToUrl(connector).booleanValue()) continue;
                            String jonasRoot = this.getJonasRoot(connector);
                            String jonasBase = this.getJonasBase(connector);
                            if (!jonasBase.equalsIgnoreCase(application.getRootLocation())) continue;
                            JonasApplicationPropertiesMap jonasProps = new JonasApplicationPropertiesMap(application.getApplicationProperties());
                            jonasProps.setJmxConnector(connector);
                            jonasProps.setConfirmedJonasBase(jonasBase);
                            jonasProps.setConfirmedJonasRoot(jonasRoot);
                            application.setState(ApplicationState.RUNNING);
                            application.setApplicationProperties(jonasProps.getPropertiesList());
                            break;
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)"An error occured while trying to use Jonas Internal Discovery Service to discover the application, exception is {0}", new Object[]{e.getMessage()});
                    }
                }
            }
            if (application.stateAsApplicationState().equals((Object)ApplicationState.RUNNING)) continue;
            application.setState(ApplicationState.STOPPED);
        }
        if (f != null) {
            f.delete();
        }
        return discoverApplicationsStatic;
    }

    private String getJonasBase(String string) {
        String string2;
        if (!this.__MgetJonasBase$java_lang_String) {
            return this.__getJonasBase(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getJonasBase$java_lang_String", new Object[]{string});
            string2 = this.__getJonasBase(string);
            this.__IM.onExit((Object)this, "getJonasBase$java_lang_String", (Object)string2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getJonasBase$java_lang_String", throwable);
            throw throwable;
        }
        return string2;
    }

    private String __getJonasBase(String jmxUrl) {
        return this.getAttributeFromMBeanServer(jmxUrl, JONAS_J2EE_SERVER_OBJECTNAME_PATTERN, JONAS_BASE_MBEAN_ATTRIBUTE_NAME);
    }

    private String getJonasRoot(String string) {
        String string2;
        if (!this.__MgetJonasRoot$java_lang_String) {
            return this.__getJonasRoot(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getJonasRoot$java_lang_String", new Object[]{string});
            string2 = this.__getJonasRoot(string);
            this.__IM.onExit((Object)this, "getJonasRoot$java_lang_String", (Object)string2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getJonasRoot$java_lang_String", throwable);
            throw throwable;
        }
        return string2;
    }

    private String __getJonasRoot(String jmxUrl) {
        return this.getAttributeFromMBeanServer(jmxUrl, JONAS_J2EE_SERVER_OBJECTNAME_PATTERN, JONAS_ROOT_MBEAN_ATTRIBUTE_NAME);
    }

    private String getAttributeFromMBeanServer(String string, String string2, String string3) {
        String string4;
        if (!this.__MgetAttributeFromMBeanServer$java_lang_String$java_lang_String$java_lang_String) {
            return this.__getAttributeFromMBeanServer(string, string2, string3);
        }
        try {
            this.__IM.onEntry((Object)this, "getAttributeFromMBeanServer$java_lang_String$java_lang_String$java_lang_String", new Object[]{string, string2, string3});
            string4 = this.__getAttributeFromMBeanServer(string, string2, string3);
            this.__IM.onExit((Object)this, "getAttributeFromMBeanServer$java_lang_String$java_lang_String$java_lang_String", (Object)string4);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getAttributeFromMBeanServer$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String __getAttributeFromMBeanServer(String jmxUrl, String mbeanPattern, String attributeName) {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(JonasDiscovery.class.getClassLoader());
        try {
            String attributeValue;
            JMXServiceURL url = new JMXServiceURL(jmxUrl);
            JMXConnector jmxc = JMXConnectorFactory.connect(url, null);
            MBeanServerConnection mbsc = jmxc.getMBeanServerConnection();
            ObjectName myObjectName = new ObjectName(mbeanPattern);
            Set<ObjectInstance> mbeanSet = mbsc.queryMBeans(myObjectName, null);
            ObjectInstance mbeanObjectInstance = (ObjectInstance)mbeanSet.toArray()[0];
            ObjectName mbeanObjectName = mbeanObjectInstance.getObjectName();
            String string = attributeValue = (String)mbsc.getAttribute(mbeanObjectName, attributeName);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        return null;
    }

    private Boolean tryConnectToUrl(String string) {
        Boolean bl;
        if (!this.__MtryConnectToUrl$java_lang_String) {
            return this.__tryConnectToUrl(string);
        }
        try {
            this.__IM.onEntry((Object)this, "tryConnectToUrl$java_lang_String", new Object[]{string});
            bl = this.__tryConnectToUrl(string);
            this.__IM.onExit((Object)this, "tryConnectToUrl$java_lang_String", (Object)bl);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "tryConnectToUrl$java_lang_String", throwable);
            throw throwable;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean __tryConnectToUrl(String jmxUrl) {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(JonasDiscovery.class.getClassLoader());
        try {
            JMXServiceURL url = new JMXServiceURL(jmxUrl);
            JMXConnector jmxc = JMXConnectorFactory.connect(url, null);
            jmxc.close();
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Boolean bl = false;
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private String getPossibleUrlFromCarol(File file, File file2) {
        String string;
        if (!this.__MgetPossibleUrlFromCarol$java_io_File$java_io_File) {
            return this.__getPossibleUrlFromCarol(file, file2);
        }
        try {
            this.__IM.onEntry((Object)this, "getPossibleUrlFromCarol$java_io_File$java_io_File", new Object[]{file, file2});
            string = this.__getPossibleUrlFromCarol(file, file2);
            this.__IM.onExit((Object)this, "getPossibleUrlFromCarol$java_io_File$java_io_File", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getPossibleUrlFromCarol$java_io_File$java_io_File", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getPossibleUrlFromCarol(File carolPropertyFile, File jonasPropertyFile) {
        PropertyManager props = new PropertyManager(carolPropertyFile.getAbsolutePath());
        String carolProtocol = props.getProperty(CAROL_PROTOCOLS_KEY);
        String carolUrl = props.getProperty("carol." + carolProtocol + ".url");
        StringTokenizer tokenizer = new StringTokenizer(carolUrl, ":");
        String protocol = tokenizer.nextToken();
        String host = tokenizer.nextToken();
        String port = tokenizer.nextToken();
        props = new PropertyManager(jonasPropertyFile.getAbsolutePath());
        String jonasName = props.getProperty(JONAS_NAME_KEY);
        return "service:jmx:" + protocol + ":" + host + "/jndi/" + protocol + ":" + host + ":" + port + "/" + carolProtocol + "connector_" + jonasName;
    }

    private String getPossibleUrlFromCarol(File file, File file2, String string) {
        String string2;
        if (!this.__MgetPossibleUrlFromCarol$java_io_File$java_io_File$java_lang_String) {
            return this.__getPossibleUrlFromCarol(file, file2, string);
        }
        try {
            this.__IM.onEntry((Object)this, "getPossibleUrlFromCarol$java_io_File$java_io_File$java_lang_String", new Object[]{file, file2, string});
            string2 = this.__getPossibleUrlFromCarol(file, file2, string);
            this.__IM.onExit((Object)this, "getPossibleUrlFromCarol$java_io_File$java_io_File$java_lang_String", (Object)string2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getPossibleUrlFromCarol$java_io_File$java_io_File$java_lang_String", throwable);
            throw throwable;
        }
        return string2;
    }

    private String __getPossibleUrlFromCarol(File carolPropertyFile, File jonasPropertyFile, String name) {
        PropertyManager props = new PropertyManager(carolPropertyFile.getAbsolutePath());
        String carolProtocol = props.getProperty(CAROL_PROTOCOLS_KEY);
        String carolUrl = props.getProperty("carol." + carolProtocol + ".url");
        StringTokenizer tokenizer = new StringTokenizer(carolUrl, ":");
        String protocol = tokenizer.nextToken();
        String host = tokenizer.nextToken();
        String port = tokenizer.nextToken();
        return "service:jmx:" + protocol + ":" + host + "/jndi/" + protocol + ":" + host + ":" + port + "/" + carolProtocol + "connector_" + name;
    }

    private File getPropertyFile(String string, String string2) {
        File file;
        if (!this.__MgetPropertyFile$java_lang_String$java_lang_String) {
            return this.__getPropertyFile(string, string2);
        }
        try {
            this.__IM.onEntry((Object)this, "getPropertyFile$java_lang_String$java_lang_String", new Object[]{string, string2});
            file = this.__getPropertyFile(string, string2);
            this.__IM.onExit((Object)this, "getPropertyFile$java_lang_String$java_lang_String", (Object)file);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getPropertyFile$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return file;
    }

    private File __getPropertyFile(String fileName, String rootLocation) {
        File root = new File(rootLocation);
        File[] subRoot = root.listFiles((FileFilter)new AgentFileFilter(CONF_DIRECTORY_NAME));
        File[] confFiles = subRoot[0].listFiles((FileFilter)new AgentFileFilter(fileName));
        return confFiles[0];
    }

    public List<Application> discoverApplications_static() {
        List<Application> list;
        if (!this.__MdiscoverApplications_static) {
            return this.__discoverApplications_static();
        }
        try {
            this.__IM.onEntry((Object)this, "discoverApplications_static", new Object[0]);
            list = this.__discoverApplications_static();
            this.__IM.onExit((Object)this, "discoverApplications_static", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "discoverApplications_static", throwable);
            throw throwable;
        }
        return list;
    }

    private List<Application> __discoverApplications_static() {
        LinkedList<Application> applicationList = new LinkedList<Application>();
        DiscoveryPattern jonasBasePattern = PatternUtility.convertFileToPattern((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(JONAS_BASE_PATTERN_FILE));
        DiscoveryPattern jonasRootPattern = PatternUtility.convertFileToPattern((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(JONAS_ROOT_PATTERN_FILE));
        DiscoveryPattern jonasStartedOncePattern = PatternUtility.convertFileToPattern((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(ALREADY_STARTED_JONAS_PATTERN_FILE));
        DiscoveryPattern microJonasPattern = PatternUtility.convertFileToPattern((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(MICRO_JONAS_PATTERN_FILE));
        logger.info((Object)"Starting discovering JOnAS", new Object[0]);
        List fileList = this.__getfsService().searchPattern(jonasBasePattern);
        for (File base : fileList) {
            Application application = new Application();
            application.setApplicationType(TYPE);
            application.setRootLocation(base.getAbsolutePath());
            application.setState(ApplicationState.UNKNOWN);
            Boolean isJonasBase = true;
            Boolean isJonasRoot = PatternUtility.matchPattern((File)base, (DiscoveryPattern)jonasRootPattern);
            Boolean hasAlreadyBeenStartedOnce = PatternUtility.matchPattern((File)base, (DiscoveryPattern)jonasStartedOncePattern);
            Boolean isMicroJonas = PatternUtility.matchPattern((File)base, (DiscoveryPattern)microJonasPattern);
            Boolean wellFormedDirectory = true;
            JonasApplicationPropertiesMap jonasProps = new JonasApplicationPropertiesMap();
            if (isJonasBase.booleanValue() && !isJonasRoot.booleanValue() && !isMicroJonas.booleanValue()) {
                jonasProps.setJonasType(JonasType.JONAS_BASE);
            } else if (isJonasRoot.booleanValue() && !hasAlreadyBeenStartedOnce.booleanValue()) {
                jonasProps.setJonasType(JonasType.JONAS_ROOT);
            } else if (isJonasRoot.booleanValue() && hasAlreadyBeenStartedOnce.booleanValue()) {
                jonasProps.setJonasType(JonasType.JONAS_ROOT_AND_BASE);
            } else if (!isJonasRoot.booleanValue() && isMicroJonas.booleanValue()) {
                jonasProps.setJonasType(JonasType.MICRO_JONAS);
            } else {
                wellFormedDirectory = false;
            }
            if (!wellFormedDirectory.booleanValue()) continue;
            if (jonasProps.getJonasType().equals((Object)JonasType.JONAS_ROOT) || jonasProps.getJonasType().equals((Object)JonasType.JONAS_ROOT_AND_BASE) || jonasProps.getJonasType().equals((Object)JonasType.MICRO_JONAS)) {
                PropertyManager props = new PropertyManager(base.getAbsolutePath() + "/" + VERSION_PROPERTY_FILE_NAME);
                String jonasVersion = props.getProperty(JONAS_VERSION_PROPERTY_NAME);
                jonasProps.setJonasVersion(jonasVersion);
            }
            application.setApplicationProperties(jonasProps.getPropertiesList());
            applicationList.add(application);
        }
        return applicationList;
    }

    private String getStringInFile(String string, File file) {
        String string2;
        if (!this.__MgetStringInFile$java_lang_String$java_io_File) {
            return this.__getStringInFile(string, file);
        }
        try {
            this.__IM.onEntry((Object)this, "getStringInFile$java_lang_String$java_io_File", new Object[]{string, file});
            string2 = this.__getStringInFile(string, file);
            this.__IM.onExit((Object)this, "getStringInFile$java_lang_String$java_io_File", (Object)string2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getStringInFile$java_lang_String$java_io_File", throwable);
            throw throwable;
        }
        return string2;
    }

    private String __getStringInFile(String search, File file) {
        try {
            String ligne;
            FileInputStream ips = new FileInputStream(file);
            InputStreamReader ipsr = new InputStreamReader(ips);
            BufferedReader br = new BufferedReader(ipsr);
            while ((ligne = br.readLine()) != null) {
                if (!ligne.contains(search)) continue;
                br.close();
                return ligne;
            }
            br.close();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getType() {
        String string;
        if (!this.__MgetType) {
            return this.__getType();
        }
        try {
            this.__IM.onEntry((Object)this, "getType", new Object[0]);
            string = this.__getType();
            this.__IM.onExit((Object)this, "getType", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getType", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getType() {
        return TYPE;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null && set.contains("fsService")) {
            this.__FfsService = true;
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("discoverApplications")) {
                this.__MdiscoverApplications = true;
            }
            if (set.contains("discoverApplications_dynamic$java_util_List")) {
                this.__MdiscoverApplications_dynamic$java_util_List = true;
            }
            if (set.contains("getJonasBase$java_lang_String")) {
                this.__MgetJonasBase$java_lang_String = true;
            }
            if (set.contains("getJonasRoot$java_lang_String")) {
                this.__MgetJonasRoot$java_lang_String = true;
            }
            if (set.contains("getAttributeFromMBeanServer$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MgetAttributeFromMBeanServer$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("tryConnectToUrl$java_lang_String")) {
                this.__MtryConnectToUrl$java_lang_String = true;
            }
            if (set.contains("getPossibleUrlFromCarol$java_io_File$java_io_File")) {
                this.__MgetPossibleUrlFromCarol$java_io_File$java_io_File = true;
            }
            if (set.contains("getPossibleUrlFromCarol$java_io_File$java_io_File$java_lang_String")) {
                this.__MgetPossibleUrlFromCarol$java_io_File$java_io_File$java_lang_String = true;
            }
            if (set.contains("getPropertyFile$java_lang_String$java_lang_String")) {
                this.__MgetPropertyFile$java_lang_String$java_lang_String = true;
            }
            if (set.contains("discoverApplications_static")) {
                this.__MdiscoverApplications_static = true;
            }
            if (set.contains("getStringInFile$java_lang_String$java_io_File")) {
                this.__MgetStringInFile$java_lang_String$java_io_File = true;
            }
            if (set.contains("getType")) {
                this.__MgetType = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

