/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.agent.remote.rewritemanager;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Validate;
import org.ow2.jasmine.agent.common.rewrite.RewriteManagerService;
import org.ow2.jasmine.agent.remote.RemoteService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(propagation=true)
@Provides
public class RewriteManagerImpl
extends RemoteService
implements RewriteManagerService,
Pojo {
    private InstanceManager __IM;
    private static Log logger = LogFactory.getLog(RewriteManagerImpl.class);
    private static final String REWRITE_CONF_FILE_LOCATION_PROPERTY = "rewrite.conf.location";
    private boolean __FrewriteConfigurationFile;
    private String rewriteConfigurationFile;
    private static final String REWRITE_MANAGER_PROPERTY_FILE_NAME = "rewritemanager.properties";
    private boolean __Mstart;
    private boolean __MaddRewriteRuleInDirectory$java_lang_String$java_lang_String$java_lang_String$java_lang_String;
    private boolean __MaddRewriteRuleInDirectory$java_lang_String$java_lang_String$java_lang_String;
    private boolean __MaddRewriteRuleInProxy$java_lang_String$java_lang_String$java_lang_String$java_lang_String;
    private boolean __MaddRewriteRuleInProxy$java_lang_String$java_lang_String$java_lang_String;
    private boolean __MremoveRewriteRuleInDirectory$java_lang_String$java_lang_String$java_lang_String;
    private boolean __MremoveRewriteRuleInProxy$java_lang_String$java_lang_String$java_lang_String;
    private boolean __MaddRewriteBaseInDirectory$java_lang_String$java_lang_String;
    private boolean __MaddRewriteBaseInProxy$java_lang_String$java_lang_String;
    private boolean __MremoveRewriteBaseInDirectory$java_lang_String$java_lang_String;
    private boolean __MremoveRewriteBaseInProxy$java_lang_String$java_lang_String;
    private boolean __MaddRewriteCondInDirectory$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String;
    private boolean __MaddRewriteCondInDirectory$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String;
    private boolean __MaddRewriteCondInProxy$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String;
    private boolean __MaddRewriteCondInProxy$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String;
    private boolean __MremoveRewriteCondInDirectory$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String;
    private boolean __MremoveRewriteCondInProxy$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String;
    private boolean __MremoveDirectoryDirective$java_lang_String;
    private boolean __MremoveProxyDirective$java_lang_String;
    private boolean __Minit$java_lang_String;
    private boolean __MloadConfigurationFile$java_lang_String;
    private boolean __MflushConfigurationFile$java_lang_String$java_util_List;
    private boolean __MgetRewriteConfigurationFile;
    private boolean __MsetRewriteConfigurationFile$java_lang_String;
    private boolean __MgetRewritePropertyFileLocation;

    String __getrewriteConfigurationFile() {
        if (!this.__FrewriteConfigurationFile) {
            return this.rewriteConfigurationFile;
        }
        return (String)this.__IM.onGet((Object)this, "rewriteConfigurationFile");
    }

    void __setrewriteConfigurationFile(String string) {
        if (!this.__FrewriteConfigurationFile) {
            this.rewriteConfigurationFile = string;
            return;
        }
        this.__IM.onSet((Object)this, "rewriteConfigurationFile", (Object)string);
    }

    public RewriteManagerImpl() {
        this(null);
    }

    private RewriteManagerImpl(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public void start() {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __start() {
        logger.info((Object)"Load default configuration", new Object[0]);
        String rewriteConfigurationFile = this.getRewritePropertyFileLocation();
        this.setRewriteConfigurationFile(rewriteConfigurationFile);
        logger.info((Object)("rewriteConfigurationFile=" + rewriteConfigurationFile), new Object[0]);
    }

    public void addRewriteRuleInDirectory(String string, String string2, String string3, String string4) {
        if (!this.__MaddRewriteRuleInDirectory$java_lang_String$java_lang_String$java_lang_String$java_lang_String) {
            this.__addRewriteRuleInDirectory(string, string2, string3, string4);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addRewriteRuleInDirectory$java_lang_String$java_lang_String$java_lang_String$java_lang_String", new Object[]{string, string2, string3, string4});
            this.__addRewriteRuleInDirectory(string, string2, string3, string4);
            this.__IM.onExit((Object)this, "addRewriteRuleInDirectory$java_lang_String$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addRewriteRuleInDirectory$java_lang_String$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __addRewriteRuleInDirectory(String directoryDirective, String pattern, String substitution, String flag) {
        logger.info((Object)("addRewriteRuleInDirectory (" + directoryDirective + "," + pattern + "," + substitution + ", " + flag + ")"), new Object[0]);
        String confFileLocation = this.getRewriteConfigurationFile();
        List<String> fileStringList = this.loadConfigurationFile(confFileLocation);
        LinkedList<String> newFileStringList = new LinkedList<String>();
        boolean directoryDirectiveAlreadyCreated = false;
        boolean inDirectoryDirective = false;
        boolean rewriteRuleAlreadyPresent = false;
        ListIterator<String> iterator = fileStringList.listIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.contains("<Directory " + directoryDirective + ">")) {
                directoryDirectiveAlreadyCreated = true;
                inDirectoryDirective = true;
            }
            if (string.contains("</Directory>")) {
                if (inDirectoryDirective && !rewriteRuleAlreadyPresent) {
                    newFileStringList.add("RewriteRule " + pattern + " " + substitution + " [" + flag + "]");
                    rewriteRuleAlreadyPresent = true;
                }
                inDirectoryDirective = false;
            }
            if (!rewriteRuleAlreadyPresent && inDirectoryDirective && string.contains("RewriteRule " + pattern + " " + substitution)) {
                newFileStringList.add("RewriteRule " + pattern + " " + substitution + " [" + flag + "]");
                rewriteRuleAlreadyPresent = true;
                continue;
            }
            newFileStringList.add(string);
        }
        if (!directoryDirectiveAlreadyCreated) {
            newFileStringList.add("<Directory " + directoryDirective + ">");
            newFileStringList.add("options +FollowSymlinks");
            newFileStringList.add("RewriteEngine On");
            newFileStringList.add("RewriteRule " + pattern + " " + substitution + " [" + flag + "]");
            newFileStringList.add("</Directory>");
        }
        this.flushConfigurationFile(confFileLocation, newFileStringList);
    }

    public void addRewriteRuleInDirectory(String string, String string2, String string3) {
        if (!this.__MaddRewriteRuleInDirectory$java_lang_String$java_lang_String$java_lang_String) {
            this.__addRewriteRuleInDirectory(string, string2, string3);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addRewriteRuleInDirectory$java_lang_String$java_lang_String$java_lang_String", new Object[]{string, string2, string3});
            this.__addRewriteRuleInDirectory(string, string2, string3);
            this.__IM.onExit((Object)this, "addRewriteRuleInDirectory$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addRewriteRuleInDirectory$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __addRewriteRuleInDirectory(String directoryDirective, String pattern, String substitution) {
        logger.info((Object)("addRewriteRuleInDirectory (" + directoryDirective + "," + pattern + "," + substitution + ")"), new Object[0]);
        String confFileLocation = this.getRewriteConfigurationFile();
        List<String> fileStringList = this.loadConfigurationFile(confFileLocation);
        LinkedList<String> newFileStringList = new LinkedList<String>();
        boolean directoryDirectiveAlreadyCreated = false;
        boolean inDirectoryDirective = false;
        boolean rewriteRuleAlreadyPresent = false;
        ListIterator<String> iterator = fileStringList.listIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.contains("<Directory " + directoryDirective + ">")) {
                directoryDirectiveAlreadyCreated = true;
                inDirectoryDirective = true;
            }
            if (string.contains("</Directory>")) {
                if (inDirectoryDirective && !rewriteRuleAlreadyPresent) {
                    newFileStringList.add("RewriteRule " + pattern + " " + substitution);
                    rewriteRuleAlreadyPresent = true;
                }
                inDirectoryDirective = false;
            }
            if (!rewriteRuleAlreadyPresent && inDirectoryDirective && string.contains("RewriteRule " + pattern + " " + substitution)) {
                newFileStringList.add("RewriteRule " + pattern + " " + substitution);
                rewriteRuleAlreadyPresent = true;
                continue;
            }
            newFileStringList.add(string);
        }
        if (!directoryDirectiveAlreadyCreated) {
            newFileStringList.add("<Directory " + directoryDirective + ">");
            newFileStringList.add("options +FollowSymlinks");
            newFileStringList.add("RewriteEngine On");
            newFileStringList.add("RewriteRule " + pattern + " " + substitution);
            newFileStringList.add("</Directory>");
        }
        this.flushConfigurationFile(confFileLocation, newFileStringList);
    }

    public void addRewriteRuleInProxy(String string, String string2, String string3, String string4) {
        if (!this.__MaddRewriteRuleInProxy$java_lang_String$java_lang_String$java_lang_String$java_lang_String) {
            this.__addRewriteRuleInProxy(string, string2, string3, string4);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addRewriteRuleInProxy$java_lang_String$java_lang_String$java_lang_String$java_lang_String", new Object[]{string, string2, string3, string4});
            this.__addRewriteRuleInProxy(string, string2, string3, string4);
            this.__IM.onExit((Object)this, "addRewriteRuleInProxy$java_lang_String$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addRewriteRuleInProxy$java_lang_String$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __addRewriteRuleInProxy(String proxyDirective, String pattern, String substitution, String flag) {
        logger.info((Object)("addRewriteRuleInProxy (" + proxyDirective + "," + pattern + "," + substitution + ", " + flag + ")"), new Object[0]);
        String confFileLocation = this.getRewriteConfigurationFile();
        List<String> fileStringList = this.loadConfigurationFile(confFileLocation);
        LinkedList<String> newFileStringList = new LinkedList<String>();
        boolean proxyDirectiveAlreadyCreated = false;
        boolean inProxyDirective = false;
        boolean rewriteRuleAlreadyPresent = false;
        ListIterator<String> iterator = fileStringList.listIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.contains("<Proxy " + proxyDirective + ">")) {
                proxyDirectiveAlreadyCreated = true;
                inProxyDirective = true;
            }
            if (string.contains("</Proxy>")) {
                if (inProxyDirective && !rewriteRuleAlreadyPresent) {
                    newFileStringList.add("RewriteRule " + pattern + " " + substitution + " [" + flag + "]");
                    rewriteRuleAlreadyPresent = true;
                }
                inProxyDirective = false;
            }
            if (!rewriteRuleAlreadyPresent && inProxyDirective && string.contains("RewriteRule " + pattern + " " + substitution)) {
                newFileStringList.add("RewriteRule " + pattern + " " + substitution + " [" + flag + "]");
                rewriteRuleAlreadyPresent = true;
                continue;
            }
            newFileStringList.add(string);
        }
        if (!proxyDirectiveAlreadyCreated) {
            newFileStringList.add("<Proxy " + proxyDirective + ">");
            newFileStringList.add("options +FollowSymlinks");
            newFileStringList.add("RewriteEngine On");
            newFileStringList.add("RewriteRule " + pattern + " " + substitution + " [" + flag + "]");
            newFileStringList.add("</Proxy>");
        }
        this.flushConfigurationFile(confFileLocation, newFileStringList);
    }

    public void addRewriteRuleInProxy(String string, String string2, String string3) {
        if (!this.__MaddRewriteRuleInProxy$java_lang_String$java_lang_String$java_lang_String) {
            this.__addRewriteRuleInProxy(string, string2, string3);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addRewriteRuleInProxy$java_lang_String$java_lang_String$java_lang_String", new Object[]{string, string2, string3});
            this.__addRewriteRuleInProxy(string, string2, string3);
            this.__IM.onExit((Object)this, "addRewriteRuleInProxy$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addRewriteRuleInProxy$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __addRewriteRuleInProxy(String proxyDirective, String pattern, String substitution) {
        logger.info((Object)("addRewriteRuleInProxy (" + proxyDirective + "," + pattern + "," + substitution + ")"), new Object[0]);
        String confFileLocation = this.getRewriteConfigurationFile();
        List<String> fileStringList = this.loadConfigurationFile(confFileLocation);
        LinkedList<String> newFileStringList = new LinkedList<String>();
        boolean proxyDirectiveAlreadyCreated = false;
        boolean inProxyDirective = false;
        boolean rewriteRuleAlreadyPresent = false;
        ListIterator<String> iterator = fileStringList.listIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.contains("<Proxy " + proxyDirective + ">")) {
                proxyDirectiveAlreadyCreated = true;
                inProxyDirective = true;
            }
            if (string.contains("</Proxy>")) {
                if (inProxyDirective && !rewriteRuleAlreadyPresent) {
                    newFileStringList.add("RewriteRule " + pattern + " " + substitution);
                    rewriteRuleAlreadyPresent = true;
                }
                inProxyDirective = false;
            }
            if (!rewriteRuleAlreadyPresent && inProxyDirective && string.contains("RewriteRule " + pattern + " " + substitution)) {
                newFileStringList.add("RewriteRule " + pattern + " " + substitution);
                rewriteRuleAlreadyPresent = true;
                continue;
            }
            newFileStringList.add(string);
        }
        if (!proxyDirectiveAlreadyCreated) {
            newFileStringList.add("<Proxy " + proxyDirective + ">");
            newFileStringList.add("options +FollowSymlinks");
            newFileStringList.add("RewriteEngine On");
            newFileStringList.add("RewriteRule " + pattern + " " + substitution);
            newFileStringList.add("</Proxy>");
        }
        this.flushConfigurationFile(confFileLocation, newFileStringList);
    }

    public void removeRewriteRuleInDirectory(String string, String string2, String string3) {
        if (!this.__MremoveRewriteRuleInDirectory$java_lang_String$java_lang_String$java_lang_String) {
            this.__removeRewriteRuleInDirectory(string, string2, string3);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeRewriteRuleInDirectory$java_lang_String$java_lang_String$java_lang_String", new Object[]{string, string2, string3});
            this.__removeRewriteRuleInDirectory(string, string2, string3);
            this.__IM.onExit((Object)this, "removeRewriteRuleInDirectory$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeRewriteRuleInDirectory$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __removeRewriteRuleInDirectory(String directoryDirective, String pattern, String substitution) {
        logger.info((Object)("removeRewriteRuleInDirectory (" + directoryDirective + "," + pattern + "," + substitution + ")"), new Object[0]);
        String confFileLocation = this.getRewriteConfigurationFile();
        List<String> fileStringList = this.loadConfigurationFile(confFileLocation);
        LinkedList<String> newFileStringList = new LinkedList<String>();
        boolean inDirectoryDirective = false;
        String rewriteCondTmp = "";
        boolean rewriteCondMatch = false;
        ListIterator<String> iterator = fileStringList.listIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.contains("<Directory " + directoryDirective + ">")) {
                inDirectoryDirective = true;
            }
            if (string.contains("</Directory>")) {
                inDirectoryDirective = false;
            }
            if (inDirectoryDirective && string.contains("RewriteCond ")) {
                rewriteCondTmp = rewriteCondTmp + string + System.getProperty("line.separator");
                rewriteCondMatch = true;
            }
            if (inDirectoryDirective && rewriteCondMatch && string.contains("RewriteRule ")) {
                if (!string.contains("RewriteRule " + pattern + " " + substitution)) {
                    rewriteCondTmp = rewriteCondTmp.substring(0, rewriteCondTmp.length() - 1);
                    newFileStringList.add(rewriteCondTmp);
                }
                rewriteCondMatch = false;
            }
            if (string.contains("RewriteRule " + pattern + " " + substitution) && inDirectoryDirective || rewriteCondMatch) continue;
            newFileStringList.add(string);
        }
        this.flushConfigurationFile(confFileLocation, newFileStringList);
    }

    public void removeRewriteRuleInProxy(String string, String string2, String string3) {
        if (!this.__MremoveRewriteRuleInProxy$java_lang_String$java_lang_String$java_lang_String) {
            this.__removeRewriteRuleInProxy(string, string2, string3);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeRewriteRuleInProxy$java_lang_String$java_lang_String$java_lang_String", new Object[]{string, string2, string3});
            this.__removeRewriteRuleInProxy(string, string2, string3);
            this.__IM.onExit((Object)this, "removeRewriteRuleInProxy$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeRewriteRuleInProxy$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __removeRewriteRuleInProxy(String proxyDirective, String pattern, String substitution) {
        logger.info((Object)("removeRewriteRuleInProxy (" + proxyDirective + "," + pattern + "," + substitution + ")"), new Object[0]);
        String confFileLocation = this.getRewriteConfigurationFile();
        List<String> fileStringList = this.loadConfigurationFile(confFileLocation);
        LinkedList<String> newFileStringList = new LinkedList<String>();
        boolean inProxyDirective = false;
        String rewriteCondTmp = "";
        boolean rewriteCondMatch = false;
        ListIterator<String> iterator = fileStringList.listIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.contains("<Proxy " + proxyDirective + ">")) {
                inProxyDirective = true;
            }
            if (string.contains("</Proxy>")) {
                inProxyDirective = false;
            }
            if (inProxyDirective && string.contains("RewriteCond ")) {
                rewriteCondTmp = rewriteCondTmp + string + System.getProperty("line.separator");
                rewriteCondMatch = true;
            }
            if (inProxyDirective && rewriteCondMatch && string.contains("RewriteRule ")) {
                if (!string.contains("RewriteRule " + pattern + " " + substitution)) {
                    rewriteCondTmp = rewriteCondTmp.substring(0, rewriteCondTmp.length() - 1);
                    newFileStringList.add(rewriteCondTmp);
                }
                rewriteCondMatch = false;
            }
            if (string.contains("RewriteRule " + pattern + " " + substitution) && inProxyDirective || rewriteCondMatch) continue;
            newFileStringList.add(string);
        }
        this.flushConfigurationFile(confFileLocation, newFileStringList);
    }

    public void addRewriteBaseInDirectory(String string, String string2) {
        if (!this.__MaddRewriteBaseInDirectory$java_lang_String$java_lang_String) {
            this.__addRewriteBaseInDirectory(string, string2);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addRewriteBaseInDirectory$java_lang_String$java_lang_String", new Object[]{string, string2});
            this.__addRewriteBaseInDirectory(string, string2);
            this.__IM.onExit((Object)this, "addRewriteBaseInDirectory$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addRewriteBaseInDirectory$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __addRewriteBaseInDirectory(String directoryDirective, String urlPath) {
        logger.info((Object)("addRewriteBaseInDirectory (" + directoryDirective + "," + urlPath + ")"), new Object[0]);
        String confFileLocation = this.getRewriteConfigurationFile();
        List<String> fileStringList = this.loadConfigurationFile(confFileLocation);
        LinkedList<String> newFileStringList = new LinkedList<String>();
        boolean directoryDirectiveAlreadyCreated = false;
        boolean inDirectoryDirective = false;
        boolean rewriteBaseAlreadyPresent = false;
        ListIterator<String> iterator = fileStringList.listIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.contains("<Directory " + directoryDirective + ">")) {
                directoryDirectiveAlreadyCreated = true;
                inDirectoryDirective = true;
            }
            if (string.contains("</Directory>")) {
                if (inDirectoryDirective && !rewriteBaseAlreadyPresent) {
                    newFileStringList.add("RewriteBase " + urlPath);
                    rewriteBaseAlreadyPresent = true;
                }
                inDirectoryDirective = false;
            }
            if (!rewriteBaseAlreadyPresent && inDirectoryDirective && string.contains("RewriteBase")) {
                newFileStringList.add("RewriteBase " + urlPath);
                rewriteBaseAlreadyPresent = true;
                continue;
            }
            newFileStringList.add(string);
        }
        if (!directoryDirectiveAlreadyCreated) {
            newFileStringList.add("<Directory " + directoryDirective + ">");
            newFileStringList.add("options +FollowSymlinks");
            newFileStringList.add("RewriteEngine On");
            newFileStringList.add("RewriteBase " + urlPath);
            newFileStringList.add("</Directory>");
        }
        this.flushConfigurationFile(confFileLocation, newFileStringList);
    }

    public void addRewriteBaseInProxy(String string, String string2) {
        if (!this.__MaddRewriteBaseInProxy$java_lang_String$java_lang_String) {
            this.__addRewriteBaseInProxy(string, string2);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addRewriteBaseInProxy$java_lang_String$java_lang_String", new Object[]{string, string2});
            this.__addRewriteBaseInProxy(string, string2);
            this.__IM.onExit((Object)this, "addRewriteBaseInProxy$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addRewriteBaseInProxy$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __addRewriteBaseInProxy(String proxyDirective, String urlPath) {
        logger.info((Object)("addRewriteBaseInProxy (" + proxyDirective + "," + urlPath + ")"), new Object[0]);
        String confFileLocation = this.getRewriteConfigurationFile();
        List<String> fileStringList = this.loadConfigurationFile(confFileLocation);
        LinkedList<String> newFileStringList = new LinkedList<String>();
        boolean proxyDirectiveAlreadyCreated = false;
        boolean inProxyDirective = false;
        boolean rewriteBaseAlreadyPresent = false;
        ListIterator<String> iterator = fileStringList.listIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.contains("<Proxy " + proxyDirective + ">")) {
                proxyDirectiveAlreadyCreated = true;
                inProxyDirective = true;
            }
            if (string.contains("</Proxy>")) {
                if (inProxyDirective && !rewriteBaseAlreadyPresent) {
                    newFileStringList.add("RewriteBase " + urlPath);
                    rewriteBaseAlreadyPresent = true;
                }
                inProxyDirective = false;
            }
            if (!rewriteBaseAlreadyPresent && inProxyDirective && string.contains("RewriteBase")) {
                newFileStringList.add("RewriteBase " + urlPath);
                rewriteBaseAlreadyPresent = true;
                continue;
            }
            newFileStringList.add(string);
        }
        if (!proxyDirectiveAlreadyCreated) {
            newFileStringList.add("<Proxy " + proxyDirective + ">");
            newFileStringList.add("options +FollowSymlinks");
            newFileStringList.add("RewriteEngine On");
            newFileStringList.add("RewriteBase " + urlPath);
            newFileStringList.add("</Proxy>");
        }
        this.flushConfigurationFile(confFileLocation, newFileStringList);
    }

    public void removeRewriteBaseInDirectory(String string, String string2) {
        if (!this.__MremoveRewriteBaseInDirectory$java_lang_String$java_lang_String) {
            this.__removeRewriteBaseInDirectory(string, string2);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeRewriteBaseInDirectory$java_lang_String$java_lang_String", new Object[]{string, string2});
            this.__removeRewriteBaseInDirectory(string, string2);
            this.__IM.onExit((Object)this, "removeRewriteBaseInDirectory$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeRewriteBaseInDirectory$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __removeRewriteBaseInDirectory(String directoryDirective, String urlPath) {
        logger.info((Object)("removeRewriteBaseInDirectory (" + directoryDirective + "," + urlPath + ")"), new Object[0]);
        String confFileLocation = this.getRewriteConfigurationFile();
        List<String> fileStringList = this.loadConfigurationFile(confFileLocation);
        LinkedList<String> newFileStringList = new LinkedList<String>();
        boolean inDirectoryDirective = false;
        ListIterator<String> iterator = fileStringList.listIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.contains("<Directory " + directoryDirective + ">")) {
                inDirectoryDirective = true;
            }
            if (string.contains("</Directory>")) {
                inDirectoryDirective = false;
            }
            if (string.contains("RewriteBase " + urlPath) && inDirectoryDirective) continue;
            newFileStringList.add(string);
        }
        this.flushConfigurationFile(confFileLocation, newFileStringList);
    }

    public void removeRewriteBaseInProxy(String string, String string2) {
        if (!this.__MremoveRewriteBaseInProxy$java_lang_String$java_lang_String) {
            this.__removeRewriteBaseInProxy(string, string2);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeRewriteBaseInProxy$java_lang_String$java_lang_String", new Object[]{string, string2});
            this.__removeRewriteBaseInProxy(string, string2);
            this.__IM.onExit((Object)this, "removeRewriteBaseInProxy$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeRewriteBaseInProxy$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __removeRewriteBaseInProxy(String proxyDirective, String urlPath) {
        logger.info((Object)("removeRewriteBaseInProxy (" + proxyDirective + "," + urlPath + ")"), new Object[0]);
        String confFileLocation = this.getRewriteConfigurationFile();
        List<String> fileStringList = this.loadConfigurationFile(confFileLocation);
        LinkedList<String> newFileStringList = new LinkedList<String>();
        boolean inProxyDirective = false;
        ListIterator<String> iterator = fileStringList.listIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.contains("<Proxy " + proxyDirective + ">")) {
                inProxyDirective = true;
            }
            if (string.contains("</Proxy>")) {
                inProxyDirective = false;
            }
            if (string.contains("RewriteBase " + urlPath) && inProxyDirective) continue;
            newFileStringList.add(string);
        }
        this.flushConfigurationFile(confFileLocation, newFileStringList);
    }

    public void addRewriteCondInDirectory(String string, String string2, String string3, String string4, String string5, String string6) {
        if (!this.__MaddRewriteCondInDirectory$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String) {
            this.__addRewriteCondInDirectory(string, string2, string3, string4, string5, string6);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addRewriteCondInDirectory$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", new Object[]{string, string2, string3, string4, string5, string6});
            this.__addRewriteCondInDirectory(string, string2, string3, string4, string5, string6);
            this.__IM.onExit((Object)this, "addRewriteCondInDirectory$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addRewriteCondInDirectory$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __addRewriteCondInDirectory(String directoryDirective, String rulePattern, String ruleSubstitution, String condTestString, String condPattern, String condFlag) {
        logger.info((Object)("addRewriteCondInDirectory (" + directoryDirective + "," + rulePattern + "," + ruleSubstitution + "," + condTestString + "," + condPattern + "," + condFlag + ")"), new Object[0]);
        String confFileLocation = this.getRewriteConfigurationFile();
        List<String> fileStringList = this.loadConfigurationFile(confFileLocation);
        LinkedList<String> newFileStringList = new LinkedList<String>();
        boolean directoryDirectiveAlreadyCreated = false;
        boolean inDirectoryDirective = false;
        boolean rewriteCondAlreadyPresent = false;
        ListIterator<String> iterator = fileStringList.listIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.contains("<Directory " + directoryDirective + ">")) {
                directoryDirectiveAlreadyCreated = true;
                inDirectoryDirective = true;
            }
            if (string.contains("</Directory>")) {
                if (inDirectoryDirective && !rewriteCondAlreadyPresent) {
                    newFileStringList.add("RewriteCond " + condTestString + " " + condPattern + " [" + condFlag + "]");
                    newFileStringList.add("RewriteRule " + rulePattern + " " + ruleSubstitution);
                    rewriteCondAlreadyPresent = true;
                }
                inDirectoryDirective = false;
            }
            if (inDirectoryDirective && string.contains("RewriteCond " + condTestString + " " + condPattern)) {
                rewriteCondAlreadyPresent = true;
            }
            if (inDirectoryDirective && rewriteCondAlreadyPresent && string.contains("RewriteRule ") && !string.contains("RewriteRule " + rulePattern + " " + ruleSubstitution)) {
                rewriteCondAlreadyPresent = false;
            }
            if (!rewriteCondAlreadyPresent && inDirectoryDirective && string.contains("RewriteRule " + rulePattern + " " + ruleSubstitution)) {
                newFileStringList.add("RewriteCond " + condTestString + " " + condPattern + " [" + condFlag + "]");
                rewriteCondAlreadyPresent = true;
                newFileStringList.add(string);
                continue;
            }
            newFileStringList.add(string);
        }
        if (!directoryDirectiveAlreadyCreated) {
            newFileStringList.add("<Directory " + directoryDirective + ">");
            newFileStringList.add("options +FollowSymlinks");
            newFileStringList.add("RewriteEngine On");
            newFileStringList.add("RewriteCond " + condTestString + " " + condPattern + " [" + condFlag + "]");
            newFileStringList.add("RewriteRule " + rulePattern + " " + ruleSubstitution);
            newFileStringList.add("</Directory>");
        }
        this.flushConfigurationFile(confFileLocation, newFileStringList);
    }

    public void addRewriteCondInDirectory(String string, String string2, String string3, String string4, String string5) {
        if (!this.__MaddRewriteCondInDirectory$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String) {
            this.__addRewriteCondInDirectory(string, string2, string3, string4, string5);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addRewriteCondInDirectory$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", new Object[]{string, string2, string3, string4, string5});
            this.__addRewriteCondInDirectory(string, string2, string3, string4, string5);
            this.__IM.onExit((Object)this, "addRewriteCondInDirectory$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addRewriteCondInDirectory$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __addRewriteCondInDirectory(String directoryDirective, String rulePattern, String ruleSubstitution, String condTestString, String condPattern) {
        logger.info((Object)("addRewriteCondInDirectory (" + directoryDirective + "," + rulePattern + "," + ruleSubstitution + "," + condTestString + "," + condPattern + ")"), new Object[0]);
        String confFileLocation = this.getRewriteConfigurationFile();
        List<String> fileStringList = this.loadConfigurationFile(confFileLocation);
        LinkedList<String> newFileStringList = new LinkedList<String>();
        boolean directoryDirectiveAlreadyCreated = false;
        boolean inDirectoryDirective = false;
        boolean rewriteCondAlreadyPresent = false;
        ListIterator<String> iterator = fileStringList.listIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.contains("<Directory " + directoryDirective + ">")) {
                directoryDirectiveAlreadyCreated = true;
                inDirectoryDirective = true;
            }
            if (string.contains("</Directory>")) {
                if (inDirectoryDirective && !rewriteCondAlreadyPresent) {
                    newFileStringList.add("RewriteCond " + condTestString + " " + condPattern);
                    newFileStringList.add("RewriteRule " + rulePattern + " " + ruleSubstitution);
                    rewriteCondAlreadyPresent = true;
                }
                inDirectoryDirective = false;
            }
            if (inDirectoryDirective && string.contains("RewriteCond " + condTestString + " " + condPattern)) {
                rewriteCondAlreadyPresent = true;
            }
            if (inDirectoryDirective && rewriteCondAlreadyPresent && string.contains("RewriteRule ") && !string.contains("RewriteRule " + rulePattern + " " + ruleSubstitution)) {
                rewriteCondAlreadyPresent = false;
            }
            if (!rewriteCondAlreadyPresent && inDirectoryDirective && string.contains("RewriteRule " + rulePattern + " " + ruleSubstitution)) {
                newFileStringList.add("RewriteCond " + condTestString + " " + condPattern);
                rewriteCondAlreadyPresent = true;
                newFileStringList.add(string);
                continue;
            }
            newFileStringList.add(string);
        }
        if (!directoryDirectiveAlreadyCreated) {
            newFileStringList.add("<Directory " + directoryDirective + ">");
            newFileStringList.add("options +FollowSymlinks");
            newFileStringList.add("RewriteEngine On");
            newFileStringList.add("RewriteCond " + condTestString + " " + condPattern);
            newFileStringList.add("RewriteRule " + rulePattern + " " + ruleSubstitution);
            newFileStringList.add("</Directory>");
        }
        this.flushConfigurationFile(confFileLocation, newFileStringList);
    }

    public void addRewriteCondInProxy(String string, String string2, String string3, String string4, String string5, String string6) {
        if (!this.__MaddRewriteCondInProxy$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String) {
            this.__addRewriteCondInProxy(string, string2, string3, string4, string5, string6);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addRewriteCondInProxy$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", new Object[]{string, string2, string3, string4, string5, string6});
            this.__addRewriteCondInProxy(string, string2, string3, string4, string5, string6);
            this.__IM.onExit((Object)this, "addRewriteCondInProxy$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addRewriteCondInProxy$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __addRewriteCondInProxy(String proxyDirective, String rulePattern, String ruleSubstitution, String condTestString, String condPattern, String condFlag) {
        logger.info((Object)("addRewriteCondInProxy (" + proxyDirective + "," + rulePattern + "," + ruleSubstitution + "," + condTestString + "," + condPattern + "," + condFlag + ")"), new Object[0]);
        String confFileLocation = this.getRewriteConfigurationFile();
        List<String> fileStringList = this.loadConfigurationFile(confFileLocation);
        LinkedList<String> newFileStringList = new LinkedList<String>();
        boolean proxyDirectiveAlreadyCreated = false;
        boolean inProxyDirective = false;
        boolean rewriteCondAlreadyPresent = false;
        ListIterator<String> iterator = fileStringList.listIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.contains("<Proxy " + proxyDirective + ">")) {
                proxyDirectiveAlreadyCreated = true;
                inProxyDirective = true;
            }
            if (string.contains("</Proxy>")) {
                if (inProxyDirective && !rewriteCondAlreadyPresent) {
                    newFileStringList.add("RewriteCond " + condTestString + " " + condPattern + " [" + condFlag + "]");
                    newFileStringList.add("RewriteRule " + rulePattern + " " + ruleSubstitution);
                    rewriteCondAlreadyPresent = true;
                }
                inProxyDirective = false;
            }
            if (inProxyDirective && string.contains("RewriteCond " + condTestString + " " + condPattern)) {
                rewriteCondAlreadyPresent = true;
            }
            if (inProxyDirective && rewriteCondAlreadyPresent && string.contains("RewriteRule ") && !string.contains("RewriteRule " + rulePattern + " " + ruleSubstitution)) {
                rewriteCondAlreadyPresent = false;
            }
            if (!rewriteCondAlreadyPresent && inProxyDirective && string.contains("RewriteRule " + rulePattern + " " + ruleSubstitution)) {
                newFileStringList.add("RewriteCond " + condTestString + " " + condPattern + " [" + condFlag + "]");
                rewriteCondAlreadyPresent = true;
                newFileStringList.add(string);
                continue;
            }
            newFileStringList.add(string);
        }
        if (!proxyDirectiveAlreadyCreated) {
            newFileStringList.add("<Proxy " + proxyDirective + ">");
            newFileStringList.add("options +FollowSymlinks");
            newFileStringList.add("RewriteEngine On");
            newFileStringList.add("RewriteCond " + condTestString + " " + condPattern + " [" + condFlag + "]");
            newFileStringList.add("RewriteRule " + rulePattern + " " + ruleSubstitution);
            newFileStringList.add("</Proxy>");
        }
        this.flushConfigurationFile(confFileLocation, newFileStringList);
    }

    public void addRewriteCondInProxy(String string, String string2, String string3, String string4, String string5) {
        if (!this.__MaddRewriteCondInProxy$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String) {
            this.__addRewriteCondInProxy(string, string2, string3, string4, string5);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addRewriteCondInProxy$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", new Object[]{string, string2, string3, string4, string5});
            this.__addRewriteCondInProxy(string, string2, string3, string4, string5);
            this.__IM.onExit((Object)this, "addRewriteCondInProxy$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addRewriteCondInProxy$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __addRewriteCondInProxy(String proxyDirective, String rulePattern, String ruleSubstitution, String condTestString, String condPattern) {
        logger.info((Object)("addRewriteCondInProxy (" + proxyDirective + "," + rulePattern + "," + ruleSubstitution + "," + condTestString + "," + condPattern + ")"), new Object[0]);
        String confFileLocation = this.getRewriteConfigurationFile();
        List<String> fileStringList = this.loadConfigurationFile(confFileLocation);
        LinkedList<String> newFileStringList = new LinkedList<String>();
        boolean proxyDirectiveAlreadyCreated = false;
        boolean inProxyDirective = false;
        boolean rewriteCondAlreadyPresent = false;
        ListIterator<String> iterator = fileStringList.listIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.contains("<Proxy " + proxyDirective + ">")) {
                proxyDirectiveAlreadyCreated = true;
                inProxyDirective = true;
            }
            if (string.contains("</Proxy>")) {
                if (inProxyDirective && !rewriteCondAlreadyPresent) {
                    newFileStringList.add("RewriteCond " + condTestString + " " + condPattern);
                    newFileStringList.add("RewriteRule " + rulePattern + " " + ruleSubstitution);
                    rewriteCondAlreadyPresent = true;
                }
                inProxyDirective = false;
            }
            if (inProxyDirective && string.contains("RewriteCond " + condTestString + " " + condPattern)) {
                rewriteCondAlreadyPresent = true;
            }
            if (inProxyDirective && rewriteCondAlreadyPresent && string.contains("RewriteRule ") && !string.contains("RewriteRule " + rulePattern + " " + ruleSubstitution)) {
                rewriteCondAlreadyPresent = false;
            }
            if (!rewriteCondAlreadyPresent && inProxyDirective && string.contains("RewriteRule " + rulePattern + " " + ruleSubstitution)) {
                newFileStringList.add("RewriteCond " + condTestString + " " + condPattern);
                rewriteCondAlreadyPresent = true;
                newFileStringList.add(string);
                continue;
            }
            newFileStringList.add(string);
        }
        if (!proxyDirectiveAlreadyCreated) {
            newFileStringList.add("<Proxy " + proxyDirective + ">");
            newFileStringList.add("options +FollowSymlinks");
            newFileStringList.add("RewriteEngine On");
            newFileStringList.add("RewriteCond " + condTestString + " " + condPattern);
            newFileStringList.add("RewriteRule " + rulePattern + " " + ruleSubstitution);
            newFileStringList.add("</Proxy>");
        }
        this.flushConfigurationFile(confFileLocation, newFileStringList);
    }

    public void removeRewriteCondInDirectory(String string, String string2, String string3, String string4, String string5) {
        if (!this.__MremoveRewriteCondInDirectory$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String) {
            this.__removeRewriteCondInDirectory(string, string2, string3, string4, string5);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeRewriteCondInDirectory$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", new Object[]{string, string2, string3, string4, string5});
            this.__removeRewriteCondInDirectory(string, string2, string3, string4, string5);
            this.__IM.onExit((Object)this, "removeRewriteCondInDirectory$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeRewriteCondInDirectory$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __removeRewriteCondInDirectory(String directoryDirective, String rulePattern, String ruleSubstitution, String condTestString, String condPattern) {
        logger.info((Object)("removeRewriteCondInDirectory (" + directoryDirective + "," + rulePattern + "," + ruleSubstitution + "," + condTestString + "," + condPattern + ")"), new Object[0]);
        String confFileLocation = this.getRewriteConfigurationFile();
        List<String> fileStringList = this.loadConfigurationFile(confFileLocation);
        LinkedList<String> newFileStringList = new LinkedList<String>();
        boolean inDirectoryDirective = false;
        String rewriteCondTmp = "";
        boolean rewriteCondMatch = false;
        ListIterator<String> iterator = fileStringList.listIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.contains("<Directory " + directoryDirective + ">")) {
                inDirectoryDirective = true;
            }
            if (string.contains("</Directory>")) {
                inDirectoryDirective = false;
            }
            if (inDirectoryDirective && string.contains("RewriteCond " + condTestString + " " + condPattern)) {
                rewriteCondTmp = string;
                rewriteCondMatch = true;
            }
            if (inDirectoryDirective && rewriteCondMatch && string.contains("RewriteRule ")) {
                if (!string.contains("RewriteRule " + rulePattern + " " + ruleSubstitution)) {
                    newFileStringList.add(rewriteCondTmp);
                }
                rewriteCondMatch = false;
            }
            if (string.contains("RewriteCond " + condTestString + " " + condPattern) && inDirectoryDirective) continue;
            newFileStringList.add(string);
        }
        this.flushConfigurationFile(confFileLocation, newFileStringList);
    }

    public void removeRewriteCondInProxy(String string, String string2, String string3, String string4, String string5) {
        if (!this.__MremoveRewriteCondInProxy$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String) {
            this.__removeRewriteCondInProxy(string, string2, string3, string4, string5);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeRewriteCondInProxy$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", new Object[]{string, string2, string3, string4, string5});
            this.__removeRewriteCondInProxy(string, string2, string3, string4, string5);
            this.__IM.onExit((Object)this, "removeRewriteCondInProxy$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeRewriteCondInProxy$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __removeRewriteCondInProxy(String proxyDirective, String rulePattern, String ruleSubstitution, String condTestString, String condPattern) {
        logger.info((Object)("removeRewriteCondInProxy (" + proxyDirective + "," + rulePattern + "," + ruleSubstitution + "," + condTestString + "," + condPattern + ")"), new Object[0]);
        String confFileLocation = this.getRewriteConfigurationFile();
        List<String> fileStringList = this.loadConfigurationFile(confFileLocation);
        LinkedList<String> newFileStringList = new LinkedList<String>();
        boolean inProxyDirective = false;
        String rewriteCondTmp = "";
        boolean rewriteCondMatch = false;
        ListIterator<String> iterator = fileStringList.listIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.contains("<Proxy " + proxyDirective + ">")) {
                inProxyDirective = true;
            }
            if (string.contains("</Proxy>")) {
                inProxyDirective = false;
            }
            if (inProxyDirective && string.contains("RewriteCond " + condTestString + " " + condPattern)) {
                rewriteCondTmp = string;
                rewriteCondMatch = true;
            }
            if (inProxyDirective && rewriteCondMatch && string.contains("RewriteRule ")) {
                if (!string.contains("RewriteRule " + rulePattern + " " + ruleSubstitution)) {
                    newFileStringList.add(rewriteCondTmp);
                }
                rewriteCondMatch = false;
            }
            if (string.contains("RewriteCond " + condTestString + " " + condPattern) && inProxyDirective) continue;
            newFileStringList.add(string);
        }
        this.flushConfigurationFile(confFileLocation, newFileStringList);
    }

    public void removeDirectoryDirective(String string) {
        if (!this.__MremoveDirectoryDirective$java_lang_String) {
            this.__removeDirectoryDirective(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeDirectoryDirective$java_lang_String", new Object[]{string});
            this.__removeDirectoryDirective(string);
            this.__IM.onExit((Object)this, "removeDirectoryDirective$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeDirectoryDirective$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __removeDirectoryDirective(String directoryDirective) {
        logger.info((Object)("removeDirectoryDirective(" + directoryDirective + ")"), new Object[0]);
        String confFileLocation = this.getRewriteConfigurationFile();
        List<String> fileStringList = this.loadConfigurationFile(confFileLocation);
        LinkedList<String> newFileStringList = new LinkedList<String>();
        boolean inDirectoryDirective = false;
        for (String string : fileStringList) {
            if (string.contains("<Directory " + directoryDirective + ">")) {
                inDirectoryDirective = true;
            }
            if (!inDirectoryDirective) {
                newFileStringList.add(string);
            }
            if (!string.contains("</Directory>")) continue;
            inDirectoryDirective = false;
        }
        this.flushConfigurationFile(confFileLocation, newFileStringList);
    }

    public void removeProxyDirective(String string) {
        if (!this.__MremoveProxyDirective$java_lang_String) {
            this.__removeProxyDirective(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeProxyDirective$java_lang_String", new Object[]{string});
            this.__removeProxyDirective(string);
            this.__IM.onExit((Object)this, "removeProxyDirective$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeProxyDirective$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __removeProxyDirective(String proxyDirective) {
        logger.info((Object)("removeProxyDirective(" + proxyDirective + ")"), new Object[0]);
        String confFileLocation = this.getRewriteConfigurationFile();
        List<String> fileStringList = this.loadConfigurationFile(confFileLocation);
        LinkedList<String> newFileStringList = new LinkedList<String>();
        boolean inProxyDirective = false;
        for (String string : fileStringList) {
            if (string.contains("<Proxy " + proxyDirective + ">")) {
                inProxyDirective = true;
            }
            if (!inProxyDirective) {
                newFileStringList.add(string);
            }
            if (!string.contains("</Proxy>")) continue;
            inProxyDirective = false;
        }
        this.flushConfigurationFile(confFileLocation, newFileStringList);
    }

    public void init(String string) {
        if (!this.__Minit$java_lang_String) {
            this.__init(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "init$java_lang_String", new Object[]{string});
            this.__init(string);
            this.__IM.onExit((Object)this, "init$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "init$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __init(String rewriteConfigurationFile) {
        this.setRewriteConfigurationFile(rewriteConfigurationFile);
        logger.info((Object)("rewriteConfigurationFile=" + rewriteConfigurationFile), new Object[0]);
    }

    private List<String> loadConfigurationFile(String string) {
        List<String> list;
        if (!this.__MloadConfigurationFile$java_lang_String) {
            return this.__loadConfigurationFile(string);
        }
        try {
            this.__IM.onEntry((Object)this, "loadConfigurationFile$java_lang_String", new Object[]{string});
            list = this.__loadConfigurationFile(string);
            this.__IM.onExit((Object)this, "loadConfigurationFile$java_lang_String", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "loadConfigurationFile$java_lang_String", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __loadConfigurationFile(String filePath) {
        LinkedList<String> fileStringList = new LinkedList<String>();
        try {
            String line;
            FileInputStream ips = new FileInputStream(filePath);
            InputStreamReader ipsr = new InputStreamReader(ips);
            BufferedReader br = new BufferedReader(ipsr);
            while ((line = br.readLine()) != null) {
                fileStringList.add(line);
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileStringList;
    }

    private void flushConfigurationFile(String string, List<String> list) {
        if (!this.__MflushConfigurationFile$java_lang_String$java_util_List) {
            this.__flushConfigurationFile(string, list);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "flushConfigurationFile$java_lang_String$java_util_List", new Object[]{string, list});
            this.__flushConfigurationFile(string, list);
            this.__IM.onExit((Object)this, "flushConfigurationFile$java_lang_String$java_util_List", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "flushConfigurationFile$java_lang_String$java_util_List", throwable);
            throw throwable;
        }
    }

    private void __flushConfigurationFile(String filePath, List<String> fileStringList) {
        try {
            FileWriter fw = new FileWriter(filePath);
            BufferedWriter bw = new BufferedWriter(fw);
            PrintWriter pw = new PrintWriter(bw);
            for (String string : fileStringList) {
                logger.info((Object)("flush : " + string), new Object[0]);
                pw.println(string);
            }
            pw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getRewriteConfigurationFile() {
        String string;
        if (!this.__MgetRewriteConfigurationFile) {
            return this.__getRewriteConfigurationFile();
        }
        try {
            this.__IM.onEntry((Object)this, "getRewriteConfigurationFile", new Object[0]);
            string = this.__getRewriteConfigurationFile();
            this.__IM.onExit((Object)this, "getRewriteConfigurationFile", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRewriteConfigurationFile", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getRewriteConfigurationFile() {
        return this.__getrewriteConfigurationFile();
    }

    public void setRewriteConfigurationFile(String string) {
        if (!this.__MsetRewriteConfigurationFile$java_lang_String) {
            this.__setRewriteConfigurationFile(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setRewriteConfigurationFile$java_lang_String", new Object[]{string});
            this.__setRewriteConfigurationFile(string);
            this.__IM.onExit((Object)this, "setRewriteConfigurationFile$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setRewriteConfigurationFile$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __setRewriteConfigurationFile(String rewriteConfigurationFile) {
        this.__setrewriteConfigurationFile(rewriteConfigurationFile);
    }

    private String getRewritePropertyFileLocation() {
        String string;
        if (!this.__MgetRewritePropertyFileLocation) {
            return this.__getRewritePropertyFileLocation();
        }
        try {
            this.__IM.onEntry((Object)this, "getRewritePropertyFileLocation", new Object[0]);
            string = this.__getRewritePropertyFileLocation();
            this.__IM.onExit((Object)this, "getRewritePropertyFileLocation", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRewritePropertyFileLocation", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getRewritePropertyFileLocation() {
        JProp prop = JProp.getInstance((String)REWRITE_MANAGER_PROPERTY_FILE_NAME);
        return prop.getValue(REWRITE_CONF_FILE_LOCATION_PROPERTY);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null && set.contains("rewriteConfigurationFile")) {
            this.__FrewriteConfigurationFile = true;
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("addRewriteRuleInDirectory$java_lang_String$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MaddRewriteRuleInDirectory$java_lang_String$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("addRewriteRuleInDirectory$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MaddRewriteRuleInDirectory$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("addRewriteRuleInProxy$java_lang_String$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MaddRewriteRuleInProxy$java_lang_String$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("addRewriteRuleInProxy$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MaddRewriteRuleInProxy$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("removeRewriteRuleInDirectory$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MremoveRewriteRuleInDirectory$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("removeRewriteRuleInProxy$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MremoveRewriteRuleInProxy$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("addRewriteBaseInDirectory$java_lang_String$java_lang_String")) {
                this.__MaddRewriteBaseInDirectory$java_lang_String$java_lang_String = true;
            }
            if (set.contains("addRewriteBaseInProxy$java_lang_String$java_lang_String")) {
                this.__MaddRewriteBaseInProxy$java_lang_String$java_lang_String = true;
            }
            if (set.contains("removeRewriteBaseInDirectory$java_lang_String$java_lang_String")) {
                this.__MremoveRewriteBaseInDirectory$java_lang_String$java_lang_String = true;
            }
            if (set.contains("removeRewriteBaseInProxy$java_lang_String$java_lang_String")) {
                this.__MremoveRewriteBaseInProxy$java_lang_String$java_lang_String = true;
            }
            if (set.contains("addRewriteCondInDirectory$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MaddRewriteCondInDirectory$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("addRewriteCondInDirectory$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MaddRewriteCondInDirectory$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("addRewriteCondInProxy$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MaddRewriteCondInProxy$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("addRewriteCondInProxy$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MaddRewriteCondInProxy$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("removeRewriteCondInDirectory$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MremoveRewriteCondInDirectory$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("removeRewriteCondInProxy$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MremoveRewriteCondInProxy$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("removeDirectoryDirective$java_lang_String")) {
                this.__MremoveDirectoryDirective$java_lang_String = true;
            }
            if (set.contains("removeProxyDirective$java_lang_String")) {
                this.__MremoveProxyDirective$java_lang_String = true;
            }
            if (set.contains("init$java_lang_String")) {
                this.__Minit$java_lang_String = true;
            }
            if (set.contains("loadConfigurationFile$java_lang_String")) {
                this.__MloadConfigurationFile$java_lang_String = true;
            }
            if (set.contains("flushConfigurationFile$java_lang_String$java_util_List")) {
                this.__MflushConfigurationFile$java_lang_String$java_util_List = true;
            }
            if (set.contains("getRewriteConfigurationFile")) {
                this.__MgetRewriteConfigurationFile = true;
            }
            if (set.contains("setRewriteConfigurationFile$java_lang_String")) {
                this.__MsetRewriteConfigurationFile$java_lang_String = true;
            }
            if (set.contains("getRewritePropertyFileLocation")) {
                this.__MgetRewritePropertyFileLocation = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

