/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.agent.utils.filesystem.discovery.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Provides;
import org.ow2.jasmine.agent.utils.filesystem.discovery.FileSystemDiscovery;
import org.ow2.jasmine.agent.utils.filesystem.discovery.impl.DirectoryFilter;
import org.ow2.jasmine.agent.utils.pattern.DiscoveryPattern;
import org.ow2.jasmine.agent.utils.pattern.PatternUtility;
import org.ow2.jonas.lib.bootstrap.JProp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(name="JASMINe Agent FileSystem Discovery")
@Provides
public class FileSystemDiscoveryImpl
implements FileSystemDiscovery,
Pojo {
    private InstanceManager __IM;
    private static final String AGENT_PROPERTIES_FILE_NAME = "agent.properties";
    private static final String BLACKLIST_KEY = "discovery.filesystem.blacklist";
    private boolean __FblackList;
    private List<String> blackList;
    private boolean __MsearchPattern$org_ow2_jasmine_agent_utils_pattern_DiscoveryPattern;
    private boolean __MscanDirectory$java_io_File$org_ow2_jasmine_agent_utils_pattern_DiscoveryPattern;
    private boolean __MisBlackListed$java_io_File;
    private boolean __MgetBlackList;

    List __getblackList() {
        if (!this.__FblackList) {
            return this.blackList;
        }
        return (List)this.__IM.onGet((Object)this, "blackList");
    }

    void __setblackList(List list) {
        if (!this.__FblackList) {
            this.blackList = list;
            return;
        }
        this.__IM.onSet((Object)this, "blackList", (Object)list);
    }

    public FileSystemDiscoveryImpl() {
        this(null);
    }

    private FileSystemDiscoveryImpl(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    @Override
    public List<File> searchPattern(DiscoveryPattern discoveryPattern) {
        List<File> list;
        if (!this.__MsearchPattern$org_ow2_jasmine_agent_utils_pattern_DiscoveryPattern) {
            return this.__searchPattern(discoveryPattern);
        }
        try {
            this.__IM.onEntry((Object)this, "searchPattern$org_ow2_jasmine_agent_utils_pattern_DiscoveryPattern", new Object[]{discoveryPattern});
            list = this.__searchPattern(discoveryPattern);
            this.__IM.onExit((Object)this, "searchPattern$org_ow2_jasmine_agent_utils_pattern_DiscoveryPattern", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "searchPattern$org_ow2_jasmine_agent_utils_pattern_DiscoveryPattern", throwable);
            throw throwable;
        }
        return list;
    }

    private List<File> __searchPattern(DiscoveryPattern pattern) {
        ArrayList<File> result = new ArrayList<File>();
        this.__setblackList(this.getBlackList());
        for (File root : File.listRoots()) {
            result.addAll(this.scanDirectory(root, pattern));
        }
        return result;
    }

    public List<File> scanDirectory(File file, DiscoveryPattern discoveryPattern) {
        List<File> list;
        if (!this.__MscanDirectory$java_io_File$org_ow2_jasmine_agent_utils_pattern_DiscoveryPattern) {
            return this.__scanDirectory(file, discoveryPattern);
        }
        try {
            this.__IM.onEntry((Object)this, "scanDirectory$java_io_File$org_ow2_jasmine_agent_utils_pattern_DiscoveryPattern", new Object[]{file, discoveryPattern});
            list = this.__scanDirectory(file, discoveryPattern);
            this.__IM.onExit((Object)this, "scanDirectory$java_io_File$org_ow2_jasmine_agent_utils_pattern_DiscoveryPattern", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "scanDirectory$java_io_File$org_ow2_jasmine_agent_utils_pattern_DiscoveryPattern", throwable);
            throw throwable;
        }
        return list;
    }

    private List<File> __scanDirectory(File directory, DiscoveryPattern pattern) {
        ArrayList<File> result = new ArrayList<File>();
        try {
            for (File dir : directory.listFiles(DirectoryFilter.getInstance())) {
                if (this.isBlackListed(dir)) continue;
                result.addAll(this.scanDirectory(dir, pattern));
            }
            if (PatternUtility.matchPattern(directory, pattern.getChildList())) {
                result.add(directory);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    private boolean isBlackListed(File file) {
        boolean bl;
        if (!this.__MisBlackListed$java_io_File) {
            return this.__isBlackListed(file);
        }
        try {
            this.__IM.onEntry((Object)this, "isBlackListed$java_io_File", new Object[]{file});
            bl = this.__isBlackListed(file);
            this.__IM.onExit((Object)this, "isBlackListed$java_io_File", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isBlackListed$java_io_File", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __isBlackListed(File dir) {
        String name = dir.getAbsolutePath();
        for (String black : this.__getblackList()) {
            if (!name.startsWith(black)) continue;
            return true;
        }
        return false;
    }

    private List<String> getBlackList() {
        List<String> list;
        if (!this.__MgetBlackList) {
            return this.__getBlackList();
        }
        try {
            this.__IM.onEntry((Object)this, "getBlackList", new Object[0]);
            list = this.__getBlackList();
            this.__IM.onExit((Object)this, "getBlackList", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getBlackList", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __getBlackList() {
        ArrayList<String> blacklist = new ArrayList<String>();
        try {
            new JProp();
            JProp props = JProp.getInstance((String)AGENT_PROPERTIES_FILE_NAME);
            String list = props.getValue(BLACKLIST_KEY);
            StringTokenizer tokenizer = new StringTokenizer(list, ",");
            while (tokenizer.hasMoreTokens()) {
                blacklist.add(tokenizer.nextToken());
            }
            return blacklist;
        }
        catch (Exception e) {
            return new ArrayList<String>();
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null && set.contains("blackList")) {
            this.__FblackList = true;
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("searchPattern$org_ow2_jasmine_agent_utils_pattern_DiscoveryPattern")) {
                this.__MsearchPattern$org_ow2_jasmine_agent_utils_pattern_DiscoveryPattern = true;
            }
            if (set.contains("scanDirectory$java_io_File$org_ow2_jasmine_agent_utils_pattern_DiscoveryPattern")) {
                this.__MscanDirectory$java_io_File$org_ow2_jasmine_agent_utils_pattern_DiscoveryPattern = true;
            }
            if (set.contains("isBlackListed$java_io_File")) {
                this.__MisBlackListed$java_io_File = true;
            }
            if (set.contains("getBlackList")) {
                this.__MgetBlackList = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

