/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.agent.utils.pattern;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.ow2.jasmine.agent.common.utils.Utilities;
import org.ow2.jasmine.agent.utils.filesystem.discovery.impl.CustomFileFilter;
import org.ow2.jasmine.agent.utils.pattern.Child;
import org.ow2.jasmine.agent.utils.pattern.ChildType;
import org.ow2.jasmine.agent.utils.pattern.DiscoveryPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternUtility {
    public static DiscoveryPattern convertFileToPattern(File patternFile) {
        SAXBuilder sxb = new SAXBuilder();
        Document document = null;
        try {
            document = sxb.build(patternFile);
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (document != null) {
            Element racine = document.getRootElement();
            return new DiscoveryPattern(PatternUtility.getChildren(racine));
        }
        return null;
    }

    public static List<Child> getChildren(Element el) {
        LinkedList<Child> childList = new LinkedList<Child>();
        for (Object obj : el.getChildren()) {
            Element element = (Element)obj;
            Child c = new Child(element.getAttributeValue("name"), PatternUtility.convertStringToChildType(element.getName()));
            c.setChildren(PatternUtility.getChildren(element));
            childList.add(c);
        }
        return childList;
    }

    public static ChildType convertStringToChildType(String type) {
        if (type.equalsIgnoreCase("file")) {
            return ChildType.FILE;
        }
        if (type.equalsIgnoreCase("dir")) {
            return ChildType.DIRECTORY;
        }
        return null;
    }

    public static boolean matchPattern(File directory, List<Child> childList) {
        if (childList.size() == 0) {
            return true;
        }
        boolean result = true;
        Iterator<Child> iterator = childList.iterator();
        while (iterator.hasNext() && result) {
            Child c = iterator.next();
            File[] childFiles = directory.listFiles(new CustomFileFilter(c));
            if (childFiles.length == 1) {
                result = PatternUtility.matchPattern(childFiles[0], c.getChildren());
                continue;
            }
            result = false;
        }
        if (iterator.hasNext()) {
            return false;
        }
        return result;
    }

    public static boolean matchPattern(File directory, DiscoveryPattern pattern) {
        return PatternUtility.matchPattern(directory, pattern.getChildList());
    }

    public static DiscoveryPattern convertFileToPattern(InputStream resourceAsStream) {
        File f = Utilities.convertStreamToFile((InputStream)resourceAsStream);
        DiscoveryPattern p = PatternUtility.convertFileToPattern(f);
        f.delete();
        return p;
    }
}

