/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.agent.remote.discovery;

import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.ow2.jasmine.agent.common.discovery.AgentDiscoveryService;
import org.ow2.jasmine.agent.common.discovery.SystemProperties;
import org.ow2.jasmine.agent.common.utils.Utilities;
import org.ow2.jasmine.agent.remote.discovery.system.SystemDiscovery;
import org.ow2.jonas.lib.bootstrap.JProp;

@Component(name="JASMINe Agent Discovery Registrer", propagation=true)
@Provides
public class DiscoveryRegistrer
implements AgentDiscoveryService,
Pojo {
    private InstanceManager __IM;
    private boolean __Fid;
    @ServiceProperty
    public UUID id;
    public static UUID agentId = null;
    private boolean __MgenerateAgentId;
    private boolean __MgetId;
    private boolean __MgetSystemProperties;

    UUID __getid() {
        if (!this.__Fid) {
            return this.id;
        }
        return (UUID)this.__IM.onGet((Object)this, "id");
    }

    void __setid(UUID uUID) {
        if (!this.__Fid) {
            this.id = uUID;
            return;
        }
        this.__IM.onSet((Object)this, "id", (Object)uUID);
    }

    public DiscoveryRegistrer() {
        this(null);
    }

    private DiscoveryRegistrer(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setid(this.generateAgentId());
    }

    public UUID generateAgentId() {
        UUID uUID;
        if (!this.__MgenerateAgentId) {
            return this.__generateAgentId();
        }
        try {
            this.__IM.onEntry((Object)this, "generateAgentId", new Object[0]);
            uUID = this.__generateAgentId();
            this.__IM.onExit((Object)this, "generateAgentId", (Object)uUID);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "generateAgentId", throwable);
            throw throwable;
        }
        return uUID;
    }

    private UUID __generateAgentId() {
        File conf = new File(JProp.getJonasBase(), "conf");
        File idFile = new File(conf, "agent.id");
        if (idFile.exists()) {
            List list = Utilities.readFile((File)idFile);
            agentId = UUID.fromString((String)list.get(0));
        } else {
            agentId = UUID.randomUUID();
            Utilities.writeInFile((String)agentId.toString(), (File)idFile);
        }
        return agentId;
    }

    public String getId() {
        String string;
        if (!this.__MgetId) {
            return this.__getId();
        }
        try {
            this.__IM.onEntry((Object)this, "getId", new Object[0]);
            string = this.__getId();
            this.__IM.onExit((Object)this, "getId", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getId", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getId() {
        return DiscoveryRegistrer.staticGetId().toString();
    }

    public static UUID staticGetId() {
        return agentId;
    }

    public SystemProperties getSystemProperties() {
        SystemProperties systemProperties;
        if (!this.__MgetSystemProperties) {
            return this.__getSystemProperties();
        }
        try {
            this.__IM.onEntry((Object)this, "getSystemProperties", new Object[0]);
            systemProperties = this.__getSystemProperties();
            this.__IM.onExit((Object)this, "getSystemProperties", (Object)systemProperties);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getSystemProperties", throwable);
            throw throwable;
        }
        return systemProperties;
    }

    private SystemProperties __getSystemProperties() {
        return new SystemDiscovery().getSystemProperties();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null && set.contains("id")) {
            this.__Fid = true;
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("generateAgentId")) {
                this.__MgenerateAgentId = true;
            }
            if (set.contains("getId")) {
                this.__MgetId = true;
            }
            if (set.contains("getSystemProperties")) {
                this.__MgetSystemProperties = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

