/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.agent.remote.discovery.system;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import org.ow2.jasmine.agent.common.discovery.Interface;
import org.ow2.jasmine.agent.common.discovery.SystemProperties;
import org.ow2.jasmine.agent.common.utils.Utilities;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemDiscovery {
    private static Log logger = LogFactory.getLog(SystemDiscovery.class);

    public SystemProperties getSystemProperties() {
        SystemProperties props = new SystemProperties(System.getProperty("os.name", ""), System.getProperty("os.version", ""), System.getProperty("os.arch", ""), Runtime.getRuntime().availableProcessors(), this.getLinuxDistribution(), this.getIP(), this.getNetworkInterfaces(), this.getHostname(), this.getInstanceName());
        return props;
    }

    private String getInstanceName() {
        return JProp.getInstance().getServerName();
    }

    private String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            logger.error((Object)"Error while getting the hostname", new Object[0]);
            return "";
        }
    }

    private String getIP() {
        try {
            return SystemDiscovery.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            logger.error((Object)"Error while getting the ip address", new Object[0]);
            return "";
        }
    }

    private List<Interface> getNetworkInterfaces() {
        ArrayList<Interface> interfaces = new ArrayList<Interface>();
        Enumeration<NetworkInterface> e = null;
        try {
            e = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            logger.error((Object)"Error while getting network interfaces", new Object[0]);
            return new ArrayList<Interface>();
        }
        while (e.hasMoreElements()) {
            NetworkInterface ni = e.nextElement();
            Interface n = new Interface();
            n.setIpAddress(ni.getInetAddresses().nextElement().getHostAddress());
            n.setName(ni.getName());
            n.setMacAddress("");
            interfaces.add(n);
        }
        return interfaces;
    }

    public String getLinuxDistribution() {
        String res = "";
        if (!System.getProperty("os.name").startsWith("Win")) {
            try {
                Process p = Runtime.getRuntime().exec("cat /etc/issue");
                File f = Utilities.convertStreamToFile((InputStream)p.getInputStream());
                List list = Utilities.readFile((File)f);
                res = (String)list.get(0);
                if (res == null || res.length() <= 0) {
                    res = "";
                } else {
                    String res2 = "";
                    StringTokenizer tokenizer = new StringTokenizer(res, "\\");
                    res = res2 = tokenizer.nextToken();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        InetAddress localHost = InetAddress.getLocalHost();
        if (!localHost.isLoopbackAddress()) {
            return localHost;
        }
        InetAddress[] addrs = SystemDiscovery.getAllLocalUsingNetworkInterface();
        for (int i = 0; i < addrs.length; ++i) {
            if (addrs[i].isLoopbackAddress() || addrs[i].getHostAddress().contains(":")) continue;
            return addrs[i];
        }
        return localHost;
    }

    private static InetAddress[] getAllLocalUsingNetworkInterface() throws UnknownHostException {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> e = null;
        try {
            e = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            throw new UnknownHostException("127.0.0.1");
        }
        while (e.hasMoreElements()) {
            NetworkInterface ni = e.nextElement();
            Enumeration<InetAddress> e2 = ni.getInetAddresses();
            while (e2.hasMoreElements()) {
                addresses.add(e2.nextElement());
            }
        }
        InetAddress[] iAddresses = new InetAddress[addresses.size()];
        for (int i = 0; i < iAddresses.length; ++i) {
            iAddresses[i] = (InetAddress)addresses.get(i);
        }
        return iAddresses;
    }
}

